/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentNodeBuilder
extends MemoryNodeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentNodeBuilder.class);
    private static final int UPDATE_LIMIT = Integer.getInteger("update.limit", 10000);
    @Nullable
    private final BlobStore blobStore;
    @Nonnull
    private final SegmentReader reader;
    @Nonnull
    private final SegmentWriter writer;
    private long updateCount;

    SegmentNodeBuilder(@Nonnull SegmentNodeState base, @Nullable BlobStore blobStore, @Nonnull SegmentReader reader, @Nonnull SegmentWriter writer) {
        super((NodeState)base);
        this.blobStore = blobStore;
        this.reader = reader;
        this.writer = (SegmentWriter)Preconditions.checkNotNull((Object)writer);
        this.updateCount = 0L;
    }

    private SegmentNodeBuilder(@Nonnull SegmentNodeBuilder parent, @Nonnull String name, @Nullable BlobStore blobStore, @Nonnull SegmentReader reader, @Nonnull SegmentWriter writer) {
        super((MemoryNodeBuilder)parent, name);
        this.blobStore = blobStore;
        this.reader = reader;
        this.writer = (SegmentWriter)Preconditions.checkNotNull((Object)writer);
        this.updateCount = -1L;
    }

    boolean isRootBuilder() {
        return this.isRoot();
    }

    protected void updated() {
        if (this.isChildBuilder()) {
            super.updated();
        } else {
            ++this.updateCount;
            if (this.updateCount > (long)UPDATE_LIMIT) {
                this.getNodeState();
            }
        }
    }

    private boolean isChildBuilder() {
        return this.updateCount < 0L;
    }

    @Nonnull
    public SegmentNodeState getNodeState() {
        try {
            NodeState state = super.getNodeState();
            SegmentNodeState sState = new SegmentNodeState(this.reader, this.writer, this.blobStore, this.writer.writeNode(state));
            if (state != sState) {
                this.set(sState);
                if (!this.isChildBuilder()) {
                    this.updateCount = 0L;
                }
            }
            return sState;
        }
        catch (IOException e) {
            LOG.error("Error flushing changes", (Throwable)e);
            throw new IllegalStateException("Unexpected IOException", e);
        }
    }

    protected MemoryNodeBuilder createChildBuilder(String name) {
        return new SegmentNodeBuilder(this, name, this.blobStore, this.reader, this.writer);
    }

    public Blob createBlob(InputStream stream) throws IOException {
        return new SegmentBlob(this.blobStore, this.writer.writeStream(stream));
    }
}

