/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentId
implements Comparable<SegmentId> {
    public static final SegmentId NULL = new SegmentId(SegmentStore.EMPTY_STORE, 0L, 0L);
    private static final Logger log = LoggerFactory.getLogger(SegmentId.class);
    @Nonnull
    private final SegmentStore store;
    private final long msb;
    private final long lsb;
    private final long creationTime;
    private final Runnable onAccess;
    @CheckForNull
    private GCGeneration gcGeneration;
    @CheckForNull
    private String gcInfo;
    private volatile Segment segment;

    public static boolean isDataSegmentId(long lsb) {
        return lsb >>> 60 == 10L;
    }

    public SegmentId(@Nonnull SegmentStore store, long msb, long lsb, @Nonnull Runnable onAccess) {
        this.store = store;
        this.msb = msb;
        this.lsb = lsb;
        this.onAccess = onAccess;
        this.creationTime = System.currentTimeMillis();
    }

    public SegmentId(@Nonnull SegmentStore store, long msb, long lsb) {
        this(store, msb, lsb, () -> {});
    }

    public boolean isDataSegmentId() {
        return SegmentId.isDataSegmentId(this.lsb);
    }

    public boolean isBulkSegmentId() {
        return this.lsb >>> 60 == 11L;
    }

    public long getMostSignificantBits() {
        return this.msb;
    }

    public long getLeastSignificantBits() {
        return this.lsb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Segment getSegment() {
        Segment segment = this.segment;
        if (segment == null) {
            SegmentId segmentId = this;
            synchronized (segmentId) {
                segment = this.segment;
                if (segment == null) {
                    log.debug("Loading segment {}", (Object)this);
                    return this.store.readSegment(this);
                }
            }
        }
        this.onAccess.run();
        return segment;
    }

    @Nonnull
    String gcInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("SegmentId age=").append(System.currentTimeMillis() - this.creationTime).append("ms");
        if (this.gcInfo != null) {
            sb.append(",").append(this.gcInfo);
        }
        if (this.gcGeneration != null) {
            sb.append(",").append("segment-generation=").append(this.gcGeneration);
        }
        return sb.toString();
    }

    @CheckForNull
    String getGcInfo() {
        return this.gcInfo;
    }

    public void reclaimed(@Nonnull String gcInfo) {
        this.gcInfo = gcInfo;
    }

    void loaded(@Nonnull Segment segment) {
        this.segment = segment;
        this.gcGeneration = segment.getGcGeneration();
    }

    void unloaded() {
        this.segment = null;
    }

    public boolean sameStore(@Nonnull SegmentStore store) {
        return this.store == store;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public UUID asUUID() {
        return new UUID(this.msb, this.lsb);
    }

    @Nonnull
    public GCGeneration getGcGeneration() {
        if (this.gcGeneration == null) {
            this.getSegment();
        }
        return this.gcGeneration;
    }

    @Override
    public int compareTo(@Nonnull SegmentId that) {
        int d = Long.valueOf(this.msb).compareTo(that.msb);
        if (d == 0) {
            d = Long.valueOf(this.lsb).compareTo(that.lsb);
        }
        return d;
    }

    public String toString() {
        return new UUID(this.msb, this.lsb).toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SegmentId) {
            SegmentId that = (SegmentId)object;
            return this.msb == that.msb && this.lsb == that.lsb;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.lsb;
    }

    public int estimateMemoryUsage() {
        int size = 12;
        size += 48;
        return size += StringUtils.estimateMemoryUsage((String)this.gcInfo);
    }
}

