/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.AbstractCacheStats;
import org.apache.jackrabbit.oak.segment.CacheWeights;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;

public class SegmentCache {
    public static final int DEFAULT_SEGMENT_CACHE_MB = 256;
    private final long maximumWeight;
    @Nonnull
    private final Cache<SegmentId, Segment> cache;
    @Nonnull
    private final Stats stats = new Stats("Segment Cache");

    public SegmentCache(long cacheSizeMB) {
        this.maximumWeight = cacheSizeMB * 1024L * 1024L;
        this.cache = CacheBuilder.newBuilder().concurrencyLevel(16).maximumWeight(this.maximumWeight).weigher((Weigher)new CacheWeights.SegmentCacheWeigher()).removalListener(this::onRemove).build();
    }

    private void onRemove(@Nonnull RemovalNotification<SegmentId, Segment> notification) {
        this.stats.evictionCount.incrementAndGet();
        if (notification.getValue() != null) {
            this.stats.currentWeight.addAndGet(-CacheWeights.segmentWeight((Segment)notification.getValue()));
        }
        if (notification.getKey() != null) {
            ((SegmentId)notification.getKey()).unloaded();
        }
    }

    @Nonnull
    public Segment getSegment(@Nonnull SegmentId id, @Nonnull Callable<Segment> loader) throws ExecutionException {
        if (id.isDataSegmentId()) {
            return (Segment)this.cache.get((Object)id, () -> {
                try {
                    long t0 = System.nanoTime();
                    Segment segment = (Segment)loader.call();
                    this.stats.loadSuccessCount.incrementAndGet();
                    this.stats.loadTime.addAndGet(System.nanoTime() - t0);
                    this.stats.missCount.incrementAndGet();
                    this.stats.currentWeight.addAndGet(CacheWeights.segmentWeight(segment));
                    id.loaded(segment);
                    return segment;
                }
                catch (Exception e) {
                    this.stats.loadExceptionCount.incrementAndGet();
                    throw e;
                }
            });
        }
        try {
            return loader.call();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public void putSegment(@Nonnull Segment segment) {
        SegmentId id = segment.getSegmentId();
        if (id.isDataSegmentId()) {
            id.loaded(segment);
            this.stats.currentWeight.addAndGet(CacheWeights.segmentWeight(segment));
            this.cache.put((Object)id, (Object)segment);
        }
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    @Nonnull
    public AbstractCacheStats getCacheStats() {
        return this.stats;
    }

    public void recordHit() {
        this.stats.hitCount.incrementAndGet();
    }

    private class Stats
    extends AbstractCacheStats {
        @Nonnull
        final AtomicLong currentWeight;
        @Nonnull
        final AtomicLong loadSuccessCount;
        @Nonnull
        final AtomicInteger loadExceptionCount;
        @Nonnull
        final AtomicLong loadTime;
        @Nonnull
        final AtomicLong evictionCount;
        @Nonnull
        final AtomicLong hitCount;
        @Nonnull
        final AtomicLong missCount;

        protected Stats(String name) {
            super(name);
            this.currentWeight = new AtomicLong();
            this.loadSuccessCount = new AtomicLong();
            this.loadExceptionCount = new AtomicInteger();
            this.loadTime = new AtomicLong();
            this.evictionCount = new AtomicLong();
            this.hitCount = new AtomicLong();
            this.missCount = new AtomicLong();
        }

        protected CacheStats getCurrentStats() {
            return new CacheStats(this.hitCount.get(), this.missCount.get(), this.loadSuccessCount.get(), (long)this.loadExceptionCount.get(), this.loadTime.get(), this.evictionCount.get());
        }

        public long getElementCount() {
            return SegmentCache.this.cache.size();
        }

        public long getMaxTotalWeight() {
            return SegmentCache.this.maximumWeight;
        }

        public long estimateCurrentWeight() {
            return this.currentWeight.get();
        }
    }
}

