/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;

class Registrations {
    private final Whiteboard whiteboard;
    private final String role;

    Registrations(Whiteboard whiteboard, String role) {
        this.whiteboard = whiteboard;
        this.role = role;
    }

    <T> Registration registerMBean(Class<T> clazz, T bean, String type, String name) {
        return this.registerMBean(clazz, bean, type, name, new HashMap<String, String>());
    }

    <T> Registration registerMBean(Class<T> clazz, T bean, String type, String name, Map<String, String> attributes) {
        return WhiteboardUtils.registerMBean((Whiteboard)this.whiteboard, clazz, bean, (String)type, (String)this.maybeAppendRole(name), this.maybePutRoleAttribute(attributes));
    }

    <T> Registration register(Class<T> clazz, T service) {
        return this.register(clazz, service, new HashMap<String, Object>());
    }

    <T> Registration register(Class<T> clazz, T service, Map<String, Object> properties) {
        return this.whiteboard.register(clazz, service, this.maybePutRoleProperty(properties));
    }

    private String maybeAppendRole(String name) {
        if (this.role != null) {
            return name + " - " + this.role;
        }
        return name;
    }

    private String jmxRole() {
        return this.role.replaceAll(":", "-");
    }

    private Map<String, String> maybePutRoleAttribute(Map<String, String> attributes) {
        if (this.role != null) {
            attributes.put("role", this.jmxRole());
        }
        return attributes;
    }

    private Map<String, Object> maybePutRoleProperty(Map<String, Object> attributes) {
        if (this.role != null) {
            attributes.put("role", this.role);
        }
        return attributes;
    }
}

