/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;

class MapEntry
extends AbstractChildNodeEntry
implements Map.Entry<RecordId, RecordId>,
Comparable<MapEntry> {
    @Nonnull
    private final SegmentReader reader;
    @Nonnull
    private final String name;
    @Nonnull
    private final RecordId key;
    @CheckForNull
    private final RecordId value;

    private MapEntry(@Nonnull SegmentReader reader, @Nonnull String name, @Nonnull RecordId key, @Nullable RecordId value) {
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.key = (RecordId)Preconditions.checkNotNull((Object)key);
        this.value = value;
    }

    static MapEntry newMapEntry(@Nonnull SegmentReader reader, @Nonnull String name, @Nonnull RecordId key, @Nonnull RecordId value) {
        return new MapEntry(reader, name, key, (RecordId)Preconditions.checkNotNull((Object)value));
    }

    static MapEntry newModifiedMapEntry(@Nonnull SegmentReader reader, @Nonnull String name, @Nonnull RecordId key, @Nullable RecordId value) {
        return new MapEntry(reader, name, key, value);
    }

    public int getHash() {
        return MapRecord.getHash(this.name);
    }

    boolean isDeleted() {
        return this.value == null;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public SegmentNodeState getNodeState() {
        Preconditions.checkState((this.value != null ? 1 : 0) != 0);
        return this.reader.readNode(this.value);
    }

    @Override
    @Nonnull
    public RecordId getKey() {
        return this.key;
    }

    @Override
    @Nonnull
    public RecordId getValue() {
        Preconditions.checkState((this.value != null ? 1 : 0) != 0);
        return this.value;
    }

    @Override
    public RecordId setValue(RecordId value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(@Nonnull MapEntry that) {
        return ComparisonChain.start().compare((long)this.getHash() & 0xFFFFFFFFL, (long)that.getHash() & 0xFFFFFFFFL).compare((Comparable)((Object)this.name), (Comparable)((Object)that.name)).compare((Object)this.value, (Object)that.value, (Comparator)Ordering.natural().nullsLast()).result();
    }
}

