/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.RecordNumbers;
import org.apache.jackrabbit.oak.segment.RecordType;

class ImmutableRecordNumbers
implements RecordNumbers {
    @Nonnull
    private final int[] offsets;
    @Nonnull
    private final byte[] type;

    public ImmutableRecordNumbers(@Nonnull int[] offsets, @Nonnull byte[] type) {
        this.offsets = offsets;
        this.type = type;
    }

    @Override
    public int getOffset(int recordNumber) {
        if (recordNumber < this.offsets.length) {
            return this.offsets[recordNumber];
        }
        return -1;
    }

    @Override
    @Nonnull
    public Iterator<RecordNumbers.Entry> iterator() {
        return new AbstractIterator<RecordNumbers.Entry>(){
            private int pos = -1;

            protected RecordNumbers.Entry computeNext() {
                while (++this.pos < ImmutableRecordNumbers.this.offsets.length && ImmutableRecordNumbers.this.offsets[this.pos] < 0) {
                }
                if (this.pos < ImmutableRecordNumbers.this.offsets.length) {
                    return new RecordNumbers.Entry(){

                        @Override
                        public int getRecordNumber() {
                            return pos;
                        }

                        @Override
                        public int getOffset() {
                            return ImmutableRecordNumbers.this.offsets[pos];
                        }

                        @Override
                        public RecordType getType() {
                            return RecordType.values()[ImmutableRecordNumbers.this.type[pos]];
                        }
                    };
                }
                return (RecordNumbers.Entry)this.endOfData();
            }
        };
    }
}

