/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.DefaultSegmentWriter;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriter;
import org.apache.jackrabbit.oak.segment.SegmentBufferWriterPool;
import org.apache.jackrabbit.oak.segment.SegmentStore;
import org.apache.jackrabbit.oak.segment.WriteOperationHandler;
import org.apache.jackrabbit.oak.segment.WriterCacheManager;
import org.apache.jackrabbit.oak.segment.file.FileStore;
import org.apache.jackrabbit.oak.segment.file.ReadOnlyFileStore;
import org.apache.jackrabbit.oak.segment.file.tar.GCGeneration;
import org.apache.jackrabbit.oak.segment.memory.MemoryStore;

public final class DefaultSegmentWriterBuilder {
    @Nonnull
    private final String name;
    @Nonnull
    private Supplier<GCGeneration> generation = Suppliers.ofInstance((Object)GCGeneration.NULL);
    private boolean pooled = false;
    @Nonnull
    private WriterCacheManager cacheManager = new WriterCacheManager.Default();

    private DefaultSegmentWriterBuilder(@Nonnull String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    @Nonnull
    public static DefaultSegmentWriterBuilder defaultSegmentWriterBuilder(@Nonnull String name) {
        return new DefaultSegmentWriterBuilder(name);
    }

    @Nonnull
    public DefaultSegmentWriterBuilder withGeneration(@Nonnull Supplier<GCGeneration> generation) {
        this.generation = (Supplier)Preconditions.checkNotNull(generation);
        return this;
    }

    @Nonnull
    public DefaultSegmentWriterBuilder withGeneration(@Nonnull GCGeneration generation) {
        this.generation = Suppliers.ofInstance((Object)Preconditions.checkNotNull((Object)generation));
        return this;
    }

    @Nonnull
    public DefaultSegmentWriterBuilder withWriterPool() {
        this.pooled = true;
        return this;
    }

    @Nonnull
    public DefaultSegmentWriterBuilder withoutWriterPool() {
        this.pooled = false;
        return this;
    }

    @Nonnull
    public DefaultSegmentWriterBuilder with(WriterCacheManager cacheManager) {
        this.cacheManager = (WriterCacheManager)Preconditions.checkNotNull((Object)cacheManager);
        return this;
    }

    @Nonnull
    public DefaultSegmentWriterBuilder withoutCache() {
        this.cacheManager = WriterCacheManager.Empty.INSTANCE;
        return this;
    }

    @Nonnull
    public DefaultSegmentWriter build(@Nonnull FileStore store) {
        return new DefaultSegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getSegmentIdProvider(), store.getBlobStore(), this.cacheManager, this.createWriter(store, this.pooled));
    }

    @Nonnull
    public DefaultSegmentWriter build(@Nonnull ReadOnlyFileStore store) {
        return new DefaultSegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getSegmentIdProvider(), store.getBlobStore(), this.cacheManager, new WriteOperationHandler(){

            @Override
            @Nonnull
            public RecordId execute(@Nonnull WriteOperationHandler.WriteOperation writeOperation) {
                throw new UnsupportedOperationException("Cannot write to read-only store");
            }

            @Override
            public void flush(@Nonnull SegmentStore store) {
                throw new UnsupportedOperationException("Cannot write to read-only store");
            }
        });
    }

    @Nonnull
    public DefaultSegmentWriter build(@Nonnull MemoryStore store) {
        return new DefaultSegmentWriter((SegmentStore)Preconditions.checkNotNull((Object)store), store.getReader(), store.getSegmentIdProvider(), store.getBlobStore(), this.cacheManager, this.createWriter(store, this.pooled));
    }

    @Nonnull
    private WriteOperationHandler createWriter(@Nonnull FileStore store, boolean pooled) {
        if (pooled) {
            return new SegmentBufferWriterPool(store.getSegmentIdProvider(), store.getReader(), this.name, this.generation);
        }
        return new SegmentBufferWriter(store.getSegmentIdProvider(), store.getReader(), this.name, (GCGeneration)this.generation.get());
    }

    @Nonnull
    private WriteOperationHandler createWriter(@Nonnull MemoryStore store, boolean pooled) {
        if (pooled) {
            return new SegmentBufferWriterPool(store.getSegmentIdProvider(), store.getReader(), this.name, this.generation);
        }
        return new SegmentBufferWriter(store.getSegmentIdProvider(), store.getReader(), this.name, (GCGeneration)this.generation.get());
    }
}

