/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.MultiBinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.segment.CancelableDiff;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class Compactor {
    static final int UPDATE_LIMIT = Integer.getInteger("compaction.update.limit", 10000);
    @Nonnull
    private final SegmentWriter writer;
    @Nonnull
    private final SegmentReader reader;
    @Nullable
    private final BlobStore blobStore;
    @Nonnull
    private final Supplier<Boolean> cancel;
    @Nonnull
    private final GCNodeWriteMonitor compactionMonitor;

    public Compactor(@Nonnull SegmentReader reader, @Nonnull SegmentWriter writer, @Nullable BlobStore blobStore, @Nonnull Supplier<Boolean> cancel, @Nonnull GCNodeWriteMonitor compactionMonitor) {
        this.writer = (SegmentWriter)Preconditions.checkNotNull((Object)writer);
        this.reader = (SegmentReader)Preconditions.checkNotNull((Object)reader);
        this.blobStore = blobStore;
        this.cancel = (Supplier)Preconditions.checkNotNull(cancel);
        this.compactionMonitor = (GCNodeWriteMonitor)Preconditions.checkNotNull((Object)compactionMonitor);
    }

    @CheckForNull
    public SegmentNodeState compact(@Nonnull NodeState state) throws IOException {
        return this.compact(EmptyNodeState.EMPTY_NODE, state, EmptyNodeState.EMPTY_NODE);
    }

    @CheckForNull
    public SegmentNodeState compact(@Nonnull NodeState before, @Nonnull NodeState after, @Nonnull NodeState onto) throws IOException {
        Preconditions.checkNotNull((Object)before);
        Preconditions.checkNotNull((Object)after);
        Preconditions.checkNotNull((Object)onto);
        return new CompactDiff(onto).diff(before, after);
    }

    @CheckForNull
    private static ByteBuffer getStableIdBytes(NodeState state) {
        if (state instanceof SegmentNodeState) {
            return ((SegmentNodeState)state).getStableIdBytes();
        }
        return null;
    }

    @Nonnull
    private PropertyState compact(@Nonnull PropertyState property) {
        this.compactionMonitor.onProperty();
        String name = property.getName();
        Type type = property.getType();
        if (type == Type.BINARY) {
            this.compactionMonitor.onBinary();
            return BinaryPropertyState.binaryProperty((String)name, (Blob)((Blob)property.getValue(Type.BINARY)));
        }
        if (type == Type.BINARIES) {
            ArrayList blobs = Lists.newArrayList();
            for (Blob blob : (Iterable)property.getValue(Type.BINARIES)) {
                this.compactionMonitor.onBinary();
                blobs.add(blob);
            }
            return MultiBinaryPropertyState.binaryPropertyFromBlob((String)name, (Iterable)blobs);
        }
        return PropertyStates.createProperty((String)name, (Object)property.getValue(type), (Type)type);
    }

    private class CompactDiff
    implements NodeStateDiff {
        @Nonnull
        private MemoryNodeBuilder builder;
        @Nonnull
        private final NodeState base;
        @CheckForNull
        private IOException exception;
        private long modCount;

        private void updated() throws IOException {
            if (++this.modCount % (long)UPDATE_LIMIT == 0L) {
                RecordId newBaseId = Compactor.this.writer.writeNode(this.builder.getNodeState(), null);
                SegmentNodeState newBase = new SegmentNodeState(Compactor.this.reader, Compactor.this.writer, Compactor.this.blobStore, newBaseId);
                this.builder = new MemoryNodeBuilder((NodeState)newBase);
            }
        }

        CompactDiff(NodeState base) {
            this.builder = new MemoryNodeBuilder((NodeState)Preconditions.checkNotNull((Object)base));
            this.base = base;
        }

        @CheckForNull
        SegmentNodeState diff(@Nonnull NodeState before, @Nonnull NodeState after) throws IOException {
            boolean success = after.compareAgainstBaseState(before, (NodeStateDiff)new CancelableDiff(this, (Supplier<Boolean>)Compactor.this.cancel));
            if (this.exception != null) {
                throw new IOException(this.exception);
            }
            if (success) {
                NodeState nodeState = this.builder.getNodeState();
                Preconditions.checkState((this.modCount == 0L || !(nodeState instanceof SegmentNodeState) ? 1 : 0) != 0);
                RecordId nodeId = Compactor.this.writer.writeNode(nodeState, Compactor.getStableIdBytes(after));
                Compactor.this.compactionMonitor.onNode();
                return new SegmentNodeState(Compactor.this.reader, Compactor.this.writer, Compactor.this.blobStore, nodeId);
            }
            return null;
        }

        public boolean propertyAdded(@Nonnull PropertyState after) {
            this.builder.setProperty(Compactor.this.compact(after));
            return true;
        }

        public boolean propertyChanged(@Nonnull PropertyState before, @Nonnull PropertyState after) {
            this.builder.setProperty(Compactor.this.compact(after));
            return true;
        }

        public boolean propertyDeleted(PropertyState before) {
            this.builder.removeProperty(before.getName());
            return true;
        }

        public boolean childNodeAdded(@Nonnull String name, @Nonnull NodeState after) {
            try {
                SegmentNodeState compacted = Compactor.this.compact(after);
                if (compacted != null) {
                    this.updated();
                    this.builder.setChildNode(name, (NodeState)compacted);
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                this.exception = e;
                return false;
            }
        }

        public boolean childNodeChanged(@Nonnull String name, @Nonnull NodeState before, @Nonnull NodeState after) {
            try {
                SegmentNodeState compacted = Compactor.this.compact(before, after, this.base.getChildNode(name));
                if (compacted != null) {
                    this.updated();
                    this.builder.setChildNode(name, (NodeState)compacted);
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                this.exception = e;
                return false;
            }
        }

        public boolean childNodeDeleted(String name, NodeState before) {
            try {
                this.updated();
                this.builder.getChildNode(name).remove();
                return true;
            }
            catch (IOException e) {
                this.exception = e;
                return false;
            }
        }
    }
}

