/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.segment.Compactor;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.file.GCNodeWriteMonitor;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class CheckpointCompactor {
    @Nonnull
    private final GCMonitor gcListener;
    @Nonnull
    private final Map<NodeState, NodeState> cpCache = Maps.newHashMap();
    @Nonnull
    private final Compactor compactor;
    @Nonnull
    private final NodeWriter nodeWriter;

    public CheckpointCompactor(@Nonnull GCMonitor gcListener, @Nonnull SegmentReader reader, @Nonnull SegmentWriter writer, @Nullable BlobStore blobStore, @Nonnull Supplier<Boolean> cancel, @Nonnull GCNodeWriteMonitor compactionMonitor) {
        this.gcListener = gcListener;
        this.compactor = new Compactor(reader, writer, blobStore, cancel, compactionMonitor);
        this.nodeWriter = (node, stableId) -> {
            RecordId nodeId = writer.writeNode(node, stableId);
            return new SegmentNodeState(reader, writer, blobStore, nodeId);
        };
    }

    @CheckForNull
    public SegmentNodeState compact(@Nonnull NodeState base, @Nonnull NodeState uncompacted, @Nonnull NodeState onto) throws IOException {
        LinkedHashMap<String, NodeState> uncompactedRoots = this.collectRoots(uncompacted);
        LinkedHashMap<String, NodeState> compactedRoots = this.compact(CheckpointCompactor.getRoot(base), uncompactedRoots, CheckpointCompactor.getRoot(onto));
        if (compactedRoots == null) {
            return null;
        }
        NodeBuilder builder = uncompacted.builder();
        for (Map.Entry<String, NodeState> compactedRoot : compactedRoots.entrySet()) {
            String path = compactedRoot.getKey();
            NodeState state = compactedRoot.getValue();
            NodeBuilder childBuilder = CheckpointCompactor.getChild(builder, PathUtils.getParentPath((String)path));
            childBuilder.setChildNode(PathUtils.getName((String)path), state);
        }
        return this.nodeWriter.writeNode(builder.getNodeState(), CheckpointCompactor.getStableIdBytes(uncompacted));
    }

    @CheckForNull
    private static ByteBuffer getStableIdBytes(@Nonnull NodeState node) {
        return node instanceof SegmentNodeState ? ((SegmentNodeState)node).getStableIdBytes() : null;
    }

    @Nonnull
    private static NodeState getRoot(@Nonnull NodeState node) {
        return node.hasChildNode("root") ? node.getChildNode("root") : EmptyNodeState.EMPTY_NODE;
    }

    @CheckForNull
    private LinkedHashMap<String, NodeState> compact(@Nonnull NodeState base, @Nonnull LinkedHashMap<String, NodeState> uncompactedRoots, @Nonnull NodeState onto) throws IOException {
        LinkedHashMap compactedRoots = Maps.newLinkedHashMap();
        for (Map.Entry<String, NodeState> uncompactedRoot : uncompactedRoots.entrySet()) {
            String path = uncompactedRoot.getKey();
            NodeState uncompacted = uncompactedRoot.getValue();
            Result result = this.compactWithCache(base, uncompacted, onto, path);
            if (result == null) {
                return null;
            }
            base = result.nextBefore;
            onto = result.nextOnto;
            compactedRoots.put(path, result.compacted);
        }
        return compactedRoots;
    }

    @Nonnull
    private LinkedHashMap<String, NodeState> collectRoots(@Nullable NodeState superRoot) {
        LinkedHashMap roots = Maps.newLinkedHashMap();
        if (superRoot != null) {
            ArrayList checkpoints = Lists.newArrayList((Iterable)superRoot.getChildNode("checkpoints").getChildNodeEntries());
            checkpoints.sort((cne1, cne2) -> {
                long c1 = cne1.getNodeState().getLong("created");
                long c2 = cne2.getNodeState().getLong("created");
                return Long.compare(c1, c2);
            });
            for (ChildNodeEntry checkpoint : checkpoints) {
                String name = checkpoint.getName();
                NodeState node = checkpoint.getNodeState();
                this.gcListener.info("found checkpoint {} created at {}.", new Object[]{name, new Date(node.getLong("created"))});
                roots.put("checkpoints/" + name + "/root", node.getChildNode("root"));
            }
            roots.put("root", superRoot.getChildNode("root"));
        }
        return roots;
    }

    @Nonnull
    private static NodeBuilder getChild(NodeBuilder builder, String path) {
        for (String name : PathUtils.elements((String)path)) {
            builder = builder.getChildNode(name);
        }
        return builder;
    }

    @CheckForNull
    private Result compactWithCache(@Nonnull NodeState before, @Nonnull NodeState after, @Nonnull NodeState onto, @Nonnull String path) throws IOException {
        this.gcListener.info("compacting {}.", new Object[]{path});
        NodeState compacted = this.cpCache.get(after);
        if (compacted == null) {
            compacted = this.compactor.compact(before, after, onto);
            if (compacted == null) {
                return null;
            }
            this.cpCache.put(after, compacted);
            return new Result(compacted, after, compacted);
        }
        this.gcListener.info("found {} in cache.", new Object[]{path});
        return new Result(compacted, before, onto);
    }

    private static class Result {
        final NodeState compacted;
        final NodeState nextBefore;
        final NodeState nextOnto;

        Result(@Nonnull NodeState compacted, @Nonnull NodeState nextBefore, @Nonnull NodeState nextOnto) {
            this.compacted = compacted;
            this.nextBefore = nextBefore;
            this.nextOnto = nextOnto;
        }
    }

    private static interface NodeWriter {
        @Nonnull
        public SegmentNodeState writeNode(@Nonnull NodeState var1, @Nullable ByteBuffer var2) throws IOException;
    }
}

