/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.cache.CacheStats;
import org.apache.jackrabbit.oak.segment.MapRecord;
import org.apache.jackrabbit.oak.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Revisions;
import org.apache.jackrabbit.oak.segment.SegmentBlob;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.segment.SegmentReader;
import org.apache.jackrabbit.oak.segment.SegmentWriter;
import org.apache.jackrabbit.oak.segment.StringCache;
import org.apache.jackrabbit.oak.segment.Template;
import org.apache.jackrabbit.oak.segment.TemplateCache;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;

public class CachingSegmentReader
implements SegmentReader {
    public static final int DEFAULT_STRING_CACHE_MB = 256;
    public static final int DEFAULT_TEMPLATE_CACHE_MB = 64;
    @Nonnull
    private final Supplier<SegmentWriter> writer;
    @CheckForNull
    private final BlobStore blobStore;
    @Nonnull
    private final StringCache stringCache;
    @Nonnull
    private final TemplateCache templateCache;

    public CachingSegmentReader(@Nonnull Supplier<SegmentWriter> writer, @Nullable BlobStore blobStore, long stringCacheMB, long templateCacheMB) {
        this.writer = (Supplier)Preconditions.checkNotNull(writer);
        this.blobStore = blobStore;
        this.stringCache = new StringCache(stringCacheMB * 1024L * 1024L);
        this.templateCache = new TemplateCache(templateCacheMB * 1024L * 1024L);
    }

    @Override
    @Nonnull
    public String readString(@Nonnull RecordId id) {
        final SegmentId segmentId = id.getSegmentId();
        long msb = segmentId.getMostSignificantBits();
        long lsb = segmentId.getLeastSignificantBits();
        return this.stringCache.get(msb, lsb, id.getRecordNumber(), new Function<Integer, String>(){

            @Nonnull
            public String apply(Integer offset) {
                return segmentId.getSegment().readString(offset);
            }
        });
    }

    @Override
    @Nonnull
    public MapRecord readMap(@Nonnull RecordId id) {
        return new MapRecord(this, id);
    }

    @Override
    @Nonnull
    public Template readTemplate(@Nonnull RecordId id) {
        final SegmentId segmentId = id.getSegmentId();
        long msb = segmentId.getMostSignificantBits();
        long lsb = segmentId.getLeastSignificantBits();
        return this.templateCache.get(msb, lsb, id.getRecordNumber(), new Function<Integer, Template>(){

            @Nonnull
            public Template apply(Integer offset) {
                return segmentId.getSegment().readTemplate(offset);
            }
        });
    }

    @Override
    @Nonnull
    public SegmentNodeState readNode(@Nonnull RecordId id) {
        return new SegmentNodeState((SegmentReader)this, this.writer, this.blobStore, id);
    }

    @Override
    @Nonnull
    public SegmentNodeState readHeadState(@Nonnull Revisions revisions) {
        return this.readNode(revisions.getHead());
    }

    @Override
    @Nonnull
    public SegmentPropertyState readProperty(@Nonnull RecordId id, @Nonnull PropertyTemplate template) {
        return new SegmentPropertyState(this, id, template);
    }

    @Override
    @Nonnull
    public SegmentBlob readBlob(@Nonnull RecordId id) {
        return new SegmentBlob(this.blobStore, id);
    }

    @Nonnull
    public CacheStats getStringCacheStats() {
        return this.stringCache.getStats();
    }

    @Nonnull
    public CacheStats getTemplateCacheStats() {
        return this.templateCache.getStats();
    }
}

