/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import com.google.common.cache.Weigher;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.segment.ReaderCache;
import org.apache.jackrabbit.oak.segment.RecordId;
import org.apache.jackrabbit.oak.segment.Segment;
import org.apache.jackrabbit.oak.segment.SegmentId;
import org.apache.jackrabbit.oak.segment.Template;

public final class CacheWeights {
    public static final int OBJECT_HEADER_SIZE = 12;
    private static final int LIRS_CACHE_OVERHEAD = 168;
    private static final int RECORD_CACHE_OVERHEAD = 32;
    private static final int PRIORITY_CACHE_OVERHEAD = 32;
    private static final int SEGMENT_CACHE_OVERHEAD = 32;
    private static final Weigher<Object, Object> NOOP_WEIGHER = new OneWeigher<Object, Object>();

    private CacheWeights() {
    }

    public static <K, V> Weigher<K, V> noopWeigher() {
        return NOOP_WEIGHER;
    }

    static int segmentWeight(Segment segment) {
        return 32 + segment.estimateMemoryUsage();
    }

    public static class ReaderStringCacheWeigher
    implements Weigher<ReaderCache.CacheKey, String> {
        public int weigh(@Nonnull ReaderCache.CacheKey key, @Nonnull String value) {
            int size = 168;
            size += key.estimateMemoryUsage();
            return size += StringUtils.estimateMemoryUsage((String)value);
        }
    }

    public static class ReaderTemplateCacheWeigher
    implements Weigher<ReaderCache.CacheKey, Template> {
        public int weigh(@Nonnull ReaderCache.CacheKey key, @Nonnull Template value) {
            int size = 168;
            size += key.estimateMemoryUsage();
            return size += value.estimateMemoryUsage();
        }
    }

    public static class TemplateCacheWeigher
    implements Weigher<Template, RecordId> {
        public int weigh(@Nonnull Template key, @Nonnull RecordId value) {
            int size = 32;
            size += key.estimateMemoryUsage();
            return size += value.estimateMemoryUsage();
        }
    }

    public static class StringCacheWeigher
    implements Weigher<String, RecordId> {
        public int weigh(@Nonnull String key, @Nonnull RecordId value) {
            int size = 32;
            size += StringUtils.estimateMemoryUsage((String)key);
            return size += value.estimateMemoryUsage();
        }
    }

    public static class NodeCacheWeigher
    implements Weigher<String, RecordId> {
        public int weigh(@Nonnull String key, @Nonnull RecordId value) {
            int size = 32;
            size += StringUtils.estimateMemoryUsage((String)key);
            return size += value.estimateMemoryUsage();
        }
    }

    public static class SegmentCacheWeigher
    implements Weigher<SegmentId, Segment> {
        public int weigh(@Nonnull SegmentId id, @Nonnull Segment segment) {
            return CacheWeights.segmentWeight(segment);
        }
    }

    public static class OneWeigher<K, V>
    implements Weigher<K, V> {
        public int weigh(@Nonnull Object key, @Nonnull Object value) {
            return 1;
        }
    }
}

