/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.segment.Cache;
import org.apache.jackrabbit.oak.stats.CounterStats;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.apache.jackrabbit.oak.stats.StatsOptions;

public class CacheAccessTracker<K, V>
implements Cache<K, V> {
    private final Cache<K, V> delegate;
    private final CounterStats accessCount;
    private final CounterStats missCount;

    public CacheAccessTracker(@Nonnull String name, @Nonnull StatisticsProvider statisticsProvider, @Nonnull Cache<K, V> delegate) {
        this.delegate = delegate;
        this.accessCount = statisticsProvider.getCounterStats(name + ".access-count", StatsOptions.DEFAULT);
        this.missCount = statisticsProvider.getCounterStats(name + ".miss-count", StatsOptions.DEFAULT);
    }

    @Override
    public void put(@Nonnull K key, @Nonnull V value) {
        this.delegate.put(key, value);
    }

    @Override
    public void put(@Nonnull K key, @Nonnull V value, byte cost) {
        this.delegate.put(key, value, cost);
    }

    @Override
    @CheckForNull
    public V get(@Nonnull K key) {
        V v = this.delegate.get(key);
        this.accessCount.inc();
        if (v == null) {
            this.missCount.inc();
        }
        return v;
    }
}

