/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.oak.cluster;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.discovery.InstanceDescription;
import org.apache.sling.discovery.base.commons.ClusterViewService;
import org.apache.sling.discovery.base.commons.UndefinedClusterViewException;
import org.apache.sling.discovery.commons.providers.DefaultClusterView;
import org.apache.sling.discovery.commons.providers.DefaultInstanceDescription;
import org.apache.sling.discovery.commons.providers.spi.LocalClusterView;
import org.apache.sling.discovery.commons.providers.spi.base.DiscoveryLiteDescriptor;
import org.apache.sling.discovery.commons.providers.spi.base.IdMapService;
import org.apache.sling.discovery.commons.providers.util.ResourceHelper;
import org.apache.sling.discovery.oak.Config;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={ClusterViewService.class})
public class OakClusterViewService
implements ClusterViewService {
    private static final String PROPERTY_CLUSTER_ID = "clusterId";
    private static final String PROPERTY_CLUSTER_ID_DEFINED_AT = "clusterIdDefinedAt";
    private static final String PROPERTY_CLUSTER_ID_DEFINED_BY = "clusterIdDefinedBy";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference
    private SlingSettingsService settingsService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Config config;
    @Reference
    private IdMapService idMapService;
    private long lastSeqNum = -1L;

    public static OakClusterViewService testConstructor(SlingSettingsService settingsService, ResourceResolverFactory resourceResolverFactory, IdMapService idMapService, Config config) {
        OakClusterViewService service = new OakClusterViewService();
        service.settingsService = settingsService;
        service.resourceResolverFactory = resourceResolverFactory;
        service.config = config;
        service.idMapService = idMapService;
        return service;
    }

    public String getSlingId() {
        if (this.settingsService == null) {
            return null;
        }
        return this.settingsService.getSlingId();
    }

    protected ResourceResolver getResourceResolver() throws LoginException {
        return this.resourceResolverFactory.getServiceResourceResolver(null);
    }

    public LocalClusterView getLocalClusterView() throws UndefinedClusterViewException {
        this.logger.trace("getLocalClusterView: start");
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.getResourceResolver();
            DiscoveryLiteDescriptor descriptor = DiscoveryLiteDescriptor.getDescriptorFrom((ResourceResolver)resourceResolver);
            if (this.lastSeqNum != descriptor.getSeqNum()) {
                this.logger.info("getLocalClusterView: sequence number change detected - clearing idmap cache");
                this.idMapService.clearCache();
                this.lastSeqNum = descriptor.getSeqNum();
            }
            LocalClusterView localClusterView = this.asClusterView(descriptor, resourceResolver);
            return localClusterView;
        }
        catch (UndefinedClusterViewException e) {
            this.logger.info("getLocalClusterView: undefined clusterView: " + e.getReason() + " - " + e.getMessage());
            throw e;
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("No Descriptor value available")) {
                this.logger.warn("getLocalClusterView: repository exception: " + e);
            } else {
                this.logger.error("getLocalClusterView: repository exception: " + e, (Throwable)e);
            }
            throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.REPOSITORY_EXCEPTION, "Exception while processing descriptor: " + e);
        }
        finally {
            this.logger.trace("getLocalClusterView: end");
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
    }

    private LocalClusterView asClusterView(DiscoveryLiteDescriptor descriptor, ResourceResolver resourceResolver) throws Exception {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor must not be null");
        }
        if (resourceResolver == null) {
            throw new IllegalArgumentException("resourceResolver must not be null");
        }
        this.logger.trace("asClusterView: start");
        String clusterViewId = descriptor.getViewId();
        if (clusterViewId == null || clusterViewId.length() == 0) {
            this.logger.trace("asClusterView: no clusterId provided by discovery-lite descriptor - reading from repo.");
            clusterViewId = this.readOrDefineClusterId(resourceResolver);
        }
        String localClusterSyncTokenId = String.valueOf(descriptor.getSeqNum());
        if (!descriptor.isFinal()) {
            throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, "descriptor is not yet final: " + descriptor);
        }
        LocalClusterView cluster = new LocalClusterView(clusterViewId, localClusterSyncTokenId);
        long me = descriptor.getMyId();
        int[] activeIds = descriptor.getActiveIds();
        if (activeIds == null || activeIds.length == 0) {
            throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, "Descriptor contained no active ids: " + descriptor.getDescriptorStr());
        }
        LinkedList<Integer> activeIdsList = new LinkedList<Integer>();
        int[] nArray = activeIds;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer integer = nArray[i];
            activeIdsList.add(integer);
        }
        HashMap<Integer, String> leaderElectionIds = new HashMap<Integer, String>();
        for (Integer id : activeIdsList) {
            String slingId = this.idMapService.toSlingId(id.intValue(), resourceResolver);
            if (slingId == null) {
                this.idMapService.clearCache();
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, "no slingId mapped for clusterNodeId=" + id);
            }
            String leaderElectionId = this.getLeaderElectionId(resourceResolver, slingId);
            if (leaderElectionId == null) {
                throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.NO_ESTABLISHED_VIEW, "no leaderElectionId available yet for slingId=" + slingId);
            }
            leaderElectionIds.put(id, leaderElectionId);
        }
        this.leaderElectionSort(activeIdsList, leaderElectionIds);
        for (int i = 0; i < activeIdsList.size(); ++i) {
            int id = (Integer)activeIdsList.get(i);
            boolean isLeader = i == 0;
            boolean isOwn = (long)id == me;
            String slingId = this.idMapService.toSlingId(id, resourceResolver);
            if (slingId == null) {
                this.idMapService.clearCache();
                this.logger.info("asClusterView: cannot resolve oak-clusterNodeId {} to a slingId", (Object)id);
                throw new Exception("Cannot resolve oak-clusterNodeId " + id + " to a slingId");
            }
            Map<String, String> properties = this.readProperties(slingId, resourceResolver);
            new DefaultInstanceDescription((DefaultClusterView)cluster, isLeader, isOwn, slingId, properties);
        }
        this.logger.trace("asClusterView: returning {}", (Object)cluster);
        InstanceDescription local = cluster.getLocalInstance();
        if (local != null) {
            return cluster;
        }
        this.logger.info("getClusterView: the local instance (" + this.getSlingId() + ") is currently not included in the existing established view! This is normal at startup. At other times is pseudo-network-partitioning is an indicator for repository/network-delays or clocks-out-of-sync (SLING-3432). (increasing the heartbeatTimeout can help as a workaround too) The local instance will stay in TOPOLOGY_CHANGING or pre _INIT mode until a new vote was successful.");
        throw new UndefinedClusterViewException(UndefinedClusterViewException.Reason.ISOLATED_FROM_TOPOLOGY, "established view does not include local instance - isolated");
    }

    private void leaderElectionSort(List<Integer> activeIdsList, final Map<Integer, String> leaderElectionIds) {
        Comparator<Integer> comparator = this.config.isInvertLeaderElectionPrefixOrder() ? new Comparator<Integer>(){

            private long prefixOf(String leaderElectionId) {
                int underScore = leaderElectionId.indexOf("_");
                if (underScore == -1) {
                    return -1L;
                }
                String prefixStr = leaderElectionId.substring(0, underScore);
                try {
                    return Long.parseLong(prefixStr);
                }
                catch (Exception e) {
                    return -1L;
                }
            }

            @Override
            public int compare(Integer arg0, Integer arg1) {
                long prefix1;
                String leaderElectionId0 = (String)leaderElectionIds.get(arg0);
                String leaderElectionId1 = (String)leaderElectionIds.get(arg1);
                long prefix0 = this.prefixOf(leaderElectionId0);
                if (prefix0 == (prefix1 = this.prefixOf(leaderElectionId1))) {
                    return leaderElectionId0.compareTo(leaderElectionId1);
                }
                return new Long(prefix1).compareTo(prefix0);
            }
        } : new Comparator<Integer>(){

            @Override
            public int compare(Integer arg0, Integer arg1) {
                return ((String)leaderElectionIds.get(arg0)).compareTo((String)leaderElectionIds.get(arg1));
            }
        };
        Collections.sort(activeIdsList, comparator);
    }

    private String readOrDefineClusterId(ResourceResolver resourceResolver) throws PersistenceException {
        String clusterInstancesPath = this.config.getClusterInstancesPath();
        String discoveryResourcePath = clusterInstancesPath.substring(0, clusterInstancesPath.lastIndexOf("/", clusterInstancesPath.length() - 2));
        int MAX_RETRIES = 5;
        for (int retryCnt = 0; retryCnt < 5; ++retryCnt) {
            String clusterId;
            Resource varDiscoveryOak = resourceResolver.getResource(discoveryResourcePath);
            if (varDiscoveryOak == null) {
                varDiscoveryOak = ResourceHelper.getOrCreateResource((ResourceResolver)resourceResolver, (String)discoveryResourcePath);
            }
            if (varDiscoveryOak == null) {
                this.logger.error("readOrDefinedClusterId: Could not create: " + discoveryResourcePath);
                throw new RuntimeException("could not create " + discoveryResourcePath);
            }
            ModifiableValueMap props = (ModifiableValueMap)varDiscoveryOak.adaptTo(ModifiableValueMap.class);
            if (props == null) {
                this.logger.error("readOrDefineClusterId: Could not adaptTo ModifiableValueMap: " + varDiscoveryOak);
                throw new RuntimeException("could not adaptTo ModifiableValueMap: " + varDiscoveryOak);
            }
            Object clusterIdObj = props.get((Object)PROPERTY_CLUSTER_ID);
            String string = clusterId = clusterIdObj == null ? null : String.valueOf(clusterIdObj);
            if (clusterId != null && clusterId.length() > 0) {
                this.logger.trace("readOrDefineClusterId: read clusterId from repo as {}", (Object)clusterId);
                return clusterId;
            }
            String newClusterId = UUID.randomUUID().toString();
            props.put((Object)PROPERTY_CLUSTER_ID, (Object)newClusterId);
            props.put((Object)PROPERTY_CLUSTER_ID_DEFINED_BY, (Object)this.getSlingId());
            props.put((Object)PROPERTY_CLUSTER_ID_DEFINED_AT, (Object)Calendar.getInstance());
            try {
                this.logger.info("readOrDefineClusterId: storing new clusterId as " + newClusterId);
                resourceResolver.commit();
                return newClusterId;
            }
            catch (PersistenceException e) {
                this.logger.warn("readOrDefineClusterId: could not persist clusterId (retrying in 1 sec max " + (5 - retryCnt - 1) + " more times: " + (Object)((Object)e), (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    this.logger.warn("readOrDefineClusterId: got interrupted: " + e1, (Throwable)e1);
                }
                this.logger.info("readOrDefineClusterId: retrying now.");
                continue;
            }
        }
        throw new RuntimeException("failed to write new clusterId (see log file earlier for more details)");
    }

    private String getLeaderElectionId(ResourceResolver resourceResolver, String slingId) {
        if (slingId == null) {
            throw new IllegalStateException("slingId must not be null");
        }
        String myClusterNodePath = this.config.getClusterInstancesPath() + "/" + slingId;
        Resource myClusterNode = resourceResolver.getResource(myClusterNodePath);
        if (myClusterNode == null) {
            return null;
        }
        ValueMap resourceMap = (ValueMap)myClusterNode.adaptTo(ValueMap.class);
        String result = (String)resourceMap.get("leaderElectionId", String.class);
        return result;
    }

    private Map<String, String> readProperties(String slingId, ResourceResolver resourceResolver) {
        ValueMap properties;
        Resource propertiesChild;
        Resource res = resourceResolver.getResource(this.config.getClusterInstancesPath() + "/" + slingId);
        HashMap<String, String> props = new HashMap<String, String>();
        if (res != null && (propertiesChild = res.getChild("properties")) != null && (properties = (ValueMap)propertiesChild.adaptTo(ValueMap.class)) != null) {
            for (String key : properties.keySet()) {
                if (key.equals("jcr:primaryType")) continue;
                props.put(key, (String)properties.get(key, String.class));
            }
        }
        return props;
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindConfig(Config config) {
        this.config = config;
    }

    protected void unbindConfig(Config config) {
        if (this.config == config) {
            this.config = null;
        }
    }

    protected void bindIdMapService(IdMapService idMapService) {
        this.idMapService = idMapService;
    }

    protected void unbindIdMapService(IdMapService idMapService) {
        if (this.idMapService == idMapService) {
            this.idMapService = null;
        }
    }
}

