/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.file.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.api.UpdateHandler;
import org.apache.sling.installer.provider.file.impl.Activator;
import org.apache.sling.installer.provider.file.impl.FileInstaller;
import org.apache.sling.installer.provider.file.impl.ScanConfiguration;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String INSTALLER_SERVICE_NAME = OsgiInstaller.class.getName();
    private static final String SETTINGS_SERVICE_NAME = SlingSettingsService.class.getName();
    private final BundleContext bundleContext;
    private final Listener installerListener;
    private final Listener settingsListener;
    private final FileInstaller installer;
    private ServiceRegistration registration;
    private boolean running = false;
    public static final String VENDOR = "The Apache Software Foundation";

    public ServicesListener(BundleContext bundleContext, List<ScanConfiguration> configs) {
        this.bundleContext = bundleContext;
        boolean writeBack = true;
        Object writeBackObj = Activator.getProp(this.bundleContext, "sling.fileinstall.writeback");
        if (writeBackObj != null && "false".equalsIgnoreCase(writeBackObj.toString())) {
            writeBack = false;
        }
        this.installer = new FileInstaller(configs, writeBack);
        this.installerListener = new Listener(INSTALLER_SERVICE_NAME);
        this.settingsListener = new Listener(SETTINGS_SERVICE_NAME);
        this.installerListener.start();
        this.settingsListener.start();
    }

    public synchronized void notifyChange() {
        boolean shouldRun = this.installer.hasConfigurations();
        if (shouldRun && !this.running || !shouldRun && this.running) {
            OsgiInstaller installer = (OsgiInstaller)this.installerListener.getService();
            SlingSettingsService settings = (SlingSettingsService)this.settingsListener.getService();
            if (installer != null && settings != null && !this.running) {
                this.logger.debug("Starting scanner");
                this.startScanner(installer, settings);
            } else if (this.running && (installer == null || settings == null)) {
                this.logger.debug("Stopping scanner");
                this.stopScanner();
            }
        }
    }

    public void deactivate() {
        this.installerListener.deactivate();
        this.stopScanner();
    }

    private void startScanner(OsgiInstaller installer, SlingSettingsService settings) {
        if (!this.running) {
            this.installer.start(installer, settings);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            ((Dictionary)props).put("service.description", "Apache Sling File Installer Controller Service");
            ((Dictionary)props).put("service.vendor", VENDOR);
            ((Dictionary)props).put("handler.schemes", this.installer.getSchemes());
            this.registration = this.bundleContext.registerService(UpdateHandler.class.getName(), (Object)this.installer, props);
            this.running = true;
        }
    }

    private void stopScanner() {
        if (this.running) {
            if (this.registration != null) {
                this.registration.unregister();
                this.registration = null;
            }
            this.installer.stop();
            this.running = false;
        }
    }

    protected final class Listener
    implements ServiceListener {
        private final String serviceName;
        private ServiceReference reference;
        private Object service;

        public Listener(String serviceName) {
            this.serviceName = serviceName;
        }

        public void start() {
            this.retainService();
            try {
                ServicesListener.this.bundleContext.addServiceListener((ServiceListener)this, "(objectClass=" + this.serviceName + ")");
            }
            catch (InvalidSyntaxException ise) {
                throw new RuntimeException("Unexpected exception occured.", ise);
            }
        }

        public void deactivate() {
            ServicesListener.this.bundleContext.removeServiceListener((ServiceListener)this);
        }

        public synchronized Object getService() {
            return this.service;
        }

        private synchronized void retainService() {
            if (this.reference == null) {
                this.reference = ServicesListener.this.bundleContext.getServiceReference(this.serviceName);
                if (this.reference != null) {
                    this.service = ServicesListener.this.bundleContext.getService(this.reference);
                    if (this.service == null) {
                        this.reference = null;
                    } else {
                        ServicesListener.this.notifyChange();
                    }
                }
            }
        }

        private synchronized void releaseService() {
            if (this.reference != null) {
                this.service = null;
                ServicesListener.this.bundleContext.ungetService(this.reference);
                this.reference = null;
                ServicesListener.this.notifyChange();
            }
        }

        public void serviceChanged(ServiceEvent event) {
            if (event.getType() == 1 && this.service == null) {
                this.retainService();
            } else if (event.getType() == 4 && this.service != null) {
                this.releaseService();
            }
        }
    }
}

