/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.provider.file.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.sling.installer.api.InstallableResource;
import org.apache.sling.installer.api.OsgiInstaller;
import org.apache.sling.installer.provider.file.impl.FileChangesListener;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Installer
implements FileChangesListener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final OsgiInstaller installer;
    private final Set<String> activeRunModes;
    private final String scheme;
    private final String prefix;

    public Installer(OsgiInstaller installer, SlingSettingsService settings, String root, String id) {
        this.scheme = "fileinstall" + id;
        this.installer = installer;
        this.activeRunModes = settings.getRunModes();
        this.prefix = new File(root).getAbsolutePath() + File.separator;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void initialSet(List<File> files) {
        this.logger.debug("Initial set for {}", (Object)this.scheme);
        ArrayList<InstallableResource> resources = new ArrayList<InstallableResource>();
        for (File f : files) {
            this.logger.debug("Initial file {}", (Object)f);
            InstallableResource resource = this.createResource(f);
            if (resource == null) continue;
            resources.add(resource);
        }
        this.installer.registerResources(this.scheme, resources.toArray(new InstallableResource[resources.size()]));
    }

    @Override
    public void updated(List<File> added, List<File> changed, List<File> removed) {
        String[] removedUrls;
        ArrayList<InstallableResource> updated;
        if (added != null && added.size() > 0 || changed != null && changed.size() > 0) {
            InstallableResource resource;
            updated = new ArrayList<InstallableResource>();
            if (added != null) {
                for (File f : added) {
                    this.logger.debug("Added file {}", (Object)f);
                    resource = this.createResource(f);
                    if (resource == null) continue;
                    updated.add(resource);
                }
            }
            if (changed != null) {
                for (File f : changed) {
                    this.logger.debug("Changed file {}", (Object)f);
                    resource = this.createResource(f);
                    if (resource == null) continue;
                    updated.add(resource);
                }
            }
        } else {
            updated = null;
        }
        if (removed != null && removed.size() > 0) {
            removedUrls = new String[removed.size()];
            int index = 0;
            for (File f : removed) {
                removedUrls[index] = f.getAbsolutePath();
                this.logger.debug("Removed file {}", (Object)removedUrls[index]);
                ++index;
            }
        } else {
            removedUrls = null;
        }
        if (updated != null || removedUrls != null) {
            this.installer.updateResources(this.scheme, updated == null ? null : updated.toArray(new InstallableResource[updated.size()]), removedUrls);
        }
    }

    private InstallableResource createResource(File file) {
        try {
            String name = file.getAbsolutePath().substring(this.prefix.length()).replace(File.separatorChar, '/');
            boolean isActive = true;
            Integer prio = null;
            int pos = name.indexOf(47);
            if (pos != -1 && name.startsWith("install.")) {
                String runModes = name.substring(8, pos);
                int activeModes = this.isActive(runModes);
                if (activeModes > 0) {
                    prio = 100 + activeModes;
                } else {
                    isActive = false;
                }
            }
            if (isActive) {
                FileInputStream is = new FileInputStream(file);
                String digest = String.valueOf(file.lastModified());
                Hashtable<String, Object> dict = new Hashtable<String, Object>();
                if (file.getName().endsWith(".jar") || file.getName().endsWith(".war")) {
                    String parentName = file.getParentFile().getName();
                    try {
                        int startLevel = Integer.valueOf(parentName);
                        if (startLevel > 0) {
                            ((Dictionary)dict).put("bundle.startlevel", startLevel);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                ((Dictionary)dict).put("resource.uri.hint", file.toURI().toString());
                return new InstallableResource(file.getAbsolutePath(), (InputStream)is, dict, digest, null, prio);
            }
            this.logger.info("Ignoring inactive resource at {}", (Object)file);
        }
        catch (IOException io) {
            this.logger.error("Unable to read file " + file, (Throwable)io);
        }
        return null;
    }

    private int isActive(String runModesString) {
        String[] runModes = runModesString.split("\\.");
        boolean active = true;
        for (String mode : runModes) {
            if (this.activeRunModes.contains(mode)) continue;
            active = false;
            break;
        }
        return active ? runModes.length : 0;
    }
}

