/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.testservices.servlets;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(immediate=true)
@Service
@Properties(value={@Property(name="service.description", value={"Anonymous Access Config Servlet"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="sling.servlet.paths", value={"/testing/AnonymousAccessConfigServlet"}), @Property(name="sling.servlet.extensions", value={"txt"}), @Property(name="event.topics", value={"org/osgi/framework/ServiceEvent/MODIFIED"})})
public class AnonymousAccessConfigServlet
extends SlingAllMethodsServlet
implements EventHandler {
    private static final String PROP_AUTH_ANNONYMOUS = "auth.annonymous";
    private static final String AUTH_PID = "org.apache.sling.engine.impl.auth.SlingAuthenticator";
    private static final long TIMEOUT = 1000L;
    @Reference
    private ConfigurationAdmin configAdmin;
    private int modifiedCounter;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType(request.getContentType());
        String action = request.getParameter("action");
        if ("disable".equals(action)) {
            int existingModifiedCounter = this.modifiedCounter;
            Configuration config = this.configAdmin.getConfiguration(AUTH_PID, null);
            Hashtable<String, Boolean> props = config.getProperties();
            if (props == null) {
                props = new Hashtable<String, Boolean>();
            }
            ((Dictionary)props).put(PROP_AUTH_ANNONYMOUS, Boolean.FALSE);
            config.update(props);
            this.waitForModified(existingModifiedCounter, 1000L);
        } else if ("enable".equals(action)) {
            int existingModifiedCounter = this.modifiedCounter;
            Configuration config = this.configAdmin.getConfiguration(AUTH_PID, null);
            Hashtable<String, Boolean> props = config.getProperties();
            if (props == null) {
                props = new Hashtable<String, Boolean>();
            }
            ((Dictionary)props).put(PROP_AUTH_ANNONYMOUS, Boolean.TRUE);
            config.update(props);
            this.waitForModified(existingModifiedCounter, 1000L);
        }
        response.getWriter().println("ok");
    }

    private void waitForModified(int existingModifiedCounter, long timeoutMsec) {
        int targetCounter = existingModifiedCounter + 1;
        long end = System.currentTimeMillis() + timeoutMsec;
        while (this.modifiedCounter < targetCounter && System.currentTimeMillis() < end) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.modifiedCounter < targetCounter) {
            throw new IllegalStateException("Event counter did not reach " + targetCounter + ", waited " + timeoutMsec + " msec");
        }
    }

    public void handleEvent(Event event) {
        if (AUTH_PID.equals(event.getProperty("service.pid"))) {
            ++this.modifiedCounter;
        }
    }

    protected void bindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        this.configAdmin = configurationAdmin;
    }

    protected void unbindConfigAdmin(ConfigurationAdmin configurationAdmin) {
        if (this.configAdmin == configurationAdmin) {
            this.configAdmin = null;
        }
    }
}

