/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.serviceuser.webconsole.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.jcr.base.util.AccessControlUtil;
import org.apache.sling.serviceusermapping.Mapping;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.apache.sling.xss.XSSAPI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Apache Sling Service User Manager Web Console Plugin", "felix.webconsole.label=serviceusers", "felix.webconsole.title=Service Users", "felix.webconsole.category=Sling"})
public class ServiceUserWebConsolePlugin
extends AbstractWebConsolePlugin {
    public static final String COMPONENT_NAME = "org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended";
    public static final String LABEL = "serviceusers";
    public static final String TITLE = "Service Users";
    public static final String PN_ACTION = "action";
    public static final String PN_ALERT = "alert";
    public static final String PN_APP_PATH = "appPath";
    public static final String PN_BUNDLE = "bundle";
    public static final String PN_NAME = "name";
    public static final String PN_SUB_SERVICE = "subService";
    public static final String PN_USER = "user";
    public static final String PN_USER_PATH = "userPath";
    private static final Logger log = LoggerFactory.getLogger(ServiceUserWebConsolePlugin.class);
    private BundleContext bundleContext;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private XSSAPI xss;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ResourceResolverFactory resolverFactory;
    @Reference
    private ServiceUserMapper mapper;

    private boolean createOrUpdateMapping(HttpServletRequest request, ResourceResolver resolver) {
        String appPath = this.getParameter(request, PN_APP_PATH, "");
        Iterator configs = resolver.findResources("SELECT * FROM [sling:OsgiConfig] WHERE ISDESCENDANTNODE([" + appPath + "]) AND NAME() LIKE '" + COMPONENT_NAME + "%'", "JCR-SQL2");
        try {
            boolean dirty = false;
            Resource config = null;
            if (configs.hasNext()) {
                config = (Resource)configs.next();
                log.debug("Using existing configuration {}", (Object)config);
            } else {
                String path = appPath + "/config/" + COMPONENT_NAME + "-" + appPath.substring(appPath.lastIndexOf(47) + 1);
                log.debug("Creating new configuration {}", (Object)path);
                config = ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)path, (Map)new HashMap<String, Object>(){
                    {
                        this.put("jcr:primaryType", "sling:OsgiConfig");
                    }
                }, (String)"{http://www.jcp.org/jcr/nt/1.0}folder", (boolean)false);
                dirty = true;
            }
            String bundle = this.getParameter(request, PN_BUNDLE, "");
            String subService = this.getParameter(request, PN_SUB_SERVICE, "");
            String name = this.getParameter(request, PN_NAME, "");
            String mapping = bundle + (StringUtils.isNotBlank((CharSequence)subService) ? ":" + subService : "") + "=" + name;
            ModifiableValueMap properties = (ModifiableValueMap)config.adaptTo(ModifiableValueMap.class);
            Object[] mappings = (String[])properties.get("user.mapping", (Object)new String[0]);
            if (!ArrayUtils.contains((Object[])mappings, (Object)mapping)) {
                log.debug("Adding {} into service user mapping", (Object)mapping);
                ArrayList<Object> m = new ArrayList<Object>();
                m.addAll(Arrays.asList(mappings));
                m.add(mapping);
                properties.put((Object)"user.mapping", (Object)m.toArray(new String[m.size()]));
                dirty = true;
            } else {
                log.debug("Already found {} in service user mapping", (Object)mapping);
            }
            if (dirty) {
                log.debug("Saving changes to osgi config");
                resolver.commit();
            }
        }
        catch (PersistenceException e) {
            log.warn("Exception creating service mapping", (Throwable)e);
            return false;
        }
        return true;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.debug("Creating service user");
        if (StringUtils.isBlank((CharSequence)this.getParameter(request, PN_NAME, "")) || StringUtils.isBlank((CharSequence)this.getParameter(request, PN_BUNDLE, "")) || StringUtils.isBlank((CharSequence)this.getParameter(request, PN_APP_PATH, ""))) {
            this.sendErrorRedirect(request, response, "Missing required parameters!");
            return;
        }
        ResourceResolver resolver = this.getResourceResolver(request);
        if (resolver == null) {
            log.warn("Unable to get serviceresolver from request!");
            this.sendErrorRedirect(request, response, "Unable to get serviceresolver from request!");
            return;
        }
        Resource userResource = this.getOrCreateServiceUser(request, resolver);
        if (userResource == null) {
            log.warn("Unable to create service user!");
            this.sendErrorRedirect(request, response, "Unable to create service user!");
            return;
        }
        if (this.createOrUpdateMapping(request, resolver)) {
            if (this.updatePrivileges(request, resolver)) {
                ArrayList<String> params = new ArrayList<String>();
                params.add("action=details");
                params.add("alert=" + URLEncoder.encode("Service user " + userResource.getName() + " created / updated successfully!", "UTF-8"));
                params.add("user=" + URLEncoder.encode(userResource.getName(), "UTF-8"));
                WebConsoleUtil.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)("/system/console/serviceusers?" + StringUtils.join(params, (String)"&")));
            } else {
                this.sendErrorRedirect(request, response, "Unable to update service user permissions!");
            }
        } else {
            this.sendErrorRedirect(request, response, "Unable to create service user mapping!");
        }
    }

    private List<String> extractPrincipals(Mapping mapping) {
        Iterable ps;
        ArrayList<String> principals = new ArrayList<String>();
        String userName = mapping.map(mapping.getServiceName(), mapping.getSubServiceName());
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            principals.add(userName);
        }
        if ((ps = mapping.mapPrincipals(mapping.getServiceName(), mapping.getSubServiceName())) != null) {
            for (String principal : ps) {
                principals.add(principal);
            }
        }
        return principals;
    }

    private String[] findACLs(ResourceResolver resolver, String name, List<String> affectedPaths) {
        ArrayList<String> acls = new ArrayList<String>();
        Iterator aclResources = resolver.findResources("SELECT * FROM [rep:GrantACE] AS s WHERE  [rep:principalName] = '" + name + "'", "JCR-SQL2");
        while (aclResources.hasNext()) {
            Resource aclResource = (Resource)aclResources.next();
            affectedPaths.add(aclResource.getPath());
            ValueMap properties = (ValueMap)aclResource.adaptTo(ValueMap.class);
            String acl = aclResource.getPath().substring(0, aclResource.getPath().indexOf("/rep:policy")) + "=" + StringUtils.join((Object[])((Object[])properties.get("rep:privileges", String[].class)), (String)",");
            acls.add(acl);
        }
        return acls.toArray(new String[acls.size()]);
    }

    private Bundle findBundle(String symbolicName, Map<String, Bundle> bundles) {
        if (bundles.isEmpty()) {
            for (Bundle bundle : this.bundleContext.getBundles()) {
                bundles.put(bundle.getSymbolicName(), bundle);
            }
        }
        return bundles.get(symbolicName);
    }

    private Object findConfigurations(ResourceResolver resolver, String name, List<String> affectedPaths) {
        Resource configResource;
        ArrayList<String> configurations = new ArrayList<String>();
        Iterator configResources = resolver.findResources("SELECT * FROM [sling:OsgiConfig] AS s WHERE (ISDESCENDANTNODE([/apps]) OR ISDESCENDANTNODE([/libs])) AND NAME(s) LIKE 'org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended%' AND [user.mapping] LIKE '%=" + name + "'", "JCR-SQL2");
        while (configResources.hasNext()) {
            configResource = (Resource)configResources.next();
            affectedPaths.add(configResource.getPath());
            configurations.add(configResource.getPath());
        }
        configResources = resolver.findResources("SELECT * FROM [nt:file] AS s WHERE (ISDESCENDANTNODE([/apps]) OR ISDESCENDANTNODE([/libs])) AND NAME(s) LIKE 'org.apache.sling.serviceusermapping.impl.ServiceUserMapperImpl.amended%' AND [jcr:content/jcr:data] LIKE '%=" + name + "%'", "JCR-SQL2");
        while (configResources.hasNext()) {
            configResource = (Resource)configResources.next();
            affectedPaths.add(configResource.getPath());
            configurations.add(configResource.getPath());
        }
        return configurations.toArray();
    }

    private String[] findMappings(ResourceResolver resolver, String name) {
        ArrayList<String> mappings = new ArrayList<String>();
        for (Mapping map : this.mapper.getActiveMappings()) {
            if (!name.equals(map.map(map.getServiceName(), map.getSubServiceName())) && !this.hasPrincipal(map, name)) continue;
            mappings.add(map.getServiceName() + (map.getSubServiceName() != null ? ":" + map.getSubServiceName() : ""));
        }
        return mappings.toArray(new String[mappings.size()]);
    }

    private Collection<String> getBundles() {
        ArrayList<String> bundles = new ArrayList<String>();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            bundles.add(bundle.getSymbolicName());
        }
        Collections.sort(bundles);
        return bundles;
    }

    public String getLabel() {
        return LABEL;
    }

    private Resource getOrCreateServiceUser(HttpServletRequest request, ResourceResolver resolver) {
        String name = this.getParameter(request, PN_NAME, "");
        Session session = (Session)resolver.adaptTo(Session.class);
        try {
            UserManager userManager = AccessControlUtil.getUserManager((Session)session);
            if (userManager.getAuthorizable(name) != null) {
                Authorizable user = userManager.getAuthorizable(name);
                log.debug("Using existing user: {}", (Object)user);
                return resolver.getResource(user.getPath());
            }
            String userPath = this.getParameter(request, PN_USER_PATH, "system");
            log.debug("Creating new user with name {} and intermediate path {}", (Object)name, (Object)userPath);
            User user = userManager.createSystemUser(name, userPath);
            session.save();
            String path = "/home/users/" + userPath + "/" + name;
            log.debug("Moving {} to {}", (Object)user.getPath(), (Object)path);
            session.getWorkspace().move(user.getPath(), path);
            session.save();
            return resolver.getResource(path);
        }
        catch (RepositoryException e) {
            log.warn("Exception getting / creating service user {}", (Object)name, (Object)e);
            try {
                session.refresh(false);
            }
            catch (RepositoryException e1) {
                log.error("Unexpected exception reverting changes", (Throwable)e1);
            }
            return null;
        }
    }

    private String getParameter(HttpServletRequest request, String name, String defaultValue) {
        String value = request.getParameter(name);
        if (value != null && !value.trim().isEmpty()) {
            return value.trim();
        }
        return defaultValue;
    }

    private List<Pair<String, String>> getPrivileges(HttpServletRequest request) {
        ArrayList<Pair<String, String>> privileges = new ArrayList<Pair<String, String>>();
        ArrayList<String> params = Collections.list(request.getParameterNames());
        for (String param : params) {
            if (!param.startsWith("acl-path-")) continue;
            String path = request.getParameter(param);
            String privilege = request.getParameter(param.replace("-path-", "-privilege-"));
            if (StringUtils.isNotBlank((CharSequence)path) && StringUtils.isNotBlank((CharSequence)privilege)) {
                privileges.add((Pair<String, String>)new ImmutablePair((Object)path, (Object)privilege));
                continue;
            }
            log.warn("Unable to load ACL due to missing value {}={}", (Object)path, (Object)privilege);
        }
        return privileges;
    }

    private ResourceResolver getResourceResolver(HttpServletRequest request) {
        ResourceResolver resolver = null;
        try {
            resolver = (ResourceResolver)request.getAttribute("org.apache.sling.auth.core.ResourceResolver");
            if (resolver == null) {
                log.warn("Resource resolver not available in request, falling back to adminstrative resource resolver");
                resolver = this.resolverFactory.getAdministrativeResourceResolver(null);
            }
        }
        catch (LoginException le) {
            throw new RuntimeException("Unable to get Administrative Resource Resolver, add the bundle org.apache.sling.serviceuser.webconsole in the Apache Sling Login Admin Whitelist", le);
        }
        return resolver;
    }

    protected URL getResource(String path) {
        String base = "/serviceusers/";
        return path != null && path.startsWith(base) ? ((Object)((Object)this)).getClass().getResource(path.substring(base.length() - 1)) : null;
    }

    private String[] getSupportedPrivileges(HttpServletRequest request) {
        Object[] names = null;
        try {
            ResourceResolver resolver = this.getResourceResolver(request);
            Session session = (Session)resolver.adaptTo(Session.class);
            AccessControlManager accessControl = session.getAccessControlManager();
            Privilege[] privileges = accessControl.getSupportedPrivileges("/");
            names = new String[privileges.length];
            for (int i = 0; i < privileges.length; ++i) {
                names[i] = privileges[i].getName();
            }
            Arrays.sort(names);
        }
        catch (RepositoryException re) {
            log.error("Exception loading Supported Privileges", (Throwable)re);
        }
        return names;
    }

    public String getTitle() {
        return TITLE;
    }

    private boolean hasPrincipal(Mapping map, String name) {
        Iterable principals = map.mapPrincipals(map.getServiceName(), map.getSubServiceName());
        if (principals != null) {
            for (String principal : principals) {
                if (!principal.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private void info(PrintWriter pw, String text) {
        pw.print("<p class='statline ui-state-highlight'>");
        pw.print(this.xss.encodeForHTML(text));
        pw.println("</p>");
    }

    private void infoDiv(PrintWriter pw, String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        pw.println("<div>");
        pw.print("<span style='float:left'>");
        pw.print(this.xss.encodeForHTML(text));
        pw.println("</span>");
        pw.println("</div>");
    }

    @Activate
    protected void init(ComponentContext context) {
        this.bundleContext = context.getBundleContext();
    }

    private void printPrincipals(List<Mapping> activeMappings, PrintWriter pw) {
        ArrayList<ImmutablePair> mappings = new ArrayList<ImmutablePair>();
        for (Mapping mapping : activeMappings) {
            for (String principal : this.extractPrincipals(mapping)) {
                mappings.add(new ImmutablePair((Object)principal, (Object)mapping));
            }
        }
        Collections.sort(mappings, new Comparator<Pair<String, Mapping>>(){

            @Override
            public int compare(Pair<String, Mapping> o1, Pair<String, Mapping> o2) {
                if (((String)o1.getKey()).equals(o2.getKey())) {
                    return ((Mapping)o1.getValue()).getServiceName().compareTo(((Mapping)o2.getValue()).getServiceName());
                }
                return ((String)o1.getKey()).compareTo((String)o2.getKey());
            }
        });
        for (Pair pair : mappings) {
            this.tableRows(pw);
            pw.println("<td><a href=\"/system/console/serviceusers?action=details&amp;user=" + this.xss.encodeForHTML((String)pair.getKey()) + "\">" + this.xss.encodeForHTML((String)pair.getKey()) + "</a></td>");
            HashMap<String, Bundle> bundles = new HashMap<String, Bundle>();
            Bundle bundle = this.findBundle(((Mapping)pair.getValue()).getServiceName(), bundles);
            if (bundle != null) {
                this.bundleContext.getBundle();
                pw.println("<td><a href=\"/system/console/bundles/" + bundle.getBundleId() + "\">" + this.xss.encodeForHTML((String)bundle.getHeaders().get("Bundle-Name") + " (" + bundle.getSymbolicName()) + ")</a></td>");
                pw.println("<td>" + this.xss.encodeForHTML(((Mapping)pair.getValue()).getSubServiceName()) + "</td>");
                continue;
            }
            this.bundleContext.getBundle();
            pw.println("<td>" + this.xss.encodeForHTML(((Mapping)pair.getValue()).getServiceName()) + "</td>");
            pw.println("<td>" + this.xss.encodeForHTML(((Mapping)pair.getValue()).getSubServiceName() != null ? ((Mapping)pair.getValue()).getSubServiceName() : "") + "</td>");
        }
    }

    private void printPrivilegeSelect(PrintWriter pw, String label, List<Pair<String, String>> privileges, String[] supportedPrivileges, String alertMessage) {
        pw.print("<td style='width:20%'>");
        pw.print(this.xss.encodeForHTMLAttr(label));
        pw.println("</td>");
        pw.print("<td><table class=\"repeating-container\" style=\"width: 100%\" data-length=\"" + privileges.size() + "\"><tr><td>Path</td><td>Privilege</td><td></td>");
        int idx = 0;
        for (Pair<String, String> privilege : privileges) {
            pw.print("</tr><tr class=\"repeating-item\"><td>");
            pw.print("<input type=\"text\"  name=\"acl-path-" + idx + "\" value='");
            pw.print(this.xss.encodeForHTMLAttr(StringUtils.defaultString((String)((String)privilege.getKey()))));
            pw.print("' style='width:100%' />");
            pw.print("</td><td>");
            pw.print("<input type=\"text\" list=\"data-privileges\" name=\"acl-privilege-" + idx + "\" value='");
            pw.print(this.xss.encodeForHTMLAttr(StringUtils.defaultString((String)((String)privilege.getValue()))));
            pw.print("' style='width:100%' />");
            pw.print("</td><td>");
            pw.print("<input type=\"button\" value=\"&nbsp;-&nbsp;\" class=\"repeating-remove\" /></td>");
        }
        pw.print("</tr></table>");
        pw.print("<input type=\"button\" value=\"&nbsp;+&nbsp;\" class=\"repeating-add\" />");
        pw.print("<datalist id=\"data-privileges\">");
        for (String option : supportedPrivileges) {
            pw.print("<option");
            pw.print(">");
            pw.print(this.xss.encodeForHTMLAttr(option));
            pw.print("</option>");
        }
        pw.print("</datalist><script src=\"/system/console/serviceusers/res/ui/serviceusermanager.js\"></script>");
        this.infoDiv(pw, alertMessage);
        pw.println("</td>");
    }

    private void printServiceUserDetails(HttpServletRequest request, PrintWriter pw) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        String name = this.getParameter(request, PN_USER, "");
        this.tableStart(pw, "Details for " + name, 2);
        ResourceResolver resolver = this.getResourceResolver(request);
        ArrayList<String> affectedPaths = new ArrayList<String>();
        this.td(pw, "Service User Name", new String[0]);
        this.td(pw, name, new String[0]);
        this.tableRows(pw);
        this.td(pw, "User Path", new String[0]);
        Session session = (Session)resolver.adaptTo(Session.class);
        UserManager userManager = AccessControlUtil.getUserManager((Session)session);
        if (userManager.getAuthorizable(name) != null) {
            Authorizable user = userManager.getAuthorizable(name);
            this.td(pw, user.getPath(), new String[0]);
            affectedPaths.add(user.getPath());
        }
        this.tableRows(pw);
        String[] mappings = this.findMappings(resolver, name);
        this.td(pw, "Mappings", new String[0]);
        this.td(pw, mappings, new String[0]);
        this.tableRows(pw);
        this.td(pw, "OSGi Configurations", new String[0]);
        this.td(pw, this.findConfigurations(resolver, name, affectedPaths), new String[0]);
        this.tableRows(pw);
        this.td(pw, "ACLs", new String[0]);
        this.td(pw, this.findACLs(resolver, name, affectedPaths), new String[0]);
        this.tableEnd(pw);
        pw.write("<br/>");
        pw.write("<h3>Example Filter</h3>");
        pw.write("<br/>");
        pw.write("<pre><code>&lt;workspaceFilter version=\"1.0\"&gt;<br/>");
        for (String affectedPath : affectedPaths) {
            pw.write("  &lt;filter root=\"" + affectedPath + "\" /&gt;<br/>");
        }
        pw.write("&lt;/workspaceFilter\"&gt</code></pre>");
        pw.write("<br/>");
        pw.write("<h3>Use Example(s)</h3>");
        pw.write("<br/>");
        pw.write("<pre><code>");
        boolean includeNonSubService = false;
        for (String mapping : mappings) {
            if (mapping.contains(":")) {
                String subService = StringUtils.substringAfter((String)mapping, (String)":");
                pw.write("// Example using Sub Service " + subService + "<br/>ResourceResolver resolver = resolverFactory.getServiceResourceResolver(new HashMap<String, Object>() {<br/>  private static final long serialVersionUID = 1L;<br/>  {<br/>    put(ResourceResolverFactory.SUBSERVICE,\"" + subService + "\");<br/>  }<br/>});<br/><br/>");
                continue;
            }
            includeNonSubService = true;
        }
        if (includeNonSubService) {
            pw.write("// Example using bundle authentication<br/>ResourceResolver resolver = resolverFactory.getServiceResourceResolver(null);");
        }
        pw.write("</code></pre>");
    }

    private void printServiceUsers(HttpServletRequest request, PrintWriter pw) {
        pw.println("<form method='post' action='/system/console/serviceusers'>");
        this.tableStart(pw, "Create Service User", 2);
        String name = this.getParameter(request, PN_NAME, "");
        this.textField(pw, "Service User Name", PN_NAME, name, "The name of the service user to create, can already exist");
        this.tableRows(pw);
        String userContextPath = this.getParameter(request, PN_USER_PATH, "");
        this.textField(pw, "Intermediate Path", PN_USER_PATH, userContextPath, "Optional: The intermediate path under which to create the user. Should start with system, e.g. system/myapp");
        this.tableRows(pw);
        String bundle = this.getParameter(request, PN_BUNDLE, "");
        this.selectField(pw, "Bundle", PN_BUNDLE, bundle, this.getBundles(), "The bundle from which this service user will be useable");
        this.tableRows(pw);
        String serviceName = this.getParameter(request, PN_SUB_SERVICE, "");
        this.textField(pw, "Sub Service Name", PN_SUB_SERVICE, serviceName, "Optional: Allows for different permissions for different services within a bundle");
        this.tableRows(pw);
        String appPath = this.getParameter(request, PN_APP_PATH, "");
        this.textField(pw, "Application Path", PN_APP_PATH, appPath, "The application under which to create the OSGi Configuration for the Service User Mapping, e.g. /apps/myapp");
        this.tableRows(pw);
        List<Pair<String, String>> privileges = this.getPrivileges(request);
        this.printPrivilegeSelect(pw, "ACLs", privileges, this.getSupportedPrivileges(request), "Set the privileges for this service user");
        this.tableRows(pw);
        pw.println("<td></td>");
        pw.println("<td><input type='submit' value='Create / Update'/></td>");
        this.tableEnd(pw);
        pw.println("</form>");
        pw.println("<br/><br/>");
        List activeMappings = this.mapper.getActiveMappings();
        this.tableStart(pw, "Active Service Users", 3);
        pw.println("<th>Name</th>");
        pw.println("<th>Bundle</th>");
        pw.println("<th>SubService</th>");
        this.printPrincipals(activeMappings, pw);
        this.tableEnd(pw);
        pw.println("<br/>");
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action;
        PrintWriter pw = response.getWriter();
        pw.println("<br/>");
        String alert = this.getParameter(request, PN_ALERT, "");
        if (StringUtils.isNotBlank((CharSequence)alert)) {
            this.info(pw, alert);
        }
        if (StringUtils.isBlank((CharSequence)(action = this.getParameter(request, PN_ACTION, "")))) {
            log.debug("Rendering service users page");
            this.info(pw, "Service users are used by OSGi Services to access the Sling repository. Use this form to find and create service users.");
            this.printServiceUsers(request, pw);
        } else if ("details".equals(action)) {
            log.debug("Rendering service user details page");
            try {
                this.printServiceUserDetails(request, pw);
            }
            catch (RepositoryException e) {
                log.warn("Exception rendering details for user", (Throwable)e);
                this.info(pw, "Exception rendering details for user");
            }
        } else {
            this.info(pw, "Unknown action: " + action);
        }
    }

    private void selectField(PrintWriter pw, String label, String fieldName, String value, Collection<String> options, String ... alertMessages) {
        pw.print("<td style='width:20%'>");
        pw.print(this.xss.encodeForHTMLAttr(label));
        pw.println("</td>");
        pw.print("<td><input type=\"text\" list=\"data-" + this.xss.encodeForHTMLAttr(fieldName) + "\" name='");
        pw.print(this.xss.encodeForHTMLAttr(fieldName));
        pw.print("' value='");
        pw.print(this.xss.encodeForHTMLAttr(StringUtils.defaultString((String)value)));
        pw.print("' style='width:100%' />");
        pw.print("<datalist id=\"data-" + this.xss.encodeForHTMLAttr(fieldName) + "\">");
        for (String option : options) {
            pw.print("<option");
            pw.print(">");
            pw.print(this.xss.encodeForHTMLAttr(option));
            pw.print("</option>");
        }
        pw.print("</datalist>");
        for (String alertMessage : alertMessages) {
            this.infoDiv(pw, alertMessage);
        }
        pw.println("</td>");
    }

    private void sendErrorRedirect(HttpServletRequest request, HttpServletResponse response, String alert) throws IOException {
        ArrayList<String> params = new ArrayList<String>();
        for (String param : new String[]{PN_APP_PATH, PN_BUNDLE, PN_NAME, PN_SUB_SERVICE, PN_USER_PATH}) {
            params.add(param + "=" + URLEncoder.encode(this.getParameter(request, param, ""), "UTF-8"));
        }
        int idx = 0;
        List<Pair<String, String>> privs = this.getPrivileges(request);
        for (Pair<String, String> priv : privs) {
            params.add("acl-path-" + idx + "=" + URLEncoder.encode((String)priv.getKey(), "UTF-8"));
            params.add("acl-privilege-" + idx + "=" + URLEncoder.encode((String)priv.getValue(), "UTF-8"));
            ++idx;
        }
        if (StringUtils.isNotBlank((CharSequence)alert)) {
            params.add("alert=" + URLEncoder.encode(alert, "UTF-8"));
        }
        WebConsoleUtil.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)("/system/console/serviceusers?" + StringUtils.join(params, (String)"&")));
    }

    private void tableEnd(PrintWriter pw) {
        pw.println("</tr>");
        pw.println("</tbody>");
        pw.println("</table>");
    }

    private void tableRows(PrintWriter pw) {
        pw.println("</tr>");
        pw.println("<tr>");
    }

    private void tableStart(PrintWriter pw, String title, int colspan) {
        pw.println("<table class='nicetable ui-widget'>");
        pw.println("<thead class='ui-widget-header'>");
        pw.println("<tr>");
        pw.print("<th colspan=");
        pw.print(String.valueOf(colspan));
        pw.print(">");
        pw.print(this.xss.encodeForHTML(title));
        pw.println("</th>");
        pw.println("</tr>");
        pw.println("</thead>");
        pw.println("<tbody class='ui-widget-content'>");
        pw.println("<tr>");
    }

    private void td(PrintWriter pw, Object value, String ... title) {
        pw.print("<td");
        if (title.length > 0 && !StringUtils.isBlank((CharSequence)title[0])) {
            pw.print(" title='");
            pw.print(this.xss.encodeForHTML(title[0]));
            pw.print("'");
        }
        pw.print(">");
        if (value != null) {
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object itemValue = Array.get(value, i);
                    pw.print(this.xss.encodeForHTML(ObjectUtils.defaultIfNull((Object)itemValue, (Object)"").toString()));
                    pw.println("<br>");
                }
            } else {
                pw.print(this.xss.encodeForHTML(value.toString()));
            }
        }
        if (title.length > 0 && !StringUtils.isBlank((CharSequence)title[0])) {
            pw.print("<span class='ui-icon ui-icon-info' style='float:left'></span>");
        }
        pw.print("</td>");
    }

    private void textField(PrintWriter pw, String label, String fieldName, String value, String ... alertMessages) {
        pw.print("<td style='width:20%'>");
        pw.print(this.xss.encodeForHTMLAttr(label));
        pw.println("</td>");
        pw.print("<td><input name='");
        pw.print(this.xss.encodeForHTMLAttr(fieldName));
        pw.print("' value='");
        pw.print(this.xss.encodeForHTMLAttr(StringUtils.defaultString((String)value)));
        pw.print("' style='width:100%'/>");
        for (String alertMessage : alertMessages) {
            this.infoDiv(pw, alertMessage);
        }
        pw.println("</td>");
    }

    private boolean updatePrivileges(HttpServletRequest request, ResourceResolver resolver) {
        List<Pair<String, String>> privileges = this.getPrivileges(request);
        String name = this.getParameter(request, PN_NAME, "");
        ArrayList<String> currentPolicies = new ArrayList<String>();
        this.findACLs(resolver, name, currentPolicies);
        for (int i = 0; i < currentPolicies.size(); ++i) {
            String path = StringUtils.substringBefore((String)((String)currentPolicies.get(i)), (String)"/rep:policy");
            currentPolicies.set(i, (String)(StringUtils.isNotBlank((CharSequence)path) ? path : "/"));
        }
        log.debug("Loaded current policy paths: {}", currentPolicies);
        HashMap toSet = new HashMap();
        for (Pair pair : privileges) {
            if (!toSet.containsKey(pair.getKey())) {
                toSet.put(pair.getKey(), new ArrayList());
            }
            ((List)toSet.get(pair.getKey())).add(pair.getValue());
        }
        log.debug("Loaded updated policy paths: {}", currentPolicies);
        String lastEntry = null;
        try {
            Session session = (Session)resolver.adaptTo(Session.class);
            AccessControlManager accessManager = session.getAccessControlManager();
            PrincipalManager principalManager = AccessControlUtil.getPrincipalManager((Session)session);
            for (Map.Entry pol : toSet.entrySet()) {
                lastEntry = (String)pol.getKey();
                currentPolicies.remove(pol.getKey());
                log.debug("Updating policies for {}", pol.getKey());
                AccessControlPolicy[] policies = accessManager.getPolicies((String)pol.getKey());
                ArrayList<String> toRemove = new ArrayList<String>();
                for (AccessControlPolicy p : policies) {
                    if (!(p instanceof AccessControlList)) continue;
                    AccessControlList policy = (AccessControlList)p;
                    for (AccessControlEntry entry : policy.getAccessControlEntries()) {
                        Principal prin = entry.getPrincipal();
                        if (!prin.getName().equals(name)) continue;
                        for (Privilege privilege : entry.getPrivileges()) {
                            if (((List)pol.getValue()).contains(privilege.getName())) continue;
                            log.debug("Removing privilege {}", (Object)privilege);
                            toRemove.add(privilege.getName());
                        }
                    }
                }
                Principal principal = principalManager.getPrincipal(name);
                AccessControlUtil.replaceAccessControlEntry((Session)session, (String)((String)pol.getKey()), (Principal)principal, (String[])((List)pol.getValue()).toArray(new String[((List)pol.getValue()).size()]), (String[])new String[0], (String[])toRemove.toArray(new String[toRemove.size()]), null);
            }
            session.save();
            for (String oldPolicy : currentPolicies) {
                boolean removed = false;
                log.debug("Removing policy for {}", (Object)oldPolicy);
                AccessControlPolicy[] policies = accessManager.getPolicies(oldPolicy);
                AccessControlEntry toRemove = null;
                for (AccessControlPolicy p : policies) {
                    if (!(p instanceof AccessControlList)) continue;
                    AccessControlList policy = (AccessControlList)p;
                    for (AccessControlEntry entry : policy.getAccessControlEntries()) {
                        Principal prin = entry.getPrincipal();
                        if (!prin.getName().equals(name)) continue;
                        toRemove = entry;
                        break;
                    }
                    if (toRemove == null) continue;
                    removed = true;
                    policy.removeAccessControlEntry(toRemove);
                    accessManager.setPolicy(oldPolicy, (AccessControlPolicy)policy);
                    session.save();
                    log.debug("Removed access control entry {}", (Object)toRemove);
                }
                if (removed) continue;
                log.warn("No policy found for {}", (Object)oldPolicy);
            }
        }
        catch (RepositoryException repositoryException) {
            log.error("Exception updating principals with {}, failed on {}", new Object[]{toSet, lastEntry, repositoryException});
            return false;
        }
        return true;
    }
}

