/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.logservice.internal;

import java.util.Enumeration;
import org.apache.sling.commons.logservice.internal.LogSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class LogReaderServiceFactory
implements ServiceFactory {
    private LogSupport logSupport;

    LogReaderServiceFactory(LogSupport logSupport) {
        this.logSupport = logSupport;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        return new LogReaderServiceImpl(bundle);
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        ((LogReaderServiceImpl)service).shutdown();
    }

    private class LogReaderServiceImpl
    implements LogReaderService {
        private Bundle bundle;

        LogReaderServiceImpl(Bundle bundle) {
            this.bundle = bundle;
        }

        void shutdown() {
            LogReaderServiceFactory.this.logSupport.removeLogListeners(this.bundle);
        }

        @Override
        public void addLogListener(LogListener listener) {
            LogReaderServiceFactory.this.logSupport.addLogListener(this.bundle, listener);
        }

        @Override
        public void removeLogListener(LogListener listener) {
            LogReaderServiceFactory.this.logSupport.removeLogListener(listener);
        }

        @Override
        public Enumeration getLog() {
            return LogReaderServiceFactory.this.logSupport.getLog();
        }
    }
}

