/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.logservice.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.sling.commons.logservice.internal.LogReaderServiceFactory;
import org.apache.sling.commons.logservice.internal.LogServiceFactory;
import org.apache.sling.commons.logservice.internal.LogSupport;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;
import org.osgi.service.startlevel.StartLevel;

public class Activator
implements BundleActivator {
    private static final String VENDOR = "The Apache Software Foundation";
    private LogSupport logSupport;
    private ServiceReference startLevelRef;

    public void start(BundleContext context) throws Exception {
        this.startLevelRef = context.getServiceReference(StartLevel.class.getName());
        this.logSupport = new LogSupport((StartLevel)context.getService(this.startLevelRef));
        context.addBundleListener((BundleListener)this.logSupport);
        context.addFrameworkListener((FrameworkListener)this.logSupport);
        context.addServiceListener((ServiceListener)this.logSupport);
        LogServiceFactory lsf = new LogServiceFactory(this.logSupport);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", lsf.getClass().getName());
        ((Dictionary)props).put("service.description", "Apache Sling LogService implementation");
        ((Dictionary)props).put("service.vendor", VENDOR);
        context.registerService(LogService.class.getName(), (Object)lsf, props);
        LogReaderServiceFactory lrsf = new LogReaderServiceFactory(this.logSupport);
        props = new Hashtable();
        ((Dictionary)props).put("service.pid", lrsf.getClass().getName());
        ((Dictionary)props).put("service.description", "Apache Sling LogReaderService implementation");
        ((Dictionary)props).put("service.vendor", VENDOR);
        context.registerService(LogReaderService.class.getName(), (Object)lrsf, props);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.startLevelRef != null) {
            context.ungetService(this.startLevelRef);
        }
        if (this.logSupport != null) {
            context.removeBundleListener((BundleListener)this.logSupport);
            context.removeFrameworkListener((FrameworkListener)this.logSupport);
            context.removeServiceListener((ServiceListener)this.logSupport);
            this.logSupport.shutdown();
            this.logSupport = null;
        }
    }
}

