/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal.mapper;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.fsprovider.internal.ContentFileExtensions;
import org.apache.sling.fsprovider.internal.FileStatCache;
import org.apache.sling.fsprovider.internal.FsResourceMapper;
import org.apache.sling.fsprovider.internal.mapper.Escape;
import org.apache.sling.fsprovider.internal.mapper.FileNameComparator;
import org.apache.sling.fsprovider.internal.mapper.FileResource;
import org.apache.sling.fsprovider.internal.parser.ContentFileCache;

public final class FileResourceMapper
implements FsResourceMapper {
    private final String providerRoot;
    private final String providerRootPrefix;
    private final File providerFile;
    private final ContentFileExtensions contentFileExtensions;
    private final ContentFileCache contentFileCache;
    private FileStatCache fileStatCache;

    public FileResourceMapper(String providerRoot, File providerFile, ContentFileExtensions contentFileExtensions, ContentFileCache contentFileCache, FileStatCache fileStatCache) {
        this.providerRoot = providerRoot;
        this.providerRootPrefix = providerRoot.concat("/");
        this.providerFile = providerFile;
        this.contentFileExtensions = contentFileExtensions;
        this.contentFileCache = contentFileCache;
        this.fileStatCache = fileStatCache;
    }

    @Override
    public Resource getResource(ResourceResolver resolver, String resourcePath) {
        File file = this.getFile(resourcePath);
        if (file != null) {
            return new FileResource(resolver, resourcePath, file, this.contentFileExtensions, this.contentFileCache, this.fileStatCache);
        }
        return null;
    }

    @Override
    public Iterator<Resource> getChildren(final ResourceResolver resolver, Resource parent) {
        final String parentPath = parent.getPath();
        File parentFile = (File)parent.adaptTo(File.class);
        if (parentFile == null && (parentFile = this.getFile(parentPath)) == null) {
            String relPath;
            String parentPathPrefix;
            if (!StringUtils.startsWith((CharSequence)parentPath, (CharSequence)this.providerRoot) && this.providerRoot.startsWith(parentPathPrefix = parentPath.concat("/")) && (relPath = this.providerRoot.substring(parentPathPrefix.length())).indexOf(47) < 0) {
                FileResource res = new FileResource(resolver, this.providerRoot, this.providerFile, this.contentFileExtensions, this.contentFileCache, this.fileStatCache);
                return IteratorUtils.singletonIterator((Object)((Object)res));
            }
            return null;
        }
        Object[] files = parentFile.listFiles();
        if (files == null) {
            return null;
        }
        Arrays.sort(files, FileNameComparator.INSTANCE);
        Iterator children = IteratorUtils.filteredIterator((Iterator)IteratorUtils.arrayIterator((Object[])files), (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                File file = (File)object;
                return !FileResourceMapper.this.contentFileExtensions.matchesSuffix(file);
            }
        });
        if (!children.hasNext()) {
            return null;
        }
        return IteratorUtils.transformedIterator((Iterator)children, (Transformer)new Transformer(){

            public Object transform(Object input) {
                File file = (File)input;
                String path = parentPath + "/" + Escape.fileToResourceName(file.getName());
                return new FileResource(resolver, path, file, FileResourceMapper.this.contentFileExtensions, FileResourceMapper.this.contentFileCache, FileResourceMapper.this.fileStatCache);
            }
        });
    }

    private File getFile(String path) {
        String relPath;
        File file;
        if (path.equals(this.providerRoot)) {
            return this.providerFile;
        }
        if (path.startsWith(this.providerRootPrefix) && !this.contentFileExtensions.matchesSuffix(file = new File(this.providerFile, relPath = Escape.resourceToFileName(path.substring(this.providerRootPrefix.length())))) && this.fileStatCache.exists(file)) {
            return file;
        }
        return null;
    }
}

