/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.fsprovider.internal.ContentFileExtensions;
import org.apache.sling.fsprovider.internal.FileStatCache;
import org.apache.sling.fsprovider.internal.FsMode;
import org.apache.sling.fsprovider.internal.FsResourceProvider;
import org.apache.sling.fsprovider.internal.mapper.ContentFile;
import org.apache.sling.fsprovider.internal.parser.ContentElement;
import org.apache.sling.fsprovider.internal.parser.ContentFileCache;
import org.apache.sling.spi.resource.provider.ObservationReporter;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileMonitor
extends TimerTask {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Timer timer = new Timer();
    private boolean stop = false;
    private boolean stopped = true;
    private final Monitorable root;
    private final FsResourceProvider provider;
    private final FsMode fsMode;
    private final ContentFileExtensions contentFileExtensions;
    private final ContentFileCache contentFileCache;
    private final FileStatCache fileStatCache;

    public FileMonitor(FsResourceProvider provider, long interval, FsMode fsMode, ContentFileExtensions contentFileExtensions, ContentFileCache contentFileCache, FileStatCache fileStatCache) {
        this.provider = provider;
        this.fsMode = fsMode;
        this.contentFileExtensions = contentFileExtensions;
        this.contentFileCache = contentFileCache;
        this.fileStatCache = fileStatCache;
        File rootFile = this.provider.getRootFile();
        if (fsMode == FsMode.FILEVAULT_XML) {
            rootFile = new File(this.provider.getRootFile(), "." + PlatformNameFormat.getPlatformPath((String)this.provider.getProviderRoot()));
        }
        this.root = new Monitorable(this.provider.getProviderRoot(), rootFile, null);
        FileMonitor.createStatus(this.root, contentFileExtensions, contentFileCache);
        this.log.debug("Starting file monitor for {} with an interval of {}ms", (Object)this.root.file, (Object)interval);
        this.timer.schedule((TimerTask)this, 0L, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Timer timer = this.timer;
        synchronized (timer) {
            if (!this.stop) {
                this.stop = true;
                this.cancel();
                this.timer.cancel();
            }
            boolean interrupted = false;
            while (!this.stopped) {
                try {
                    this.timer.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.debug("Stopped file monitor for {}", (Object)this.root.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.timer;
        synchronized (object) {
            this.stopped = false;
            if (this.stop) {
                this.stopped = true;
                this.timer.notifyAll();
                return;
            }
        }
        object = this;
        synchronized (object) {
            try {
                ObservationReporter reporter = this.provider.getObservationReporter();
                if (reporter != null) {
                    this.check(this.root, reporter);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.timer;
        synchronized (object) {
            this.stopped = true;
            this.timer.notifyAll();
        }
    }

    private void check(Monitorable monitorable, ObservationReporter reporter) {
        this.log.trace("Checking {}", (Object)monitorable.file);
        if (monitorable.status instanceof NonExistingStatus) {
            if (monitorable.file.exists()) {
                FileMonitor.createStatus(monitorable, this.contentFileExtensions, this.contentFileCache);
                this.fileStatCache.clear();
                this.sendEvents(monitorable, ResourceChange.ChangeType.ADDED, reporter);
                FileStatus fs = (FileStatus)monitorable.status;
                if (fs instanceof DirStatus) {
                    DirStatus ds = (DirStatus)fs;
                    ds.children = new Monitorable[0];
                    this.checkDirStatusChildren(monitorable, reporter);
                }
            }
        } else if (!monitorable.file.exists()) {
            this.contentFileCache.remove(this.transformPath(monitorable.path));
            monitorable.status = NonExistingStatus.SINGLETON;
            this.fileStatCache.clear();
            this.sendEvents(monitorable, ResourceChange.ChangeType.REMOVED, reporter);
        } else {
            FileStatus fs = (FileStatus)monitorable.status;
            boolean changed = false;
            if (fs.lastModified < monitorable.file.lastModified()) {
                fs.lastModified = monitorable.file.lastModified();
                this.contentFileCache.remove(this.transformPath(monitorable.path));
                this.sendEvents(monitorable, ResourceChange.ChangeType.CHANGED, reporter);
                changed = true;
            }
            if (fs instanceof DirStatus) {
                DirStatus ds = (DirStatus)fs;
                for (int i = 0; i < ds.children.length; ++i) {
                    this.check(ds.children[i], reporter);
                }
                if (changed) {
                    this.checkDirStatusChildren(monitorable, reporter);
                }
            }
        }
    }

    private void checkDirStatusChildren(Monitorable dirMonitorable, ObservationReporter reporter) {
        DirStatus ds = (DirStatus)dirMonitorable.status;
        File[] files = dirMonitorable.file.listFiles();
        if (files != null) {
            Monitorable[] children = new Monitorable[files.length];
            for (int i = 0; i < files.length; ++i) {
                for (int m = 0; m < ds.children.length; ++m) {
                    if (!ds.children[m].file.equals(files[i])) continue;
                    children[i] = ds.children[m];
                    break;
                }
                if (children[i] != null) continue;
                children[i] = new Monitorable(dirMonitorable.path + '/' + files[i].getName(), files[i], this.contentFileExtensions.getSuffix(files[i]));
                children[i].status = NonExistingStatus.SINGLETON;
                this.check(children[i], reporter);
            }
            ds.children = children;
        } else {
            ds.children = new Monitorable[0];
        }
    }

    private void sendEvents(Monitorable monitorable, ResourceChange.ChangeType changeType, ObservationReporter reporter) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Detected change for resource {} : {}", (Object)this.transformPath(monitorable.path), (Object)changeType);
        }
        List<ResourceChange> changes = null;
        for (ObserverConfiguration config : reporter.getObserverConfigurations()) {
            if (!config.matches(this.transformPath(monitorable.path))) continue;
            if (changes == null) {
                changes = this.collectResourceChanges(monitorable, changeType);
            }
            if (!this.log.isTraceEnabled()) continue;
            for (ResourceChange change : changes) {
                this.log.debug("Send change for resource {}: {} to {}", new Object[]{change.getPath(), change.getType(), config});
            }
        }
        if (changes != null) {
            reporter.reportChanges(changes, false);
        }
    }

    private String transformPath(String path) {
        if (this.fsMode == FsMode.FILEVAULT_XML) {
            return PlatformNameFormat.getRepositoryPath((String)path);
        }
        return path;
    }

    private List<ResourceChange> collectResourceChanges(Monitorable monitorable, ResourceChange.ChangeType changeType) {
        ArrayList<ResourceChange> changes = new ArrayList<ResourceChange>();
        if (monitorable.status instanceof ContentFileStatus) {
            ContentFile contentFile = ((ContentFileStatus)monitorable.status).contentFile;
            if (changeType == ResourceChange.ChangeType.CHANGED) {
                ContentElement content = contentFile.getContent();
                changes.add(this.buildContentResourceChange(ResourceChange.ChangeType.REMOVED, this.transformPath(monitorable.path)));
                this.addContentResourceChanges(changes, ResourceChange.ChangeType.ADDED, content, this.transformPath(monitorable.path));
            } else {
                this.addContentResourceChanges(changes, changeType, contentFile.getContent(), this.transformPath(monitorable.path));
            }
        } else {
            changes.add(this.buildContentResourceChange(changeType, this.transformPath(monitorable.path)));
        }
        return changes;
    }

    private void addContentResourceChanges(List<ResourceChange> changes, ResourceChange.ChangeType changeType, ContentElement content, String path) {
        changes.add(this.buildContentResourceChange(changeType, path));
        if (content != null) {
            for (Map.Entry<String, ContentElement> entry : content.getChildren().entrySet()) {
                String childPath = path + "/" + entry.getKey();
                this.addContentResourceChanges(changes, changeType, entry.getValue(), childPath);
            }
        }
    }

    private ResourceChange buildContentResourceChange(ResourceChange.ChangeType changeType, String path) {
        return new ResourceChange(changeType, path, false, null, null, null);
    }

    private static void createStatus(Monitorable monitorable, ContentFileExtensions contentFileExtensions, ContentFileCache contentFileCache) {
        monitorable.status = !monitorable.file.exists() ? NonExistingStatus.SINGLETON : (monitorable.file.isFile() ? (contentFileExtensions.matchesSuffix(monitorable.file) ? new ContentFileStatus(monitorable.file, new ContentFile(monitorable.file, monitorable.path, null, contentFileCache)) : new FileStatus(monitorable.file)) : new DirStatus(monitorable.file, monitorable.path, contentFileExtensions, contentFileCache));
    }

    private static final class NonExistingStatus {
        public static NonExistingStatus SINGLETON = new NonExistingStatus();

        private NonExistingStatus() {
        }
    }

    private static final class DirStatus
    extends FileStatus {
        public Monitorable[] children;

        public DirStatus(File dir, String path, ContentFileExtensions contentFileExtensions, ContentFileCache contentFileCache) {
            super(dir);
            File[] files = dir.listFiles();
            if (files != null) {
                this.children = new Monitorable[files.length];
                for (int i = 0; i < files.length; ++i) {
                    this.children[i] = new Monitorable(path + '/' + files[i].getName(), files[i], contentFileExtensions.getSuffix(files[i]));
                    FileMonitor.createStatus(this.children[i], contentFileExtensions, contentFileCache);
                }
            } else {
                this.children = new Monitorable[0];
            }
        }
    }

    private static class ContentFileStatus
    extends FileStatus {
        public final ContentFile contentFile;

        public ContentFileStatus(File file, ContentFile contentFile) {
            super(file);
            this.contentFile = contentFile;
        }
    }

    private static class FileStatus {
        public long lastModified;

        public FileStatus(File file) {
            this.lastModified = file.lastModified();
        }
    }

    private static final class Monitorable {
        public final String path;
        public final File file;
        public Object status;

        public Monitorable(String path, File file, String contentFileSuffix) {
            this.file = file;
            this.path = contentFileSuffix != null ? StringUtils.substringBeforeLast((String)path, (String)contentFileSuffix) : path;
        }
    }
}

