/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.wrapper;

import java.util.Iterator;
import org.apache.commons.collections.IteratorUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.scripting.javascript.SlingWrapper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptableResource
extends ScriptableObject
implements SlingWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptableResource.class);
    public static final String CLASSNAME = "Resource";
    private static final Class<?>[] WRAPPED_CLASSES = new Class[]{Resource.class};
    private Resource resource;
    private ValueMap properties;

    public ScriptableResource() {
    }

    public ScriptableResource(Resource resource) {
        this.resource = resource;
    }

    public void jsConstructor(Object res) {
        this.resource = (Resource)res;
    }

    public String jsGet_name() {
        return this.jsFunction_getName();
    }

    public String jsFunction_getName() {
        return this.resource.getName();
    }

    public String jsGet_path() {
        return this.jsFunction_getPath();
    }

    public String jsFunction_getPath() {
        return this.resource.getPath();
    }

    @Deprecated
    public String jsGet_type() {
        return this.jsFunction_getResourceType();
    }

    public String jsGet_resourceType() {
        return this.jsFunction_getResourceType();
    }

    public String jsFunction_getResourceType() {
        return this.resource.getResourceType();
    }

    public NativeArray jsFunction_listChildren() {
        return this.jsFunction_getChildren();
    }

    public NativeArray jsFunction_getChildren() {
        return new NativeArray(IteratorUtils.toArray((Iterator)this.resource.listChildren()));
    }

    public Object jsGet_parent() {
        return this.jsFunction_getParent();
    }

    public Object jsFunction_getParent() {
        return this.resource.getParent();
    }

    public String jsGet_resourceSuperType() {
        return this.jsFunction_getResourceSuperType();
    }

    public String jsFunction_getResourceSuperType() {
        return this.resource.getResourceSuperType();
    }

    public boolean jsFunction_isResourceType(String type) {
        return this.resource.isResourceType(type);
    }

    @Deprecated
    public Object jsGet_meta() {
        return this.jsFunction_getResourceMetadata();
    }

    public Object jsGet_resourceMetadata() {
        return this.jsFunction_getResourceMetadata();
    }

    @Deprecated
    public Object jsFunction_getMetadata() {
        return this.jsFunction_getResourceMetadata();
    }

    public Object jsFunction_getResourceMetadata() {
        return this.toJS(this.resource.getResourceMetadata());
    }

    public Object jsFunction_getResourceResolver() {
        return this.toJS(this.resource.getResourceResolver());
    }

    public Object jsGet_resourceResolver() {
        return this.jsFunction_getResourceResolver();
    }

    public Object jsFunction_getChild(String childPath) {
        return this.resource.getChild(childPath);
    }

    public Object jsFunction_getObject() {
        return this.toJS(this.resource.adaptTo(Object.class));
    }

    public static Object jsFunction_adaptTo(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object arg;
        Object object = arg = args.length > 0 ? args[0] : null;
        while (arg instanceof Wrapper) {
            arg = ((Wrapper)arg).unwrap();
        }
        Class<?> adapter = null;
        if (arg instanceof Class) {
            adapter = (Class<?>)arg;
        } else if (arg != null && arg != Undefined.instance) {
            String className = ScriptRuntime.toString((Object)arg);
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader == null) {
                    loader = thisObj.getClass().getClassLoader();
                }
                adapter = loader.loadClass(className);
            }
            catch (Exception e) {
                LOGGER.error("Unable to adapt object.", (Throwable)e);
            }
        }
        if (adapter != null) {
            ScriptableResource sr = (ScriptableResource)thisObj;
            return sr.toJS(sr.resource.adaptTo((Class)adapter));
        }
        return Undefined.instance;
    }

    public Object jsGet_properties() {
        if (this.properties == null) {
            this.properties = (ValueMap)this.resource.adaptTo(ValueMap.class);
        }
        return this.properties;
    }

    @Override
    public String getClassName() {
        return CLASSNAME;
    }

    public Object getDefaultValue(Class typeHint) {
        if (this.resource != null) {
            return this.resource.getPath();
        }
        return String.valueOf(null);
    }

    public void setResource(Resource entry) {
        this.resource = entry;
    }

    @Override
    public Class<?>[] getWrappedClasses() {
        return WRAPPED_CLASSES;
    }

    public Object unwrap() {
        return this.resource;
    }

    private Object toJS(Object javaObject) {
        if (javaObject == null) {
            return Undefined.instance;
        }
        return ScriptRuntime.toObject((Scriptable)this, (Object)javaObject);
    }
}

