/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.javascript.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.javascript.helper.ModuleScope;
import org.apache.sling.scripting.javascript.io.EspReader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionCall;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingGlobal
implements Serializable,
IdFunctionCall {
    static final long serialVersionUID = 6080442165748707530L;
    private static final Object FTAG = new Object();
    private static final int Id_load = 1;
    private static final int Id_print = 2;
    private static final int Id_require = 3;
    private static final int LAST_SCOPE_FUNCTION_ID = 3;
    private static final Logger defaultLog = LoggerFactory.getLogger(SlingGlobal.class);

    public static void init(Scriptable scope, boolean sealed) {
        SlingGlobal obj = new SlingGlobal();
        for (int id = 1; id <= 3; ++id) {
            String name;
            int arity = 1;
            switch (id) {
                case 1: {
                    name = "load";
                    break;
                }
                case 2: {
                    name = "print";
                    break;
                }
                case 3: {
                    name = "require";
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            IdFunctionObject f = new IdFunctionObject((IdFunctionCall)obj, FTAG, id, name, arity, scope);
            if (sealed) {
                f.sealObject();
            }
            f.exportAsScopeProperty();
        }
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (f.hasTag(FTAG)) {
            int methodId = f.methodId();
            switch (methodId) {
                case 1: {
                    this.load(cx, thisObj, args);
                    return Context.getUndefinedValue();
                }
                case 2: {
                    this.print(cx, thisObj, args);
                    return Context.getUndefinedValue();
                }
                case 3: {
                    return this.require(cx, thisObj, args);
                }
            }
        }
        throw f.unknown();
    }

    private void print(Context cx, Scriptable thisObj, Object[] args) {
        StringBuffer message = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                message.append(" ");
            }
            String s = ScriptRuntime.toString((Object)args[i]);
            message.append(s);
        }
        this.getLogger(cx, thisObj).info(message.toString());
    }

    private void load(Context cx, Scriptable thisObj, Object[] args) {
        SlingScriptHelper sling = this.getProperty(cx, thisObj, "sling", SlingScriptHelper.class);
        if (sling == null) {
            throw new NullPointerException("sling");
        }
        Scriptable globalScope = ScriptableObject.getTopLevelScope((Scriptable)thisObj);
        Resource scriptResource = sling.getScript().getScriptResource();
        ResourceResolver resolver = scriptResource.getResourceResolver();
        String currentScript = sling.getScript().getScriptResource().getPath();
        String scriptParent = ResourceUtil.getParent((String)currentScript);
        for (Object arg : args) {
            String scriptName = ScriptRuntime.toString((Object)arg);
            Resource loadScript = null;
            if (!scriptName.startsWith("/")) {
                String absScriptName = scriptParent + "/" + scriptName;
                loadScript = resolver.resolve(absScriptName);
            }
            if (loadScript == null) {
                loadScript = resolver.resolve(scriptName);
            }
            if (loadScript == null) {
                throw Context.reportRuntimeError((String)("Script file " + scriptName + " not found"));
            }
            InputStream scriptStream = (InputStream)loadScript.adaptTo(InputStream.class);
            if (scriptStream == null) {
                throw Context.reportRuntimeError((String)("Script file " + scriptName + " cannot be read from"));
            }
            try {
                Reader scriptReader = new InputStreamReader(scriptStream, Charset.forName("UTF-8"));
                if (scriptName.endsWith("esp")) {
                    scriptReader = new EspReader(scriptReader);
                }
                scriptReader = new BufferedReader(scriptReader);
                cx.evaluateReader(globalScope, scriptReader, scriptName, 1, null);
            }
            catch (IOException ioe) {
                throw Context.reportRuntimeError((String)("Failure reading file " + scriptName + ": " + ioe));
            }
            finally {
                try {
                    scriptStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Object require(Context cx, Scriptable thisObj, Object[] args) {
        if (args.length != 1 || !(args[0] instanceof String)) {
            throw Context.reportRuntimeError((String)"require() requires a String argument");
        }
        String modulePath = (String)args[0];
        ModuleScope moduleScope = null;
        if (thisObj instanceof ModuleScope) {
            moduleScope = (ModuleScope)thisObj;
        }
        ModuleScope module = this.loadModule(cx, modulePath.trim(), moduleScope, thisObj);
        return module.getExports();
    }

    private ModuleScope loadModule(Context cx, String modulePath, ModuleScope moduleScope, Scriptable thisObj) {
        String absolutePath = modulePath;
        if (modulePath.startsWith(".")) {
            if (moduleScope == null) {
                throw Context.reportRuntimeError((String)"Cannot resolve relative module name outside of a module scope.");
            }
            absolutePath = (moduleScope.getModuleName() + "/" + modulePath).replaceAll("[^/]*/\\./", "");
            while (absolutePath.matches("([^/]*/)?[^/]*/\\.\\./")) {
                absolutePath = absolutePath.replaceAll("([^/]*/)?[^/]*/\\.\\./", "");
            }
        }
        absolutePath = absolutePath + ".js";
        SlingScriptHelper sling = this.getProperty(cx, thisObj, "sling", SlingScriptHelper.class);
        if (sling == null) {
            throw new NullPointerException("sling");
        }
        ResourceResolver resrev = sling.getScript().getScriptResource().getResourceResolver();
        Resource script = null;
        String scriptName = null;
        for (String basepath : resrev.getSearchPath()) {
            script = resrev.resolve(basepath + absolutePath);
            if (script == null || script instanceof NonExistingResource) continue;
            scriptName = basepath + absolutePath;
            break;
        }
        if (script == null) {
            throw Context.reportRuntimeError((String)("Unable to resolve module " + absolutePath + " in search path"));
        }
        InputStream scriptStream = (InputStream)script.adaptTo(InputStream.class);
        if (scriptStream == null && (scriptStream = (InputStream)resrev.resolve(scriptName).adaptTo(InputStream.class)) == null) {
            throw Context.reportRuntimeError((String)("Script file " + script.getPath() + " cannot be read"));
        }
        try {
            Reader scriptReader = new InputStreamReader(scriptStream, Charset.forName("UTF-8"));
            if (scriptName.endsWith("esp")) {
                scriptReader = new EspReader(scriptReader);
            }
            scriptReader = new BufferedReader(scriptReader);
            ModuleScope scope = moduleScope;
            if (scope == null) {
                scope = new ModuleScope(thisObj, absolutePath.substring(0, absolutePath.length() - 3));
            } else {
                scope.reset();
            }
            cx.evaluateReader((Scriptable)scope, scriptReader, scriptName, 1, null);
            ModuleScope moduleScope2 = scope;
            return moduleScope2;
        }
        catch (IOException ioe) {
            throw Context.reportRuntimeError((String)("Failure reading file " + scriptName + ": " + ioe));
        }
        finally {
            try {
                scriptStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Logger getLogger(Context cx, Scriptable scope) {
        Logger log = this.getProperty(cx, scope, "log", Logger.class);
        if (log == null) {
            log = defaultLog;
        }
        return log;
    }

    private <Type> Type getProperty(Context cx, Scriptable scope, String name, Class<Type> type) {
        Object prop = ScriptRuntime.name((Context)cx, (Scriptable)scope, (String)name);
        if (prop instanceof Wrapper) {
            prop = ((Wrapper)prop).unwrap();
        }
        if (type.isInstance(prop)) {
            return (Type)prop;
        }
        return null;
    }
}

