/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.spi.resource.provider;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class ResourceProvider<T> {
    public static final String PROPERTY_ROOT = "provider.root";
    public static final String PROPERTY_NAME = "provider.name";
    public static final String PROPERTY_USE_RESOURCE_ACCESS_SECURITY = "provider.useResourceAccessSecurity";
    public static final String AUTHENTICATE_NO = "no";
    public static final String AUTHENTICATE_REQUIRED = "required";
    public static final String AUTHENTICATE_LAZY = "lazy";
    public static final String PROPERTY_AUTHENTICATE = "provider.authenticate";
    public static final String PROPERTY_MODIFIABLE = "provider.modifiable";
    public static final String PROPERTY_ADAPTABLE = "provider.adaptable";
    public static final String PROPERTY_REFRESHABLE = "provider.refreshable";
    public static final String PROPERTY_ATTRIBUTABLE = "provider.attributable";
    public static final String AUTH_SERVICE_BUNDLE = "sling.service.bundle";
    public static final String AUTH_ADMIN = "provider.auth.admin";
    public static final String AUTH_CLONE = "provider.auth.clone";
    public static final String RESOURCE_TYPE_SYNTHETIC = "sling:syntheticResourceProviderResource";
    private volatile ProviderContext ctx;

    public void start(@NotNull ProviderContext ctx) {
        this.ctx = ctx;
    }

    public void stop() {
        this.ctx = null;
    }

    public void update(long changeSet) {
    }

    @Nullable
    protected ProviderContext getProviderContext() {
        return this.ctx;
    }

    @Nullable
    public T authenticate(@NotNull Map<String, Object> authenticationInfo) throws LoginException {
        return null;
    }

    public void logout(@Nullable T state) {
    }

    public void refresh(@NotNull ResolveContext<T> ctx) {
    }

    public boolean isLive(@NotNull ResolveContext<T> ctx) {
        return true;
    }

    @Nullable
    public Resource getParent(@NotNull ResolveContext<T> ctx, @NotNull Resource child) {
        String parentPath = ResourceUtil.getParent(child.getPath());
        if (parentPath == null) {
            return null;
        }
        return this.getResource(ctx, parentPath, ResourceContext.EMPTY_CONTEXT, null);
    }

    @Nullable
    public abstract Resource getResource(@NotNull ResolveContext<T> var1, @NotNull String var2, @NotNull ResourceContext var3, @Nullable Resource var4);

    @Nullable
    public abstract Iterator<Resource> listChildren(@NotNull ResolveContext<T> var1, @NotNull Resource var2);

    @Nullable
    public Collection<String> getAttributeNames(@NotNull ResolveContext<T> ctx) {
        return null;
    }

    @Nullable
    public Object getAttribute(@NotNull ResolveContext<T> ctx, @NotNull String name) {
        return null;
    }

    @NotNull
    public Resource create(@NotNull ResolveContext<T> ctx, String path, Map<String, Object> properties) throws PersistenceException {
        throw new PersistenceException("create is not supported.");
    }

    public void delete(@NotNull ResolveContext<T> ctx, @NotNull Resource resource) throws PersistenceException {
        throw new PersistenceException("delete is not supported.");
    }

    public void revert(@NotNull ResolveContext<T> ctx) {
    }

    public void commit(@NotNull ResolveContext<T> ctx) throws PersistenceException {
    }

    public boolean hasChanges(@NotNull ResolveContext<T> ctx) {
        return false;
    }

    @Nullable
    public QueryLanguageProvider<T> getQueryLanguageProvider() {
        return null;
    }

    @Nullable
    public <AdapterType> AdapterType adaptTo(@NotNull ResolveContext<T> ctx, @NotNull Class<AdapterType> type) {
        return null;
    }

    public boolean copy(@NotNull ResolveContext<T> ctx, @NotNull String srcAbsPath, @NotNull String destAbsPath) throws PersistenceException {
        return false;
    }

    public boolean move(@NotNull ResolveContext<T> ctx, @NotNull String srcAbsPath, @NotNull String destAbsPath) throws PersistenceException {
        return false;
    }
}

