/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.sling.installer.core.impl.RegisteredResourceImpl;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataStore {
    private static final Logger log = LoggerFactory.getLogger(FileDataStore.class);
    private static final String CONFIG_DIR = "sling.installer.dir";
    private static final String DEFAULT_DIR = "installer";
    private final File directory;
    public static FileDataStore SHARED;
    private final Map<String, CacheEntry> digestCache = new HashMap<String, CacheEntry>();
    private static long serialNumberCounter;

    public FileDataStore(BundleContext bundleContext) {
        File locationFile;
        String location = bundleContext.getProperty(CONFIG_DIR);
        if (location == null && (locationFile = bundleContext.getDataFile(DEFAULT_DIR)) != null) {
            location = locationFile.getAbsolutePath();
        }
        if (location == null) {
            location = System.getProperty("user.dir") + File.separatorChar + DEFAULT_DIR;
        }
        if (!(locationFile = new File(location)).isAbsolute()) {
            File bundleLocationFile = bundleContext.getDataFile(locationFile.getPath());
            if (bundleLocationFile != null) {
                locationFile = bundleLocationFile;
            }
            locationFile = locationFile.getAbsoluteFile();
        }
        if (!locationFile.isDirectory()) {
            if (locationFile.exists()) {
                throw new IllegalArgumentException(location + " is not a directory");
            }
            if (!locationFile.mkdirs()) {
                throw new IllegalArgumentException("Cannot create directory " + location);
            }
        }
        this.directory = locationFile;
        SHARED = this;
        log.debug("FileDataStore setup with directory={}", (Object)FileDataStore.safePath(this.directory));
    }

    public File getDataFile(String fileName) {
        File result = new File(this.directory, fileName);
        log.debug("getDataFile({}) returns {}", (Object)fileName, (Object)FileDataStore.safePath(result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextSerialNumber() {
        Class<RegisteredResourceImpl> clazz = RegisteredResourceImpl.class;
        synchronized (RegisteredResourceImpl.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return serialNumberCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createNewDataFile(InputStream stream, String url, String digest, String hint) throws IOException {
        if (digest != null) {
            Map<String, CacheEntry> map = this.digestCache;
            synchronized (map) {
                CacheEntry storedDigest = this.digestCache.get(url);
                if (storedDigest != null && storedDigest.digest.equals(digest)) {
                    log.debug("File {} with digest {} found, returning {}", new Object[]{url, digest, FileDataStore.safePath(storedDigest.file)});
                    return storedDigest.file;
                }
            }
        }
        int pos = url.lastIndexOf(47);
        String name = url.substring(pos + 1);
        String filename = (hint == null ? "rsrc" : hint) + '-' + name + '-' + FileDataStore.getNextSerialNumber() + ".ser";
        String filename2 = filename.replaceAll("[\\*\"/\\\\\\[\\]\\:\\;\\|\\=\\,]+", "_");
        File file = this.getDataFile(filename2);
        this.copyToLocalStorage(stream, file);
        log.debug("Stream with digest {} copied to {}", (Object)digest, (Object)FileDataStore.safePath(file));
        if (digest != null) {
            Map<String, CacheEntry> map = this.digestCache;
            synchronized (map) {
                this.digestCache.put(url, new CacheEntry(file, digest));
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDigestCache(String url, File file, String digest) {
        log.debug("Updating digest cache for {}, file {}, digest {}", new Object[]{url, FileDataStore.safePath(file), digest});
        Map<String, CacheEntry> map = this.digestCache;
        synchronized (map) {
            this.digestCache.put(url, new CacheEntry(file, digest));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyToLocalStorage(InputStream data, File dataFile) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(dataFile));){
            byte[] buffer = new byte[16384];
            int count = 0;
            while ((count = data.read(buffer, 0, buffer.length)) > 0) {
                ((OutputStream)os).write(buffer, 0, count);
            }
            ((OutputStream)os).flush();
        }
    }

    public File createNewDataFile(String hint, InputStream stream) throws IOException {
        String filename = (hint == null ? "unknown" : hint) + "-resource-" + FileDataStore.getNextSerialNumber() + ".ser";
        File file = this.getDataFile(filename);
        log.debug("createNewDataFile: file={}", (Object)FileDataStore.safePath(file));
        this.copyToLocalStorage(stream, file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromDigestCache(String url, String digest) {
        log.debug("Removing {} / {} from digest cache", (Object)url, (Object)digest);
        Map<String, CacheEntry> map = this.digestCache;
        synchronized (map) {
            CacheEntry entry = this.digestCache.get(url);
            if (entry != null && entry.digest.equals(digest)) {
                this.digestCache.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeDigest(File data) throws IOException {
        String string;
        FileInputStream is = new FileInputStream(data);
        try {
            MessageDigest d = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            int count = 0;
            while ((count = ((InputStream)is).read(buffer, 0, buffer.length)) > 0) {
                d.update(buffer, 0, count);
            }
            String result = FileDataStore.digestToString(d);
            log.debug("Digest of {} is {}", (Object)FileDataStore.safePath(data), (Object)result);
            string = result;
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception ignore) {
                String result = data.toString();
                log.debug("Returning fake digest {} for {} due to {}", new Object[]{result, FileDataStore.safePath(data), ignore});
                return result;
            }
        }
        ((InputStream)is).close();
        return string;
    }

    private static String digestToString(MessageDigest d) {
        BigInteger bigInt = new BigInteger(1, d.digest());
        return new String(bigInt.toString(16));
    }

    public static String computeDigest(Dictionary<String, Object> data) {
        try {
            MessageDigest d = MessageDigest.getInstance("MD5");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            TreeSet<String> sortedKeys = new TreeSet<String>();
            if (data != null) {
                Enumeration<String> e = data.keys();
                while (e.hasMoreElements()) {
                    String key = e.nextElement();
                    sortedKeys.add(key);
                }
            }
            for (String key : sortedKeys) {
                oos.writeObject(key);
                FileDataStore.writeValue(data.get(key), oos);
            }
            oos.flush();
            d.update(bos.toByteArray());
            String result = FileDataStore.digestToString(d);
            log.debug("Dictionary digest = {}", (Object)result);
            return result;
        }
        catch (Exception ignore) {
            String result = data.toString();
            log.debug("Returning fake dictionary digest {} due to {}", (Object)result, (Object)ignore);
            return result;
        }
    }

    private static void writeValue(Object val, ObjectOutputStream oos) throws IOException {
        if (val instanceof Number) {
            FileDataStore.writeValue(String.valueOf(val), oos);
        } else if (val instanceof Collection) {
            for (Object o : (Collection)val) {
                FileDataStore.writeValue(o, oos);
            }
        } else if (val instanceof String) {
            oos.writeUTF((String)val);
        } else {
            oos.writeObject(val);
        }
    }

    private static final String safePath(File f) {
        return f == null ? null : f.getAbsolutePath();
    }

    static {
        serialNumberCounter = System.currentTimeMillis();
    }

    private static final class CacheEntry {
        public final File file;
        public final String digest;

        public CacheEntry(File file, String digest) {
            this.file = file;
            this.digest = digest;
        }
    }
}

