/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.sling.commons.threads.impl.ThreadLocalChangeListener;
import org.apache.sling.commons.threads.impl.ThreadLocalCleaner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolExecutorCleaningThreadLocals
extends ThreadPoolExecutor {
    private final ThreadLocalChangeListener listener;
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConcurrentMap<Thread, ThreadLocalCleaner> cleaners = new ConcurrentHashMap<Thread, ThreadLocalCleaner>();

    public ThreadPoolExecutorCleaningThreadLocals(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler, ThreadLocalChangeListener listener) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.listener = listener;
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        LOGGER.debug("Collecting changes to ThreadLocal for thread {} from now on...", (Object)t);
        try {
            ThreadLocalCleaner cleaner = new ThreadLocalCleaner(this.listener);
            this.cleaners.put(t, cleaner);
        }
        catch (Error | RuntimeException e) {
            LOGGER.warn("Could not set up thread local cleaner (most probably not a compliant JRE): {}", (Object)e, (Object)e);
            throw e;
        }
        super.beforeExecute(t, r);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        LOGGER.debug("Cleaning up thread locals for thread {}...", (Object)Thread.currentThread());
        ThreadLocalCleaner cleaner = (ThreadLocalCleaner)this.cleaners.remove(Thread.currentThread());
        if (cleaner != null) {
            cleaner.cleanup();
        } else {
            LOGGER.warn("Could not clean up thread locals in thread {} as the cleaner was not set up correctly", (Object)Thread.currentThread());
        }
    }
}

