/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.ProtocolException;
import org.apache.commons.httpclient.Wire;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpParser {
    private static final Log LOG = LogFactory.getLog(HttpParser.class);
    private static int MAX_HEADER_COUNT = Integer.getInteger("http.connection.max-header-count", -1);
    private static int MAX_LINE_LENGTH = Integer.getInteger("http.connection.max-line-length", -1);

    private HttpParser() {
    }

    public static byte[] readRawLine(InputStream inputStream) throws IOException {
        return HttpParser.readRawLine(inputStream, MAX_LINE_LENGTH);
    }

    public static byte[] readRawLine(InputStream inputStream, int maxLineLength) throws IOException {
        int ch;
        LOG.trace((Object)"enter HttpParser.readRawLine()");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int count = 0;
        while ((ch = inputStream.read()) >= 0) {
            if (maxLineLength > 0 && count >= maxLineLength) {
                throw new IOException("Maximum line length limit [" + maxLineLength + "] exceeded");
            }
            buf.write(ch);
            if (ch == 10) break;
            ++count;
        }
        if (buf.size() == 0) {
            return null;
        }
        return buf.toByteArray();
    }

    public static String readLine(InputStream inputStream, String charset) throws IOException {
        return HttpParser.readLine(inputStream, charset, MAX_LINE_LENGTH);
    }

    public static String readLine(InputStream inputStream, String charset, int maxLineLength) throws IOException {
        LOG.trace((Object)"enter HttpParser.readLine(InputStream, String)");
        byte[] rawdata = HttpParser.readRawLine(inputStream, maxLineLength);
        if (rawdata == null) {
            return null;
        }
        int len = rawdata.length;
        int offset = 0;
        if (len > 0 && rawdata[len - 1] == 10) {
            ++offset;
            if (len > 1 && rawdata[len - 2] == 13) {
                ++offset;
            }
        }
        String result = EncodingUtil.getString(rawdata, 0, len - offset, charset);
        if (Wire.HEADER_WIRE.enabled()) {
            String logoutput = result;
            if (offset == 2) {
                logoutput = result + "\r\n";
            } else if (offset == 1) {
                logoutput = result + "\n";
            }
            Wire.HEADER_WIRE.input(logoutput);
        }
        return result;
    }

    public static String readLine(InputStream inputStream) throws IOException {
        LOG.trace((Object)"enter HttpParser.readLine(InputStream)");
        return HttpParser.readLine(inputStream, "US-ASCII", MAX_LINE_LENGTH);
    }

    public static Header[] parseHeaders(InputStream is, String charset) throws IOException, HttpException {
        LOG.trace((Object)"enter HeaderParser.parseHeaders(InputStream, String)");
        return HttpParser.parseHeaders(is, charset, MAX_HEADER_COUNT, MAX_LINE_LENGTH);
    }

    public static Header[] parseHeaders(InputStream is, String charset, int maxHeaderCount, int maxLineLength) throws IOException, HttpException {
        String line;
        LOG.trace((Object)"enter HeaderParser.parseHeaders(InputStream, String, maxHeaderCount, maxLineLen)");
        ArrayList<Header> headers = new ArrayList<Header>();
        String name = null;
        StringBuffer value = null;
        while ((line = HttpParser.readLine(is, charset, maxLineLength)) != null && line.trim().length() >= 1) {
            if (line.charAt(0) == ' ' || line.charAt(0) == '\t') {
                if (value == null) continue;
                value.append(' ');
                value.append(line.trim());
                continue;
            }
            if (name != null) {
                headers.add(new Header(name, value.toString()));
            }
            if (maxHeaderCount > 0 && headers.size() > maxHeaderCount) {
                throw new IOException("Maximum header count  [" + maxHeaderCount + "]  exceeded");
            }
            int colon = line.indexOf(":");
            if (colon < 0) {
                throw new ProtocolException("Unable to parse header: " + line);
            }
            name = line.substring(0, colon).trim();
            value = new StringBuffer(line.substring(colon + 1).trim());
        }
        if (name != null) {
            headers.add(new Header(name, value.toString()));
        }
        if (maxHeaderCount > 0 && headers.size() > maxHeaderCount) {
            throw new IOException("Maximum header count  [" + maxHeaderCount + "]  exceeded");
        }
        return headers.toArray(new Header[headers.size()]);
    }

    public static Header[] parseHeaders(InputStream is) throws IOException, HttpException {
        LOG.trace((Object)"enter HeaderParser.parseHeaders(InputStream, String)");
        return HttpParser.parseHeaders(is, "US-ASCII", MAX_HEADER_COUNT, MAX_LINE_LENGTH);
    }
}

