/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.form.impl.jaas;

import java.util.Collections;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.security.auth.login.LoginException;
import org.apache.jackrabbit.oak.spi.security.authentication.AbstractLoginModule;
import org.apache.jackrabbit.oak.spi.security.authentication.PreAuthenticatedLogin;
import org.apache.sling.auth.form.impl.FormAuthenticationHandler;
import org.apache.sling.auth.form.impl.jaas.FormCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FormLoginModule
extends AbstractLoginModule {
    private static final Logger log = LoggerFactory.getLogger(FormLoginModule.class);
    private static final Set<Class> SUPPORTED_CREDENTIALS = Collections.singleton(FormCredentials.class);
    private static final char[] EMPTY_PWD = new char[0];
    private String userId;
    private final FormAuthenticationHandler authHandler;

    protected Set<Class> getSupportedCredentials() {
        return SUPPORTED_CREDENTIALS;
    }

    FormLoginModule(FormAuthenticationHandler authHandler) {
        this.authHandler = authHandler;
    }

    public boolean login() throws LoginException {
        Credentials credentials = this.getCredentials();
        if (credentials instanceof FormCredentials) {
            FormCredentials cred = (FormCredentials)credentials;
            this.userId = cred.getUserId();
            if (!this.authHandler.isValid(cred)) {
                log.debug("Invalid credentials");
                return false;
            }
            if (this.userId == null) {
                log.debug("Could not extract userId/credentials");
            } else {
                this.sharedState.put(SHARED_KEY_PRE_AUTH_LOGIN, new PreAuthenticatedLogin(this.userId));
                this.sharedState.put("org.apache.jackrabbit.credentials", new SimpleCredentials(this.userId, EMPTY_PWD));
                this.sharedState.put("javax.security.auth.login.name", this.userId);
                log.debug("login succeeded with trusted user: {}", (Object)this.userId);
            }
        }
        return false;
    }

    public boolean commit() throws LoginException {
        if (this.userId == null) {
            this.clearState();
        }
        return false;
    }

    protected void clearState() {
        this.userId = null;
        super.clearState();
    }
}

