/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.queues;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.impl.jobs.JobConsumerManager;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.JobTopicTraverser;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.stats.StatisticsManager;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.QueueConfiguration;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueJobCache {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int maxPreloadLimit = 10;
    private final JobManagerConfiguration configuration;
    private final Set<String> topics;
    private final Set<String> topicsWithNewJobs = new HashSet<String>();
    private final List<JobImpl> cache = new ArrayList<JobImpl>();
    private final QueueConfiguration.Type queueType;
    private final AtomicBoolean queueIsBlocked = new AtomicBoolean(false);

    public QueueJobCache(JobManagerConfiguration configuration, String queueName, StatisticsManager statisticsManager, QueueConfiguration.Type queueType, Set<String> topics) {
        this.configuration = configuration;
        this.queueType = queueType;
        this.topics = new ConcurrentSkipListSet<String>(topics);
        this.fillCache(queueName, statisticsManager);
    }

    public Set<String> getTopics() {
        return this.topics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        boolean result = true;
        Collection<Object> collection = this.cache;
        synchronized (collection) {
            result = this.cache.isEmpty();
        }
        if (result) {
            collection = this.topicsWithNewJobs;
            synchronized (collection) {
                result = this.topicsWithNewJobs.isEmpty();
            }
        }
        return result;
    }

    public void setIsBlocked(boolean value) {
        this.queueIsBlocked.set(value);
    }

    private void fillCache(String queueName, StatisticsManager statisticsManager) {
        HashSet<String> checkingTopics = new HashSet<String>();
        checkingTopics.addAll(this.topics);
        if (!checkingTopics.isEmpty()) {
            this.loadJobs(queueName, checkingTopics, statisticsManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobHandler getNextJob(JobConsumerManager jobConsumerManager, StatisticsManager statisticsManager, Queue queue, boolean doFull) {
        JobHandler handler = null;
        if (!this.queueIsBlocked.get()) {
            List<JobImpl> list = this.cache;
            synchronized (list) {
                boolean retry;
                do {
                    retry = false;
                    if (this.cache.isEmpty()) {
                        HashSet<String> checkingTopics = new HashSet<String>();
                        Set<String> set = this.topicsWithNewJobs;
                        synchronized (set) {
                            checkingTopics.addAll(this.topicsWithNewJobs);
                            this.topicsWithNewJobs.clear();
                        }
                        if (doFull) {
                            checkingTopics.addAll(this.topics);
                        }
                        if (!checkingTopics.isEmpty()) {
                            this.loadJobs(queue.getName(), checkingTopics, statisticsManager);
                        }
                    }
                    if (this.cache.isEmpty()) continue;
                    JobImpl job = this.cache.remove(0);
                    JobExecutor consumer = jobConsumerManager.getExecutor(job.getTopic());
                    handler = new JobHandler(job, consumer, this.configuration);
                    if (consumer != null) {
                        if (handler.startProcessing(queue)) continue;
                        statisticsManager.jobDequeued(queue.getName(), handler.getJob().getTopic());
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Discarding removed job {}", (Object)Utility.toString(job));
                        }
                        handler = null;
                        retry = true;
                        continue;
                    }
                    statisticsManager.jobDequeued(queue.getName(), handler.getJob().getTopic());
                    handler.reassign();
                    handler = null;
                    retry = true;
                } while (handler == null && retry);
            }
        }
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJobs(String queueName, Set<String> checkingTopics, StatisticsManager statisticsManager) {
        this.logger.debug("Starting jobs loading from {}...", checkingTopics);
        HashMap<String, List<JobImpl>> topicCache = new HashMap<String, List<JobImpl>>();
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            Resource baseResource = resolver.getResource(this.configuration.getLocalJobsPath());
            if (baseResource != null) {
                for (String topic : checkingTopics) {
                    Resource topicResource = baseResource.getChild(topic.replace('/', '.'));
                    if (topicResource == null) continue;
                    topicCache.put(topic, this.loadJobs(queueName, topic, topicResource, statisticsManager));
                }
            }
        }
        this.orderTopics(topicCache);
        this.logger.debug("Finished jobs loading {}", (Object)this.cache.size());
    }

    private void orderTopics(Map<String, List<JobImpl>> topicCache) {
        if (this.queueType == QueueConfiguration.Type.ORDERED || this.queueType == QueueConfiguration.Type.UNORDERED) {
            for (List<JobImpl> list : topicCache.values()) {
                this.cache.addAll(list);
            }
            Collections.sort(this.cache);
        } else {
            boolean done = true;
            do {
                done = true;
                for (Map.Entry<String, List<JobImpl>> entry : topicCache.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    this.cache.add(entry.getValue().remove(0));
                    if (entry.getValue().isEmpty()) continue;
                    done = false;
                }
            } while (!done);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<JobImpl> loadJobs(final String queueName, final String topic, Resource topicResource, final StatisticsManager statisticsManager) {
        this.logger.debug("Loading jobs from topic {}", (Object)topic);
        final ArrayList<JobImpl> list = new ArrayList<JobImpl>();
        final AtomicBoolean scanTopic = new AtomicBoolean(false);
        JobTopicTraverser.traverse(this.logger, topicResource, new JobTopicTraverser.JobCallback(){

            @Override
            public boolean handle(JobImpl job) {
                if (job.getProcessingStarted() == null && !job.hasReadErrors()) {
                    list.add(job);
                    statisticsManager.jobQueued(queueName, topic);
                    if (list.size() == 10) {
                        scanTopic.set(true);
                    }
                } else if (job.getProcessingStarted() != null) {
                    QueueJobCache.this.logger.debug("Ignoring job {} - processing already started.", (Object)job);
                } else {
                    scanTopic.set(true);
                    if (job.isReadErrorRecoverable()) {
                        QueueJobCache.this.logger.debug("Ignoring job {} due to recoverable read errors.", (Object)job);
                    } else {
                        QueueJobCache.this.logger.debug("Failing job {} due to unrecoverable read errors.", (Object)job);
                        JobHandler handler = new JobHandler(job, null, QueueJobCache.this.configuration);
                        handler.finished(Job.JobState.ERROR, true, null);
                    }
                }
                return list.size() < 10;
            }
        });
        if (scanTopic.get()) {
            Set<String> set = this.topicsWithNewJobs;
            synchronized (set) {
                this.topicsWithNewJobs.add(topic);
            }
        }
        this.logger.debug("Caching {} jobs for topic {}", (Object)list.size(), (Object)topic);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewTopics(Set<String> topics) {
        this.logger.debug("Update cache to handle new event for topics {}", topics);
        Set<String> set = this.topicsWithNewJobs;
        synchronized (set) {
            this.topicsWithNewJobs.addAll(topics);
        }
        this.topics.addAll(topics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reschedule(String queueName, JobHandler handler, StatisticsManager statisticsManager) {
        List<JobImpl> list = this.cache;
        synchronized (list) {
            if (handler.reschedule()) {
                if (this.queueType == QueueConfiguration.Type.ORDERED) {
                    this.cache.add(0, handler.getJob());
                } else {
                    this.cache.add(handler.getJob());
                }
                statisticsManager.jobQueued(queueName, handler.getJob().getTopic());
            }
        }
    }
}

