/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.jobs.Job;
import org.osgi.service.event.Event;
import org.slf4j.Logger;

public abstract class Utility {
    private static final Comparator<Resource> RESOURCE_COMPARATOR = new Comparator<Resource>(){

        @Override
        public int compare(Resource o1, Resource o2) {
            Integer value1 = null;
            try {
                value1 = Integer.valueOf(o1.getName());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Integer value2 = null;
            try {
                value2 = Integer.valueOf(o2.getName());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value1 != null && value2 != null) {
                return value1.compareTo(value2);
            }
            return o1.getName().compareTo(o2.getName());
        }
    };

    public static String checkJobTopic(Object jobTopic) {
        String message = null;
        if (jobTopic != null) {
            if (jobTopic instanceof String) {
                try {
                    new Event((String)jobTopic, (Dictionary)null);
                }
                catch (IllegalArgumentException iae) {
                    message = String.format("Discarding job - job has an illegal job topic '%s'", jobTopic);
                }
            } else {
                message = "Discarding job - job topic is not of type string";
            }
        } else {
            message = "Discarding job - job topic is missing";
        }
        return message;
    }

    public static String checkJob(Object jobTopic, Map<String, Object> properties) {
        String msg = Utility.checkJobTopic(jobTopic);
        if (msg == null && properties != null) {
            for (Object val : properties.values()) {
                if (val == null || val instanceof Serializable) continue;
                return "Discarding job - properties must be serializable: " + jobTopic + " : " + properties;
            }
        }
        return msg;
    }

    public static Event toEvent(Job job) {
        HashMap<String, Object> eventProps = new HashMap<String, Object>();
        eventProps.putAll(((JobImpl)job).getProperties());
        eventProps.put("slingevent:eventId", job.getId());
        eventProps.remove(":sling:jobs:asynchandler");
        return new Event(job.getTopic(), eventProps);
    }

    private static void appendProperties(StringBuilder sb, Map<String, Object> properties) {
        if (properties != null) {
            sb.append(", properties=");
            boolean first = true;
            for (String propName : properties.keySet()) {
                if (propName.equals("slingevent:eventId") || propName.equals("event.job.topic")) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                sb.append(propName);
                sb.append('=');
                Object value = properties.get(propName);
                if (value instanceof Calendar) {
                    sb.append(value.getClass().getName());
                    sb.append('(');
                    sb.append(((Calendar)value).getTime());
                    sb.append(')');
                    continue;
                }
                sb.append(value);
            }
        }
    }

    public static String toString(String jobTopic, Map<String, Object> properties) {
        StringBuilder sb = new StringBuilder("Sling Job ");
        sb.append("[topic=");
        sb.append(jobTopic);
        Utility.appendProperties(sb, properties);
        sb.append("]");
        return sb.toString();
    }

    public static String toString(Job job) {
        if (job != null) {
            StringBuilder sb = new StringBuilder("Sling Job ");
            sb.append("[topic=");
            sb.append(job.getTopic());
            sb.append(", id=");
            sb.append(job.getId());
            Utility.appendProperties(sb, ((JobImpl)job).getProperties());
            sb.append("]");
            return sb.toString();
        }
        return "<null>";
    }

    public static JobImpl readJob(Logger logger, Resource resource) {
        JobImpl job = null;
        if (resource != null) {
            try {
                ValueMap vm = ResourceHelper.getValueMap(resource);
                String errorMessage = Utility.checkJobTopic(vm.get((Object)"event.job.topic"));
                String jobId = (String)vm.get("slingevent:eventId", String.class);
                if (errorMessage == null && jobId != null) {
                    List readErrorList;
                    String topic = (String)vm.get("event.job.topic", String.class);
                    Map<String, Object> jobProperties = ResourceHelper.cloneValueMap(vm);
                    jobProperties.put("slingevent:path", resource.getPath());
                    jobProperties.put("event.job.retries", vm.get("event.job.retries", Integer.class));
                    jobProperties.put("event.job.retrycount", vm.get("event.job.retrycount", Integer.class));
                    if (vm.get((Object)"slingevent:progressSteps") != null) {
                        jobProperties.put("slingevent:progressSteps", vm.get("slingevent:progressSteps", Integer.class));
                    }
                    if (vm.get((Object)"slingevent:progressStep") != null) {
                        jobProperties.put("slingevent:progressStep", vm.get("slingevent:progressStep", Integer.class));
                    }
                    if ((readErrorList = (List)jobProperties.get(ResourceHelper.PROPERTY_MARKER_READ_ERROR_LIST)) != null) {
                        for (Exception e : readErrorList) {
                            logger.warn("Unable to read job from " + resource.getPath(), (Throwable)e);
                        }
                    }
                    job = new JobImpl(topic, jobId, jobProperties);
                } else {
                    if (errorMessage != null) {
                        logger.warn("{} : {}", (Object)errorMessage, (Object)resource.getPath());
                    } else if (jobId == null) {
                        logger.warn("Discarding job - no job id found : {}", (Object)resource.getPath());
                    }
                    try {
                        resource.getResourceResolver().delete(resource);
                        resource.getResourceResolver().commit();
                    }
                    catch (PersistenceException ignore) {
                        logger.debug("Unable to remove job resource.", (Throwable)ignore);
                    }
                }
            }
            catch (InstantiationException ie) {
                logger.debug("Unable to instantiate resource.", (Throwable)ie);
            }
            catch (RuntimeException re) {
                logger.debug("Unable to read resource.", (Throwable)re);
            }
        }
        return job;
    }

    public static List<Resource> getSortedChildren(Logger logger, String type, Resource rsrc) {
        ArrayList<Resource> children = new ArrayList<Resource>();
        Iterator monthIter = rsrc.listChildren();
        while (monthIter.hasNext()) {
            Resource monthResource = (Resource)monthIter.next();
            children.add(monthResource);
            logger.debug("Found {} : {}", (Object)type, (Object)monthResource.getName());
        }
        Collections.sort(children, RESOURCE_COMPARATOR);
        return children;
    }
}

