/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.apache.sling.event.impl.jobs.JobBuilderImpl;
import org.apache.sling.event.impl.jobs.JobConsumerManager;
import org.apache.sling.event.impl.jobs.JobHandler;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.Utility;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.config.QueueConfigurationManager;
import org.apache.sling.event.impl.jobs.config.TopologyCapabilities;
import org.apache.sling.event.impl.jobs.notifications.NotificationUtility;
import org.apache.sling.event.impl.jobs.queues.JobQueueImpl;
import org.apache.sling.event.impl.jobs.queues.QueueManager;
import org.apache.sling.event.impl.jobs.scheduling.JobSchedulerImpl;
import org.apache.sling.event.impl.jobs.stats.StatisticsManager;
import org.apache.sling.event.impl.jobs.tasks.CleanUpTask;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.JobManager;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.apache.sling.event.jobs.Statistics;
import org.apache.sling.event.jobs.TopicStatistics;
import org.apache.sling.event.jobs.jmx.QueuesMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={JobManager.class, EventHandler.class, Runnable.class}, property={"service.vendor=The Apache Software Foundation", "scheduler.period:Long=60", "scheduler.concurrent:Boolean=false", "event.topics=org/osgi/framework/BundleEvent/STARTED", "event.topics=org/osgi/framework/BundleEvent/UPDATED"})
public class JobManagerImpl
implements JobManager,
EventHandler,
Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private EventAdmin eventAdmin;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private Scheduler scheduler;
    @Reference
    private JobConsumerManager jobConsumerManager;
    @Reference
    private QueuesMBean queuesMBean;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ThreadPoolManager threadPoolManager;
    @Reference
    private JobManagerConfiguration configuration;
    @Reference
    private StatisticsManager statisticsManager;
    @Reference
    private QueueManager qManager;
    private volatile CleanUpTask maintenanceTask;
    private JobSchedulerImpl jobScheduler;
    private volatile ServiceRegistration<ResourceChangeListener> changeListenerReg;

    @Activate
    protected void activate(BundleContext ctx, Map<String, Object> props) throws LoginException {
        this.jobScheduler = new JobSchedulerImpl(this.configuration, this.scheduler, this);
        this.maintenanceTask = new CleanUpTask(this.configuration, this.jobScheduler);
        Hashtable<String, Object> regProps = new Hashtable<String, Object>();
        ((Dictionary)regProps).put("resource.paths", this.configuration.getScheduledJobsPath(false));
        ((Dictionary)regProps).put("resource.change.types", new String[]{ResourceChange.ChangeType.ADDED.name(), ResourceChange.ChangeType.CHANGED.name(), ResourceChange.ChangeType.REMOVED.name()});
        ((Dictionary)regProps).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)regProps).put("service.description", "Resource change listener for scheduled jobs");
        this.changeListenerReg = ctx.registerService(ResourceChangeListener.class, (Object)this.jobScheduler, regProps);
        this.logger.info("Apache Sling Job Manager started on instance {}", (Object)Environment.APPLICATION_ID);
    }

    @Deactivate
    protected void deactivate() {
        this.logger.debug("Apache Sling Job Manager stopping on instance {}", (Object)Environment.APPLICATION_ID);
        if (this.changeListenerReg != null) {
            this.changeListenerReg.unregister();
            this.changeListenerReg = null;
        }
        this.jobScheduler.deactivate();
        this.maintenanceTask = null;
        this.logger.info("Apache Sling Job Manager stopped on instance {}", (Object)Environment.APPLICATION_ID);
    }

    @Override
    public void run() {
        CleanUpTask task = this.maintenanceTask;
        if (task != null) {
            task.run();
        }
    }

    public void handleEvent(Event event) {
        this.jobScheduler.handleEvent(event);
    }

    @Override
    public synchronized Statistics getStatistics() {
        return this.statisticsManager.getGlobalStatistics();
    }

    @Override
    public Iterable<TopicStatistics> getTopicStatistics() {
        return this.statisticsManager.getTopicStatistics().values();
    }

    @Override
    public Queue getQueue(String name) {
        return this.qManager.getQueue(ResourceHelper.filterQueueName(name));
    }

    @Override
    public Iterable<Queue> getQueues() {
        return this.qManager.getQueues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalRemoveJobById(String jobId, boolean forceRemove) {
        this.logger.debug("Trying to remove job {}", (Object)jobId);
        boolean result = true;
        JobImpl job = (JobImpl)this.getJobById(jobId);
        if (job != null) {
            JobImpl retryJob;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Found removal job: {}", (Object)Utility.toString(job));
            }
            if ((retryJob = (JobImpl)this.configuration.getJobFromRetryList(jobId)) != null) {
                job = retryJob;
            }
            if (!forceRemove && job.getProcessingStarted() != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Unable to remove job - job is started: {}", (Object)Utility.toString(job));
                }
                result = false;
            } else {
                boolean isHistoryJob = this.configuration.isStoragePath(job.getResourcePath());
                if (isHistoryJob) {
                    try (ResourceResolver resolver = this.configuration.createResourceResolver();){
                        Resource jobResource = resolver.getResource(job.getResourcePath());
                        if (jobResource != null) {
                            resolver.delete(jobResource);
                            resolver.commit();
                            this.logger.debug("Removed job with id: {}", (Object)jobId);
                        } else {
                            this.logger.debug("Unable to remove job with id - resource already removed: {}", (Object)jobId);
                        }
                        NotificationUtility.sendNotification(this.eventAdmin, "org/apache/sling/event/notification/job/REMOVED", job, null);
                    }
                } else {
                    JobHandler jh = new JobHandler(job, null, this.configuration);
                    jh.finished(Job.JobState.DROPPED, true, null);
                }
                this.configuration.getAuditLogger().debug("REMOVE OK : {}", (Object)jobId);
            }
        } else {
            this.logger.debug("Job for removal does not exist (anymore): {}", (Object)jobId);
        }
        return result;
    }

    @Override
    public Job addJob(String topic, Map<String, Object> properties) {
        return this.addJob(topic, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Job getJobById(String id) {
        this.logger.debug("Getting job by id: {}", (Object)id);
        StringBuilder buf = new StringBuilder(64);
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            buf.append("/jcr:root");
            buf.append(this.configuration.getJobsBasePathWithSlash());
            buf.append("/element(*,");
            buf.append("slingevent:Job");
            buf.append(")[@");
            buf.append("slingevent:eventId");
            buf.append(" = '");
            buf.append(id);
            buf.append("']");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Exceuting query: {}", (Object)buf.toString());
            }
            Iterator result = resolver.findResources(buf.toString(), "xpath");
            while (result.hasNext()) {
                JobImpl job;
                Resource jobResource = (Resource)result.next();
                if (!this.configuration.isJob(jobResource.getPath()) || (job = Utility.readJob(this.logger, jobResource)) == null) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Found job with id {} = {}", (Object)id, (Object)Utility.toString(job));
                }
                JobImpl jobImpl = job;
                return jobImpl;
            }
        }
        this.logger.debug("Job not found with id: {}", (Object)id);
        return null;
    }

    @Override
    public Job getJob(String topic, Map<String, Object> template) {
        Collection<Job> iter = template == null ? this.findJobs(JobManager.QueryType.ALL, topic, 1L, null) : this.findJobs(JobManager.QueryType.ALL, topic, 1L, template);
        Iterator i = iter.iterator();
        if (i.hasNext()) {
            return (Job)i.next();
        }
        return null;
    }

    @Override
    public boolean removeJobById(String jobId) {
        return this.internalRemoveJobById(jobId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Job> findJobs(JobManager.QueryType type, String topic, long limit, Map<String, Object> ... templates) {
        boolean isHistoryQuery = type == JobManager.QueryType.HISTORY || type == JobManager.QueryType.SUCCEEDED || type == JobManager.QueryType.CANCELLED || type == JobManager.QueryType.DROPPED || type == JobManager.QueryType.ERROR || type == JobManager.QueryType.GIVEN_UP || type == JobManager.QueryType.STOPPED;
        ArrayList<Job> result = new ArrayList<Job>();
        StringBuilder buf = new StringBuilder(64);
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            buf.append("/jcr:root");
            buf.append(this.configuration.getJobsBasePathWithSlash());
            buf.append("/element(*,");
            buf.append("slingevent:Job");
            buf.append(")[@");
            buf.append(ISO9075.encode("event.job.topic"));
            if (topic != null) {
                buf.append(" = '");
                buf.append(topic);
                buf.append("'");
            }
            if (isHistoryQuery) {
                buf.append(" and @");
                buf.append(ISO9075.encode("slingevent:finishedState"));
                if (type == JobManager.QueryType.SUCCEEDED || type == JobManager.QueryType.DROPPED || type == JobManager.QueryType.ERROR || type == JobManager.QueryType.GIVEN_UP || type == JobManager.QueryType.STOPPED) {
                    buf.append(" = '");
                    buf.append(type.name());
                    buf.append("'");
                } else if (type == JobManager.QueryType.CANCELLED) {
                    buf.append(" and (@");
                    buf.append(ISO9075.encode("slingevent:finishedState"));
                    buf.append(" = '");
                    buf.append(JobManager.QueryType.DROPPED.name());
                    buf.append("' or @");
                    buf.append(ISO9075.encode("slingevent:finishedState"));
                    buf.append(" = '");
                    buf.append(JobManager.QueryType.ERROR.name());
                    buf.append("' or @");
                    buf.append(ISO9075.encode("slingevent:finishedState"));
                    buf.append(" = '");
                    buf.append(JobManager.QueryType.GIVEN_UP.name());
                    buf.append("' or @");
                    buf.append(ISO9075.encode("slingevent:finishedState"));
                    buf.append(" = '");
                    buf.append(JobManager.QueryType.STOPPED.name());
                    buf.append("')");
                }
            } else {
                buf.append(" and not(@");
                buf.append(ISO9075.encode("slingevent:finishedState"));
                buf.append(")");
                if (type == JobManager.QueryType.ACTIVE) {
                    buf.append(" and @");
                    buf.append(ISO9075.encode("event.job.started.time"));
                } else if (type == JobManager.QueryType.QUEUED) {
                    buf.append(" and not(@");
                    buf.append(ISO9075.encode("event.job.started.time"));
                    buf.append(")");
                }
            }
            if (templates != null && templates.length > 0) {
                int index = 0;
                for (Map<String, Object> template : templates) {
                    if (template.size() == 0) continue;
                    if (index == 0) {
                        buf.append(" and (");
                    } else {
                        buf.append(" or ");
                    }
                    buf.append('(');
                    Iterator<Map.Entry<String, Object>> i = template.entrySet().iterator();
                    boolean first = true;
                    while (i.hasNext()) {
                        char secondChar;
                        Operation op;
                        String propName;
                        char firstChar;
                        Map.Entry<String, Object> current = i.next();
                        String key = ISO9075.encode(current.getKey());
                        char c = firstChar = key.length() > 0 ? key.charAt(0) : (char)'\u0000';
                        if (firstChar == '=') {
                            propName = key.substring(1);
                            op = Operation.EQUALS;
                        } else if (firstChar == '<') {
                            char c2 = secondChar = key.length() > 1 ? key.charAt(1) : (char)'\u0000';
                            if (secondChar == '=') {
                                op = Operation.LESS_OR_EQUALS;
                                propName = key.substring(2);
                            } else {
                                op = Operation.LESS;
                                propName = key.substring(1);
                            }
                        } else if (firstChar == '>') {
                            char c3 = secondChar = key.length() > 1 ? key.charAt(1) : (char)'\u0000';
                            if (secondChar == '=') {
                                op = Operation.GREATER_OR_EQUALS;
                                propName = key.substring(2);
                            } else {
                                op = Operation.GREATER;
                                propName = key.substring(1);
                            }
                        } else {
                            propName = key;
                            op = Operation.EQUALS;
                        }
                        if (first) {
                            first = false;
                            buf.append('@');
                        } else {
                            buf.append(" and @");
                        }
                        buf.append(propName);
                        buf.append(' ');
                        switch (op) {
                            case EQUALS: {
                                buf.append('=');
                                break;
                            }
                            case LESS: {
                                buf.append('<');
                                break;
                            }
                            case LESS_OR_EQUALS: {
                                buf.append("<=");
                                break;
                            }
                            case GREATER: {
                                buf.append('>');
                                break;
                            }
                            case GREATER_OR_EQUALS: {
                                buf.append(">=");
                            }
                        }
                        buf.append(" '");
                        buf.append(current.getValue());
                        buf.append("'");
                    }
                    buf.append(')');
                    ++index;
                }
                if (index > 0) {
                    buf.append(')');
                }
            }
            buf.append("] order by @");
            if (isHistoryQuery) {
                buf.append("slingevent:finishedDate");
                buf.append(" descending");
            } else {
                buf.append("slingevent:created");
                buf.append(" ascending");
            }
            Iterator iter = resolver.findResources(buf.toString(), "xpath");
            long count = 0L;
            while (iter.hasNext() && (limit < 1L || count < limit)) {
                JobImpl job;
                Resource jobResource = (Resource)iter.next();
                if (!this.configuration.isJob(jobResource.getPath()) || (job = Utility.readJob(this.logger, jobResource)) == null) continue;
                ++count;
                result.add(job);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job addJobInternal(String jobTopic, Map<String, Object> jobProperties, List<String> errors) {
        QueueConfigurationManager.QueueInfo info = this.configuration.getQueueConfigurationManager().getQueueInfo(jobTopic);
        TopologyCapabilities caps = this.configuration.getTopologyCapabilities();
        String string = info.targetId = caps == null ? null : caps.detectTarget(jobTopic, jobProperties, info);
        if (this.logger.isDebugEnabled()) {
            if (info.targetId != null) {
                this.logger.debug("Persisting job {} into queue {}, target={}", new Object[]{Utility.toString(jobTopic, jobProperties), info.queueName, info.targetId});
            } else {
                this.logger.debug("Persisting job {} into queue {}", (Object)Utility.toString(jobTopic, jobProperties), (Object)info.queueName);
            }
        }
        try (ResourceResolver resolver = this.configuration.createResourceResolver();){
            JobImpl job = this.writeJob(resolver, jobTopic, jobProperties, info);
            if (info.targetId != null) {
                this.configuration.getAuditLogger().debug("ASSIGN OK {} : {}", (Object)info.targetId, (Object)job.getId());
            } else {
                this.configuration.getAuditLogger().debug("UNASSIGN OK : {}", (Object)job.getId());
            }
            JobImpl jobImpl = job;
            return jobImpl;
        }
        if (errors != null) {
            errors.add("Unable to persist new job.");
        }
        return null;
    }

    private JobImpl writeJob(ResourceResolver resolver, String jobTopic, Map<String, Object> jobProperties, QueueConfigurationManager.QueueInfo info) throws PersistenceException {
        String jobId = this.configuration.getUniqueId(jobTopic);
        String path = this.configuration.getUniquePath(info.targetId, jobTopic, jobId, jobProperties);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (jobProperties != null) {
            for (Map.Entry<String, Object> entry : jobProperties.entrySet()) {
                String propName = entry.getKey();
                if (ResourceHelper.ignoreProperty(propName)) continue;
                properties.put(propName, entry.getValue());
            }
        }
        properties.put("slingevent:eventId", jobId);
        properties.put("event.job.topic", jobTopic);
        properties.put("event.job.queuename", info.queueConfiguration.getName());
        properties.put("event.job.retrycount", 0);
        properties.put("event.job.retries", info.queueConfiguration.getMaxRetries());
        properties.put("slingevent:created", Calendar.getInstance());
        properties.put("event.job.queued.time", Calendar.getInstance());
        properties.put("slingevent:application", Environment.APPLICATION_ID);
        if (info.targetId != null) {
            properties.put("event.job.application", info.targetId);
        } else {
            properties.remove("event.job.application");
        }
        properties.put("sling:resourceType", "slingevent:Job");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Storing new job {} at {}", (Object)Utility.toString(jobTopic, properties), (Object)path);
        }
        ResourceHelper.createAndCommitResource(resolver, path, properties);
        properties.put("slingevent:path", path);
        return new JobImpl(jobTopic, jobId, properties);
    }

    @Override
    public void stopJobById(String jobId) {
        this.stopJobById(jobId, true);
    }

    private void stopJobById(String jobId, boolean forward) {
        JobImpl job = (JobImpl)this.getJobById(jobId);
        if (job != null && !this.configuration.isStoragePath(job.getResourcePath())) {
            QueueConfigurationManager.QueueInfo queueInfo = this.configuration.getQueueConfigurationManager().getQueueInfo(job.getTopic());
            JobQueueImpl queue = (JobQueueImpl)this.qManager.getQueue(queueInfo.queueName);
            boolean stopped = false;
            if (queue != null) {
                stopped = queue.stopJob(job);
            }
            if (forward && !stopped) {
                JobHandler jh = new JobHandler(job, null, this.configuration);
                jh.finished(Job.JobState.STOPPED, true, null);
            }
        }
    }

    @Override
    public JobBuilder createJob(String topic) {
        return new JobBuilderImpl(this, topic);
    }

    @Override
    public Collection<ScheduledJobInfo> getScheduledJobs() {
        return this.jobScheduler.getScheduledJobs(null, -1L, null);
    }

    @Override
    public Collection<ScheduledJobInfo> getScheduledJobs(String topic, long limit, Map<String, Object> ... templates) {
        return this.jobScheduler.getScheduledJobs(topic, limit, templates);
    }

    public Job addJob(String topic, Map<String, Object> properties, List<String> errors) {
        String errorMessage = Utility.checkJob(topic, properties);
        if (errorMessage != null) {
            this.logger.warn("{}", (Object)errorMessage);
            if (errors != null) {
                errors.add(errorMessage);
            }
            this.configuration.getAuditLogger().debug("ADD FAILED topic={}, properties={} : {}", new Object[]{topic, properties, errorMessage});
            return null;
        }
        ArrayList<String> errorList = new ArrayList<String>();
        Job result = this.addJobInternal(topic, properties, errorList);
        if (errors != null) {
            errors.addAll(errorList);
        }
        if (result == null) {
            this.configuration.getAuditLogger().debug("ADD FAILED topic={}, properties={} : {}", new Object[]{topic, properties, errorList});
        } else {
            this.configuration.getAuditLogger().debug("ADD OK topic={}, properties={} : {}", new Object[]{topic, properties, result.getId()});
        }
        return result;
    }

    @Override
    public Job retryJobById(String jobId) {
        JobImpl job = (JobImpl)this.getJobById(jobId);
        if (job != null && this.configuration.isStoragePath(job.getResourcePath())) {
            this.internalRemoveJobById(jobId, true);
            return this.addJob(job.getTopic(), job.getProperties());
        }
        return null;
    }

    public JobSchedulerImpl getJobScheduler() {
        return this.jobScheduler;
    }

    private static enum Operation {
        LESS,
        LESS_OR_EQUALS,
        EQUALS,
        GREATER_OR_EQUALS,
        GREATER;

    }
}

