/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Session;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.api.SlingRepositoryInitializer;
import org.apache.sling.jcr.repoinit.JcrRepoInitOpsProcessor;
import org.apache.sling.jcr.repoinit.impl.RepoinitTextProvider;
import org.apache.sling.repoinit.parser.RepoInitParser;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Designate(ocd=Config.class, factory=true)
@Component(service={SlingRepositoryInitializer.class}, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"org.apache.sling.jcr.repoinit.RepositoryInitializer"}, property={"service.vendor=The Apache Software Foundation", "service.ranking:Integer=100"})
public class RepositoryInitializerFactory
implements SlingRepositoryInitializer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    private RepoInitParser parser;
    @Reference
    private JcrRepoInitOpsProcessor processor;
    private Config config;

    @Activate
    public void activate(Config config) {
        this.config = config;
        this.log.debug("Activated: {}", (Object)this.toString());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", references=" + Arrays.toString(this.config.references()) + ", scripts=" + (this.config.scripts() != null ? this.config.scripts().length : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRepository(SlingRepository repo) throws Exception {
        if (this.config.references() != null && this.config.references().length > 0 || this.config.scripts() != null && this.config.scripts().length > 0) {
            Session s = repo.loginAdministrative(null);
            try {
                if (this.config.references() != null) {
                    RepoinitTextProvider p = new RepoinitTextProvider();
                    String[] stringArray = this.config.references();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String reference = stringArray[i];
                        String repoinitText = p.getRepoinitText("raw:" + reference);
                        List ops = this.parser.parse((Reader)new StringReader(repoinitText));
                        this.log.info("Executing {} repoinit operations", (Object)ops.size());
                        this.processor.apply(s, ops);
                        s.save();
                    }
                }
                if (this.config.scripts() != null) {
                    for (String script : this.config.scripts()) {
                        List ops = this.parser.parse((Reader)new StringReader(script));
                        this.log.info("Executing {} repoinit operations", (Object)ops.size());
                        this.processor.apply(s, ops);
                        s.save();
                    }
                }
            }
            finally {
                s.logout();
            }
        }
    }

    @ObjectClassDefinition(name="Apache Sling Repository Initializer Factory", description="Initializes the JCR content repository using repoinit statements.")
    public static @interface Config {
        @AttributeDefinition(name="References", description="References to the source text that provides repoinit statements. format is a raw URL.")
        public String[] references() default {};

        @AttributeDefinition(name="Scripts", description="Contents of a repo init script.")
        public String[] scripts() default {};
    }
}

