/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.repoinit.impl;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlManager;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.sling.jcr.repoinit.impl.UserUtil;
import org.apache.sling.repoinit.parser.operations.RestrictionClause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AclUtil.class);

    public static JackrabbitAccessControlManager getJACM(Session s) throws RepositoryException {
        AccessControlManager acm = s.getAccessControlManager();
        if (!(acm instanceof JackrabbitAccessControlManager)) {
            throw new IllegalStateException("AccessControlManager is not a JackrabbitAccessControlManager:" + acm.getClass().getName());
        }
        return (JackrabbitAccessControlManager)acm;
    }

    private static LocalRestrictions createLocalRestrictions(List<RestrictionClause> list, JackrabbitAccessControlList jacl, Session s) throws RepositoryException {
        HashMap<String, Value> restrictions = new HashMap<String, Value>();
        HashMap<String, Value[]> mvrestrictions = new HashMap<String, Value[]>();
        if (list != null && !list.isEmpty()) {
            ValueFactory vf = s.getValueFactory();
            for (RestrictionClause rc : list) {
                String restrictionName = rc.getName();
                int type = jacl.getRestrictionType(restrictionName);
                Value[] values = new Value[rc.getValues().size()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = vf.createValue((String)rc.getValues().get(i), type);
                }
                if ("rep:glob".equals(restrictionName) && values.length == 0) {
                    restrictions.put(restrictionName, vf.createValue(""));
                    continue;
                }
                if (values.length == 1) {
                    restrictions.put(restrictionName, values[0]);
                    continue;
                }
                mvrestrictions.put(restrictionName, values);
            }
        }
        return new LocalRestrictions(restrictions, mvrestrictions);
    }

    public static void setAcl(Session session, List<String> principals, List<String> paths, List<String> privileges, boolean isAllow) throws RepositoryException {
        AclUtil.setAcl(session, principals, paths, privileges, isAllow, Arrays.asList(new RestrictionClause[0]));
    }

    public static void setAcl(Session session, List<String> principals, List<String> paths, List<String> privileges, boolean isAllow, List<RestrictionClause> restrictionClauses) throws RepositoryException {
        for (String path : paths) {
            if (!session.nodeExists(path)) {
                throw new PathNotFoundException("Cannot set ACL on non-existent path " + path);
            }
            AclUtil.setAcl(session, principals, path, privileges, isAllow, restrictionClauses);
        }
    }

    private static void setAcl(Session session, List<String> principals, String path, List<String> privileges, boolean isAllow, List<RestrictionClause> restrictionClauses) throws RepositoryException {
        String[] privArray = privileges.toArray(new String[privileges.size()]);
        Privilege[] jcrPriv = AccessControlUtils.privilegesFromNames((Session)session, (String[])privArray);
        JackrabbitAccessControlList acl = AccessControlUtils.getAccessControlList((Session)session, (String)path);
        LocalRestrictions localRestrictions = AclUtil.createLocalRestrictions(restrictionClauses, acl, session);
        AccessControlEntry[] existingAces = acl.getAccessControlEntries();
        boolean changed = false;
        for (String name : principals) {
            Principal principal;
            if ("everyone".equals(name)) {
                principal = AccessControlUtils.getPrincipal((Session)session, (String)name);
            } else {
                Authorizable authorizable = UserUtil.getAuthorizable(session, name);
                if (authorizable == null) {
                    throw new IllegalStateException("Authorizable not found:" + name);
                }
                principal = authorizable.getPrincipal();
            }
            if (principal == null) {
                throw new IllegalStateException("Principal not found: " + name);
            }
            LocalAccessControlEntry newAce = new LocalAccessControlEntry(principal, jcrPriv, isAllow, localRestrictions);
            if (AclUtil.contains(existingAces, newAce)) {
                LOG.info("Not adding {} to path {} since an equivalent access control entry already exists", (Object)newAce, (Object)path);
                continue;
            }
            acl.addEntry(newAce.principal, newAce.privileges, newAce.isAllow, newAce.restrictions.getRestrictions(), newAce.restrictions.getMVRestrictions());
            changed = true;
        }
        if (changed) {
            AclUtil.getJACM(session).setPolicy(path, (AccessControlPolicy)acl);
        }
    }

    public static void setRepositoryAcl(Session session, List<String> principals, List<String> privileges, boolean isAllow, List<RestrictionClause> restrictionClauses) throws RepositoryException {
        AclUtil.setAcl(session, principals, (String)null, privileges, isAllow, restrictionClauses);
    }

    static boolean contains(AccessControlEntry[] existingAces, LocalAccessControlEntry newAce) throws RepositoryException {
        for (int i = 0; i < existingAces.length; ++i) {
            JackrabbitAccessControlEntry existingEntry = (JackrabbitAccessControlEntry)existingAces[i];
            LOG.debug("Comparing {} with {}", (Object)newAce, (Object)AclUtil.toString(existingEntry));
            if (!newAce.isContainedIn(existingEntry)) continue;
            return true;
        }
        return false;
    }

    private static String toString(JackrabbitAccessControlEntry entry) throws RepositoryException {
        return "[" + entry.getClass().getSimpleName() + "# principal: " + entry.getPrincipal() + ", privileges: " + Arrays.toString(entry.getPrivileges()) + ", isAllow: " + entry.isAllow() + ", restrictionNames: " + entry.getRestrictionNames() + "]";
    }

    static boolean compareArrays(Object[] a, Object[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        Arrays.sort(a);
        Arrays.sort(b);
        for (int i = 0; i < a.length; ++i) {
            if (a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }

    private static class LocalRestrictions {
        private Map<String, Value> restrictions;
        private Map<String, Value[]> mvRestrictions;

        public LocalRestrictions() {
            this.restrictions = new HashMap<String, Value>();
            this.mvRestrictions = new HashMap<String, Value[]>();
        }

        public LocalRestrictions(Map<String, Value> restrictions, Map<String, Value[]> mvRestrictions) {
            this.restrictions = restrictions != null ? restrictions : new HashMap();
            this.mvRestrictions = mvRestrictions != null ? mvRestrictions : new HashMap();
        }

        public Map<String, Value> getRestrictions() {
            return this.restrictions;
        }

        public Map<String, Value[]> getMVRestrictions() {
            return this.mvRestrictions;
        }

        public int size() {
            return this.restrictions.size() + this.mvRestrictions.size();
        }
    }

    static class LocalAccessControlEntry {
        private final Principal principal;
        private final Privilege[] privileges;
        private final boolean isAllow;
        private final LocalRestrictions restrictions;

        LocalAccessControlEntry(Principal principal, Privilege[] privileges, boolean isAllow) {
            this(principal, privileges, isAllow, null);
        }

        LocalAccessControlEntry(Principal principal, Privilege[] privileges, boolean isAllow, LocalRestrictions restrictions) {
            this.principal = principal;
            this.privileges = privileges;
            this.isAllow = isAllow;
            this.restrictions = restrictions != null ? restrictions : new LocalRestrictions();
        }

        public boolean isContainedIn(JackrabbitAccessControlEntry other) throws RepositoryException {
            return other.getPrincipal().equals(this.principal) && this.contains(other.getPrivileges(), this.privileges) && other.isAllow() == this.isAllow && this.sameRestrictions(other);
        }

        private Set<Privilege> expandPrivileges(Privilege[] privileges) {
            HashSet<Privilege> expandedSet = new HashSet<Privilege>();
            if (privileges != null) {
                for (Privilege privilege : privileges) {
                    if (privilege.isAggregate()) {
                        expandedSet.addAll(Arrays.asList(privilege.getAggregatePrivileges()));
                        continue;
                    }
                    expandedSet.add(privilege);
                }
            }
            return expandedSet;
        }

        private boolean sameRestrictions(JackrabbitAccessControlEntry jace) throws RepositoryException {
            if (jace.getRestrictionNames().length == this.restrictions.size()) {
                for (String rn : jace.getRestrictionNames()) {
                    Object[] newValues;
                    Object[] objectArray;
                    Object[] oldValues = jace.getRestrictions(rn);
                    if (this.restrictions.getRestrictions().get(rn) != null) {
                        Object[] objectArray2 = new Value[1];
                        objectArray = objectArray2;
                        objectArray2[0] = this.restrictions.getRestrictions().get(rn);
                    } else {
                        objectArray = newValues = this.restrictions.getMVRestrictions().get(rn);
                    }
                    if ((newValues == null || newValues.length == 0) && (oldValues == null || oldValues.length == 0) || AclUtil.compareArrays(newValues, oldValues)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean contains(Privilege[] first, Privilege[] second) {
            Set<Privilege> set1 = this.expandPrivileges(first);
            Set<Privilege> set2 = this.expandPrivileges(second);
            return set1.containsAll(set2);
        }

        public String toString() {
            return "[" + this.getClass().getSimpleName() + "# principal " + this.principal + ", privileges: " + Arrays.toString(this.privileges) + ", isAllow : " + this.isAllow + "]";
        }
    }
}

