/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal.resource;

import java.util.HashMap;
import javax.servlet.Servlet;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.servlets.resolver.internal.resource.ServletResourceProviderFactory;

class ServletResource
extends AbstractResource {
    private final ResourceResolver resourceResolver;
    private final Servlet servlet;
    private final String path;
    private final String resourceType;
    private final ResourceMetadata metadata;

    ServletResource(ResourceResolver resourceResolver, Servlet servlet, String path) {
        this.resourceResolver = resourceResolver;
        this.servlet = servlet;
        this.path = path;
        this.resourceType = ServletResourceProviderFactory.ensureServletNameExtension(path);
        this.metadata = new ResourceMetadata();
        this.metadata.setResolutionPath(path);
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourceSuperType() {
        return "sling/bundle/resource";
    }

    public String getPath() {
        return this.path;
    }

    private String getServletName() {
        String servletName = null;
        if (this.servlet.getServletConfig() != null) {
            servletName = this.servlet.getServletConfig().getServletName();
        }
        if (servletName == null) {
            servletName = this.servlet.getServletInfo();
        }
        if (servletName == null) {
            servletName = this.servlet.getClass().getName();
        }
        return servletName;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == Servlet.class) {
            return (AdapterType)this.servlet;
        }
        if (type == ValueMap.class) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sling:resourceType", this.getResourceType());
            props.put("sling:resourceSuperType", this.getResourceSuperType());
            props.put("servletName", this.getServletName());
            props.put("servletClass", this.servlet.getClass().getName());
            return (AdapterType)new ValueMapDecorator(props);
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ", servlet=" + this.getServletName() + ", path=" + this.getPath();
    }
}

