/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.resolver.internal;

import java.util.Iterator;
import javax.servlet.Servlet;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.scripting.SlingScript;

public class ScriptResource
extends AbstractResource {
    private volatile Resource sharedResource;
    private final ResourceResolver sharedResourceResolver;
    private final ThreadLocal<ResourceResolver> perThreadResourceResolver;
    private final String path;

    public ScriptResource(Resource resource, ThreadLocal<ResourceResolver> perThreadScriptResolver, ResourceResolver sharedResourceResolver) {
        this.path = resource.getPath();
        this.sharedResourceResolver = sharedResourceResolver;
        this.perThreadResourceResolver = perThreadScriptResolver;
    }

    private Resource getActiveResource() {
        ResourceResolver perThreadResolver = this.perThreadResourceResolver.get();
        if (perThreadResolver != null && perThreadResolver.isLive()) {
            return perThreadResolver.getResource(this.path);
        }
        if (this.sharedResource == null) {
            this.sharedResource = this.sharedResourceResolver.getResource(this.path);
        }
        return this.sharedResource;
    }

    public String getResourceType() {
        return this.getActiveResource().getResourceType();
    }

    public String getResourceSuperType() {
        return this.getActiveResource().getResourceSuperType();
    }

    public ResourceResolver getResourceResolver() {
        return this.getActiveResource().getResourceResolver();
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        SlingScript s;
        if (type == Servlet.class) {
            Servlet s2 = (Servlet)super.adaptTo(type);
            if (s2 != null) {
                return (AdapterType)s2;
            }
        } else if (type == SlingScript.class && (s = (SlingScript)super.adaptTo(type)) != null) {
            return (AdapterType)s;
        }
        return (AdapterType)this.getActiveResource().adaptTo(type);
    }

    public String getPath() {
        return this.path;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.getActiveResource().getResourceMetadata();
    }

    public String getName() {
        return ResourceUtil.getName((String)this.path);
    }

    public Resource getParent() {
        return this.getActiveResource().getParent();
    }

    public Resource getChild(String relPath) {
        return this.getActiveResource().getChild(relPath);
    }

    public Iterator<Resource> listChildren() {
        return this.getActiveResource().listChildren();
    }

    public Iterable<Resource> getChildren() {
        return this.getActiveResource().getChildren();
    }

    public boolean isResourceType(String resourceType) {
        return this.getActiveResource().isResourceType(resourceType);
    }
}

