/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.constraint;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.Selector;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.constraint.EvaluationContext;
import org.apache.jackrabbit.core.query.lucene.constraint.SelectorBasedConstraint;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.query.qom.SelectorImpl;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

public abstract class QueryConstraint
extends SelectorBasedConstraint {
    private final Query constraint;
    private final LuceneQueryFactory factory;
    private Map<Integer, Float> matches;

    public QueryConstraint(Query constraint, SelectorImpl selector, LuceneQueryFactory factory) {
        super(selector);
        this.constraint = constraint;
        this.factory = factory;
    }

    @Override
    public boolean evaluate(ScoreNode[] row, Name[] selectorNames, EvaluationContext context) throws IOException {
        ScoreNode sn = row[this.getSelectorIndex(selectorNames)];
        return sn != null && this.evaluate(sn, context);
    }

    private boolean evaluate(ScoreNode sn, EvaluationContext context) throws IOException {
        this.initMatches(context);
        Float score = this.matches.get(sn.getDoc(context.getIndexReader()));
        if (score != null) {
            sn.setScore(score.floatValue());
        }
        return score != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMatches(EvaluationContext context) throws IOException {
        if (this.matches == null) {
            BooleanQuery and = new BooleanQuery();
            try {
                Query selectorQuery = this.factory.create((Selector)this.getSelector());
                and.add(selectorQuery, BooleanClause.Occur.MUST);
                and.add(this.constraint, BooleanClause.Occur.MUST);
            }
            catch (RepositoryException e) {
                throw Util.createIOException(e);
            }
            IndexReader reader = context.getIndexReader();
            QueryHits hits = context.evaluate(and);
            try {
                ScoreNode sn;
                this.matches = new HashMap<Integer, Float>();
                while ((sn = hits.nextScoreNode()) != null) {
                    this.matches.put(sn.getDoc(reader), Float.valueOf(sn.getScore()));
                }
            }
            finally {
                hits.close();
            }
        }
    }
}

