/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.classloader.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static Property getProperty(Item item) throws ValueFormatException, RepositoryException {
        Property prop;
        Node node;
        if (item.isNode()) {
            node = (Node)item;
            if (node.hasNode("jcr:content")) {
                node = node.getNode("jcr:content");
            }
            if (node.hasProperty("jcr:data")) {
                prop = node.getProperty("jcr:data");
            } else {
                try {
                    item = node.getPrimaryItem();
                    while (item.isNode()) {
                        item = ((Node)item).getPrimaryItem();
                    }
                    prop = (Property)item;
                }
                catch (ItemNotFoundException infe) {
                    log.debug("getProperty: No primary items for " + node.getPath(), (Throwable)infe);
                    return null;
                }
            }
        } else {
            prop = (Property)item;
        }
        if (prop.getDefinition().isMultiple()) {
            log.error("{} is a multivalue property", (Object)prop.getPath());
            return null;
        }
        if (prop.getType() == 9) {
            node = prop.getNode();
            log.info("Property {} refers to node {}; finding primary item", (Object)prop.getPath(), (Object)node.getPath());
            return Util.getProperty((Item)node);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(Node node) throws IOException, RepositoryException {
        InputStream in = null;
        try {
            in = Util.getProperty((Item)node).getStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            int l = 0;
            while ((l = in.read(buffer)) > -1) {
                baos.write(buffer, 0, l);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

