/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.resources.impl.common.SimplePathInfo;
import org.apache.sling.distribution.resources.impl.common.SimpleReadableResource;
import org.apache.sling.distribution.resources.impl.common.SimpleReadableResourceIterator;

public abstract class AbstractReadableResourceProvider
implements ResourceProvider {
    protected static final String INTERNAL_ADAPTABLE = "internal:adaptable";
    public static final String INTERNAL_NAME = "internal:adaptable";
    protected static final String INTERNAL_ITEMS_ITERATOR = "internal:itemsIterator";
    protected static final String ITEMS = "items";
    protected static final String SLING_RESOURCE_TYPE = "sling:resourceType";
    final String resourceRoot;

    protected AbstractReadableResourceProvider(String resourceRoot) {
        this.resourceRoot = resourceRoot;
    }

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        SimplePathInfo pathInfo = this.extractPathInfo(path);
        if (pathInfo == null) {
            return null;
        }
        if (pathInfo.getResourcePathInfo() != null && pathInfo.getResourcePathInfo().length() > 0) {
            return null;
        }
        if (!this.hasPermission(resourceResolver, pathInfo.getResourcePath(), "read")) {
            return null;
        }
        Resource resource = null;
        Map<String, Object> properties = this.getResourceProperties(resourceResolver, pathInfo);
        if (properties != null) {
            Object adaptable = properties.remove("internal:adaptable");
            properties.remove(INTERNAL_ITEMS_ITERATOR);
            resource = this.buildMainResource(resourceResolver, pathInfo, properties, adaptable);
        }
        return resource;
    }

    Resource buildMainResource(ResourceResolver resourceResolver, SimplePathInfo pathInfo, Map<String, Object> properties, Object ... adapters) {
        return new SimpleReadableResource(resourceResolver, pathInfo.getResourcePath(), properties, adapters);
    }

    SimplePathInfo extractPathInfo(String path) {
        return SimplePathInfo.parsePathInfo(this.resourceRoot, path);
    }

    boolean hasPermission(ResourceResolver resourceResolver, String resourcePath, String permission) {
        boolean hasPermission = false;
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        if (session != null) {
            try {
                hasPermission = session.hasPermission(resourcePath, permission);
            }
            catch (RepositoryException e) {
                hasPermission = false;
            }
        }
        return hasPermission;
    }

    public Iterator<Resource> listChildren(Resource parent) {
        String path = parent.getPath();
        ResourceResolver resourceResolver = parent.getResourceResolver();
        SimplePathInfo pathInfo = this.extractPathInfo(path);
        if (pathInfo == null) {
            return null;
        }
        if (pathInfo.getResourcePathInfo() != null && pathInfo.getResourcePathInfo().length() > 0) {
            return null;
        }
        if (!this.hasPermission(resourceResolver, pathInfo.getResourcePath(), "read")) {
            return null;
        }
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        Iterable<String> childrenList = this.getResourceChildren(resourceResolver, pathInfo);
        Iterator childrenProperties = null;
        if (childrenList == null) {
            Map<String, Object> properties = this.getResourceProperties(resourceResolver, pathInfo);
            if (properties != null && properties.containsKey(ITEMS) && properties.get(ITEMS) instanceof String[]) {
                String[] itemsArray = (String[])properties.get(ITEMS);
                childrenList = Arrays.asList(itemsArray);
            }
            if (properties != null && properties.containsKey(INTERNAL_ITEMS_ITERATOR)) {
                childrenProperties = (Iterator)properties.get(INTERNAL_ITEMS_ITERATOR);
            }
        }
        if (childrenProperties != null) {
            return new SimpleReadableResourceIterator(childrenProperties, resourceResolver, path);
        }
        if (childrenList != null) {
            for (String childResourceName : childrenList) {
                Resource childResource = this.getResource(resourceResolver, path + "/" + childResourceName);
                resourceList.add(childResource);
            }
        }
        return resourceList.listIterator();
    }

    Map<String, Object> getResourceProperties(ResourceResolver resolver, SimplePathInfo pathInfo) {
        return this.getInternalResourceProperties(resolver, pathInfo);
    }

    private Iterable<String> getResourceChildren(ResourceResolver resolver, SimplePathInfo pathInfo) {
        return this.getInternalResourceChildren(resolver, pathInfo);
    }

    protected abstract Map<String, Object> getInternalResourceProperties(ResourceResolver var1, SimplePathInfo var2);

    protected abstract Iterable<String> getInternalResourceChildren(ResourceResolver var1, SimplePathInfo var2);
}

