/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.clam;

import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class ScanResult {
    private final long timestamp = System.currentTimeMillis();
    private final Status status;
    private final String message;
    private final long started;
    private final long size;

    public ScanResult(@NotNull Status status, @NotNull String message, long started, long size) {
        this.status = status;
        this.message = message;
        this.started = started;
        this.size = size;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public Status getStatus() {
        return this.status;
    }

    @NotNull
    public String getMessage() {
        return this.message;
    }

    public long getStarted() {
        return this.started;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isOk() {
        return Status.OK.equals((Object)this.status);
    }

    public static enum Status {
        OK,
        FOUND,
        ERROR,
        UNKNOWN;

    }
}

