/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.view;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.pckgmgr.jcrpckg.PackageServlet;
import com.composum.sling.core.pckgmgr.jcrpckg.view.PackageBean;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.composum.sling.core.pckgmgr.regpckg.util.RegistryUtil;
import com.composum.sling.core.pckgmgr.regpckg.util.VersionComparator;
import com.composum.sling.core.pckgmgr.regpckg.view.PackageView;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.registry.DependencyReport;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.SyntheticResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/packages/manager")
public class VersionBean
extends ConsoleSlingBean
implements PackageView,
AutoCloseable {
    public static final String RESOURCE_TYPE = "composum/nodes/pckgmgr/version";
    private static final Logger LOG = LoggerFactory.getLogger(VersionBean.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    protected static final Comparator<PackageId> BY_GROUP_AND_NAME_COMPARATOR = new VersionComparator.PackageIdByGroupAndNameComparator();
    protected static final Comparator<PackageId> PACKAGE_ID_COMPARATOR = new VersionComparator.PackageIdComparator(false);
    protected String namespace;
    protected PackageId packageId;
    protected boolean loaded = false;
    protected transient RegisteredPackage regPckg;
    protected transient VaultPackage vltPckg;
    protected transient PackageProperties packageProps;
    protected transient boolean invalid;
    protected transient String registryNamespace;
    protected transient PackageRegistries.Registries registries;
    protected String[] satisfiedDependencies;
    protected String[] notInstalledDependencies;
    protected String[] unresolvedDependencies;

    public VersionBean() {
    }

    public VersionBean(BeanContext context, String path) {
        super(context, (Resource)new SyntheticResource(context.getResolver(), path, RESOURCE_TYPE));
    }

    public VersionBean(BeanContext context, String namespace, PackageId packageId) {
        super(context, (Resource)new SyntheticResource(context.getResolver(), RegistryUtil.toPath(namespace, packageId), RESOURCE_TYPE));
    }

    public void initialize(BeanContext context, Resource resource) {
        SlingHttpServletRequest request = context.getRequest();
        String path = resource.isResourceType(RESOURCE_TYPE) ? resource.getPath() : RegistryUtil.requestPath(request);
        this.namespace = RegistryUtil.namespace(path);
        this.packageId = RegistryUtil.fromPath(path);
        super.initialize(context, (Resource)new SyntheticResource(context.getResolver(), path, RESOURCE_TYPE));
        try {
            this.load(context);
        }
        catch (IOException ex) {
            LOG.error("Error loading {}", (Object)this.getPackageId(), (Object)ex);
            this.invalid = true;
        }
    }

    public void load(BeanContext context) throws IOException {
        if (this.registries == null) {
            PackageRegistries service = (PackageRegistries)context.getService(PackageRegistries.class);
            this.registries = service.getRegistries(context.getResolver());
            Pair<String, PackageId> found = this.registries.resolve(this.getNamespace(), this.getPackageId());
            if (found != null && found.getRight() != null) {
                this.registryNamespace = (String)found.getLeft();
            }
        }
    }

    protected void loadPackage() {
        try {
            if (!this.loaded) {
                this.loaded = true;
                if (this.regPckg == null && this.registryNamespace != null) {
                    PackageRegistry registry = this.registries.getRegistry(this.registryNamespace);
                    this.regPckg = registry.open(this.getPackageId());
                    if (this.regPckg != null) {
                        this.packageProps = this.regPckg.getPackageProperties();
                        this.vltPckg = this.regPckg.getPackage();
                    }
                }
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error loading {} {}", new Object[]{this.getNamespace(), this.getPackageId(), e});
            this.invalid = true;
        }
    }

    public String getPathWithRegistry() {
        return RegistryUtil.toPath(this.registryNamespace, this.getPackageId());
    }

    @Override
    public void close() {
        try {
            if (this.regPckg != null) {
                this.regPckg.close();
            }
        }
        catch (Exception e) {
            LOG.error("Error closing {}", (Object)this.getPath(), (Object)e);
        }
        finally {
            try {
                if (this.vltPckg != null && (this.regPckg == null || this.vltPckg != this.regPckg.getPackage())) {
                    this.vltPckg.close();
                }
            }
            catch (Exception e) {
                LOG.error("Error closing {}", (Object)this.getPath(), (Object)e);
            }
        }
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public String getRegistryNamespace() {
        return this.registryNamespace;
    }

    @Override
    public PackageId getPackageId() {
        return this.packageId;
    }

    @Override
    public String getGroup() {
        return this.getPackageId().getGroup();
    }

    @Override
    public String getName() {
        return this.getPackageId().getName();
    }

    @Override
    public String getVersion() {
        return this.getPackageId().getVersionString();
    }

    @Override
    public boolean isValid() {
        this.loadPackage();
        return !this.invalid && this.vltPckg != null && this.vltPckg.isValid();
    }

    @Override
    public boolean isInstalled() {
        this.loadPackage();
        return this.regPckg != null && this.regPckg.isInstalled();
    }

    @Override
    public boolean isClosed() {
        this.loadPackage();
        return this.vltPckg != null && this.vltPckg.isClosed();
    }

    public String getDescription() {
        this.loadPackage();
        return this.packageProps != null ? this.packageProps.getDescription() : null;
    }

    public String getCssClasses() {
        ArrayList<String> classes = new ArrayList<String>();
        if (this.isInstalled()) {
            classes.add("installed");
        }
        if (this.isValid()) {
            classes.add("valid");
        }
        return StringUtils.join(classes, (String)" ");
    }

    public String getFilename() {
        return this.getPackageId().getDownloadName();
    }

    public String getDownloadUrl() {
        return LinkUtil.getUrl((SlingHttpServletRequest)this.getRequest(), (String)RegistryUtil.getDownloadURI(this.registryNamespace, this.getPackageId()));
    }

    public List<PathFilterSet> getFilterList() {
        this.loadPackage();
        WorkspaceFilter workspaceFilter = this.regPckg != null ? this.regPckg.getWorkspaceFilter() : null;
        return workspaceFilter != null ? workspaceFilter.getFilterSets() : null;
    }

    public String getAuditLogUrl() {
        return LinkUtil.getUrl((SlingHttpServletRequest)this.getRequest(), (String)(PackageBean.AUDIT_LOG_BASE + this.getPath()));
    }

    public String getInstallationTime() {
        this.loadPackage();
        return this.packageProps != null ? this.format(this.regPckg.getInstallationTime(), null) : null;
    }

    public String getCreated() {
        this.loadPackage();
        return this.packageProps != null ? this.format(this.packageProps.getCreated(), this.packageProps.getProperty("created")) : null;
    }

    public String getCreatedBy() {
        this.loadPackage();
        return this.packageProps != null ? this.packageProps.getCreatedBy() : "--";
    }

    public String getLastModified() {
        this.loadPackage();
        return this.packageProps != null ? this.format(this.packageProps.getLastModified(), this.packageProps.getProperty("lastModified")) : null;
    }

    public String getLastModifiedBy() {
        this.loadPackage();
        return this.packageProps != null ? this.packageProps.getLastModifiedBy() : "--";
    }

    public String getLastWrapped() {
        this.loadPackage();
        return this.packageProps != null ? this.format(this.packageProps.getLastWrapped(), this.packageProps.getProperty("lastWrapped")) : null;
    }

    public String getLastWrappedBy() {
        this.loadPackage();
        return this.packageProps != null ? this.packageProps.getLastWrappedBy() : "--";
    }

    public String getAcHandling() {
        this.loadPackage();
        AccessControlHandling acHandling = this.packageProps.getACHandling();
        return acHandling != null ? acHandling.name() : "";
    }

    public String getAcHandlingLabel() {
        this.loadPackage();
        AccessControlHandling acHandling = this.packageProps.getACHandling();
        return acHandling != null ? acHandling.name() : "-- -- ";
    }

    public boolean getRequiresRestart() {
        this.loadPackage();
        return RegistryUtil.booleanProperty(this.packageProps, "requiresRestart", false);
    }

    public boolean getRequiresRoot() {
        this.loadPackage();
        return this.packageProps.requiresRoot();
    }

    public String getProviderName() {
        this.loadPackage();
        return this.packageProps.getProperty("providerName");
    }

    public String getProviderUrl() {
        this.loadPackage();
        return this.packageProps.getProperty("providerUrl");
    }

    public String getProviderLink() {
        this.loadPackage();
        return this.packageProps.getProperty("providerLink");
    }

    public String[] getDependencies() {
        this.loadPackage();
        return (String[])Arrays.stream(this.packageProps.getDependencies()).map(Object::toString).toArray(String[]::new);
    }

    protected void calculateDependencies() {
        if (this.unresolvedDependencies == null) {
            this.loadPackage();
            try {
                DependencyReport reportInstalled = this.registries.getRegistry(this.getRegistryNamespace()).analyzeDependencies(this.getPackageId(), true);
                DependencyReport reportAll = this.registries.getRegistry(this.getRegistryNamespace()).analyzeDependencies(this.getPackageId(), false);
                this.satisfiedDependencies = (String[])Arrays.stream(reportInstalled.getResolvedDependencies()).map(Object::toString).toArray(String[]::new);
                ArrayList<PackageId> uninstalledDependencyList = new ArrayList<PackageId>(Arrays.asList(reportAll.getResolvedDependencies()));
                uninstalledDependencyList.removeAll(Arrays.asList(reportInstalled.getResolvedDependencies()));
                this.notInstalledDependencies = (String[])uninstalledDependencyList.stream().map(Object::toString).toArray(String[]::new);
                this.unresolvedDependencies = (String[])Arrays.stream(reportAll.getUnresolvedDependencies()).map(Object::toString).toArray(String[]::new);
            }
            catch (IOException | RuntimeException | NoSuchPackageException e) {
                LOG.error("Error calculating dependencies for {}", (Object)this.getPath(), (Object)e);
            }
        }
    }

    public String[] getSatisfiedDependencies() {
        this.calculateDependencies();
        return this.satisfiedDependencies;
    }

    public String[] getNotInstalledDependencies() {
        this.calculateDependencies();
        return this.notInstalledDependencies;
    }

    public String[] getUnresolvedDependencies() {
        this.calculateDependencies();
        return this.unresolvedDependencies;
    }

    public String[] getReplaces() {
        this.loadPackage();
        String replaces = this.packageProps.getProperty("replaces");
        return StringUtils.isNotBlank((CharSequence)replaces) ? replaces.split(",") : null;
    }

    public String[] getUsages() {
        String[] result = null;
        try {
            PackageId[] usages = this.registries.getRegistry(this.getRegistryNamespace()).usage(this.getPackageId());
            result = (String[])Arrays.stream(usages).map(Object::toString).toArray(String[]::new);
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Error calculating dependencies for {}", (Object)this.getPackageId(), (Object)e);
        }
        return result;
    }

    protected String format(Calendar rawDate, String dateRep) {
        Calendar date = RegistryUtil.readPackagePropertyDate(rawDate, dateRep);
        return date != null ? new SimpleDateFormat(DATE_FORMAT).format(date.getTime()) : "";
    }

    public String getUrl() {
        return LinkUtil.getUrl((SlingHttpServletRequest)this.getRequest(), (String)("/bin/packages.html" + this.getPath()));
    }

    public boolean obsoletes(VersionBean other) {
        return BY_GROUP_AND_NAME_COMPARATOR.compare(this.getPackageId(), other.getPackageId()) == 0 && PACKAGE_ID_COMPARATOR.compare(this.getPackageId(), other.getPackageId()) > 0;
    }

    @Nullable
    public String getThumbnailUrl() throws IOException {
        this.loadPackage();
        Archive.Entry thumbnailEntry = this.vltPckg.getArchive().getEntry("META-INF/vault/definition/thumbnail.png");
        String thumbnailUrl = null;
        if (thumbnailEntry != null) {
            thumbnailUrl = "/bin/cpm/package." + (Object)((Object)PackageServlet.Operation.thumbnail) + ".png" + RegistryUtil.toPath(this.registryNamespace, this.packageId);
        }
        return thumbnailUrl;
    }
}

