/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.view;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.composum.sling.core.pckgmgr.regpckg.util.RegistryUtil;
import com.composum.sling.core.pckgmgr.regpckg.view.PackageBean;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/packages/manager")
public class RegistryBean
extends ConsoleSlingBean {
    public static final String RESOURCE_TYPE = "";
    private static final Logger LOG = LoggerFactory.getLogger(RegistryBean.class);
    protected String namespace;
    private transient String title;
    protected boolean loaded = false;
    protected Map<String, List<PackageBean>> groups;

    public void initialize(BeanContext context, Resource resource) {
        SlingHttpServletRequest request = context.getRequest();
        String path = RegistryUtil.requestPath(request);
        this.namespace = RegistryUtil.namespace(path);
        super.initialize(context, resource);
    }

    @Nonnull
    public String getNamespace() {
        return this.namespace;
    }

    @Nonnull
    public String getName() {
        return this.getNamespace();
    }

    @Nonnull
    public String getPath() {
        return "/@" + this.getNamespace();
    }

    @Nonnull
    public String getTitle() {
        if (this.title == null) {
            this.title = this.getName();
            PackageRegistry registry = this.getPackageRegistry(this.context);
            if (registry != null) {
                this.title = registry.getClass().getSimpleName();
            }
        }
        return this.title;
    }

    @Nonnull
    protected Map<String, List<PackageBean>> getGroups() {
        if (this.groups == null) {
            this.groups = new TreeMap<String, List<PackageBean>>();
            PackageRegistry registry = this.getPackageRegistry(this.context);
            if (registry != null) {
                try {
                    for (PackageId packageId : registry.packages()) {
                        this.addPackage(packageId);
                    }
                }
                catch (IOException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return this.groups;
    }

    protected void addPackage(PackageId packageId) {
        List group = this.groups.computeIfAbsent(packageId.getGroup(), k -> new ArrayList());
        group.add(new PackageBean(this.context, this.getNamespace(), packageId));
        Collections.sort(group);
    }

    @Nullable
    protected PackageRegistry getPackageRegistry(BeanContext context) {
        PackageRegistries service = (PackageRegistries)context.getService(PackageRegistries.class);
        PackageRegistries.Registries registries = service.getRegistries(context.getResolver());
        return registries.getRegistry(this.getNamespace());
    }
}

