/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.view;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.pckgmgr.regpckg.tree.PackageNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.RegistryItem;
import com.composum.sling.core.pckgmgr.regpckg.tree.RegistryTree;
import com.composum.sling.core.pckgmgr.regpckg.tree.VersionNode;
import com.composum.sling.core.pckgmgr.regpckg.util.RegistryUtil;
import com.composum.sling.core.pckgmgr.regpckg.util.VersionComparator;
import com.composum.sling.core.pckgmgr.regpckg.view.PackageView;
import com.composum.sling.core.pckgmgr.regpckg.view.VersionBean;
import com.composum.sling.core.util.LinkUtil;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.SyntheticResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/packages/manager")
public class PackageBean
extends ConsoleSlingBean
implements PackageView,
Comparable<PackageBean>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PackageBean.class);
    public static final String RESOURCE_TYPE = "";
    protected VersionBean currentVersion;
    protected final Map<String, VersionBean> versionSet = new TreeMap(new VersionComparator().reversed());

    public void initialize(BeanContext context) {
        SlingHttpServletRequest request = context.getRequest();
        String path = RegistryUtil.requestPath(request);
        super.initialize(context, (Resource)new SyntheticResource(context.getResolver(), path, RESOURCE_TYPE));
        try {
            this.load(context);
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.currentVersion != null) {
            this.currentVersion.close();
        }
        this.versionSet.values().stream().filter(v -> v != this.currentVersion).forEach(VersionBean::close);
    }

    public PackageBean() {
    }

    public PackageBean(BeanContext context, String path) {
        super(context, (Resource)new SyntheticResource(context.getResolver(), path, RESOURCE_TYPE));
    }

    public PackageBean(BeanContext context, String namespace, PackageId packageId) {
        super(context, (Resource)new SyntheticResource(context.getResolver(), RegistryUtil.toPath(namespace, packageId), RESOURCE_TYPE));
    }

    @Override
    public String getNamespace() {
        return this.currentVersion.getNamespace();
    }

    @Override
    public PackageId getPackageId() {
        return this.currentVersion.getPackageId();
    }

    @Override
    public String getGroup() {
        return this.getPackageId().getGroup();
    }

    @Override
    public String getName() {
        return this.getPackageId().getName();
    }

    @Override
    public String getVersion() {
        return this.currentVersion.getVersion();
    }

    public VersionBean getCurrentVersion() {
        return this.currentVersion;
    }

    @Override
    public boolean isValid() {
        return this.currentVersion.isValid();
    }

    @Override
    public boolean isInstalled() {
        return this.currentVersion.isInstalled();
    }

    @Override
    public boolean isClosed() {
        return this.currentVersion.isClosed();
    }

    public void load(BeanContext context) throws IOException {
        boolean merged = RegistryUtil.namespace(this.getPath()) == null;
        RegistryTree tree = new RegistryTree(merged);
        RegistryItem treeItem = tree.getItem(context, this.getPath());
        if (treeItem instanceof VersionNode) {
            treeItem = ((VersionNode)treeItem).getPackageNode();
        }
        if (treeItem instanceof PackageNode) {
            PackageNode node = (PackageNode)treeItem;
            for (RegistryItem item : node.getItems()) {
                if (!(item instanceof VersionNode)) continue;
                VersionNode versionNode = (VersionNode)item;
                VersionBean version = new VersionBean(context, versionNode.getPath());
                if (versionNode.isCurrent()) {
                    this.currentVersion = version;
                }
                this.versionSet.put(versionNode.getVersion(), version);
            }
            if (this.versionSet.size() > 0) {
                if (this.currentVersion == null) {
                    this.currentVersion = this.versionSet.values().iterator().next();
                }
            } else {
                LOG.error("no version found for '{}'", (Object)this.getPath());
            }
        } else {
            LOG.error("can't load PackageBean '{}' ({})", (Object)this.getPath(), (Object)(treeItem != null ? treeItem.getPath() : "NULL"));
        }
    }

    @Override
    public int compareTo(PackageBean other) {
        return this.getName().compareTo(other.getName());
    }

    public String getCssClasses() {
        return this.currentVersion != null ? this.currentVersion.getCssClasses() : RESOURCE_TYPE;
    }

    public String getDownloadUrl() {
        return this.currentVersion != null ? this.currentVersion.getDownloadUrl() : RESOURCE_TYPE;
    }

    public String getUrl() {
        return LinkUtil.getUrl((SlingHttpServletRequest)this.getRequest(), (String)("/bin/packages.html" + this.getPath()));
    }

    public Collection<VersionBean> getAllVersions() {
        return this.versionSet.values();
    }

    public Collection<VersionBean> getObsoleteVersions() {
        return this.versionSet.values().stream().filter(v -> this.currentVersion.obsoletes((VersionBean)v)).collect(Collectors.toList());
    }

    public boolean isHasAlternativeVersions() {
        return this.versionSet.size() > 1;
    }
}

