/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.util;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.pckgmgr.Packages;
import com.composum.sling.core.pckgmgr.jcrpckg.util.PackageUtil;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.PackageProperties;
import org.apache.jackrabbit.vault.packaging.SubPackageHandling;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.sling.api.SlingHttpServletRequest;

public interface RegistryUtil {
    public static final String NO_REGISTRY = "other";
    public static final String NO_GROUP = "nogroup";
    public static final String NO_VERSION = "-";
    public static final Pattern REGISTRY_CLASS_NS = Pattern.compile("^.*\\.(.+)PackageRegistry$");
    public static final List<String> BOOL_TRUE = new ArrayList<String>(){
        {
            this.add("true");
            this.add("on");
        }
    };
    public static final Pattern BROKEN_DATEFMT_PATTERN = Pattern.compile("(?<notimezone>.*)(?<timezonestart>[+-][0-9][0-9])(?<timezoneend>[0-9][0-9])");

    @Nonnull
    public static String namespace(@Nonnull PackageRegistry registry) {
        Matcher matcher = REGISTRY_CLASS_NS.matcher(registry.getClass().getName());
        return matcher.matches() ? matcher.group(1).toLowerCase() : NO_REGISTRY;
    }

    @Nullable
    public static String namespace(@Nonnull String namespacedPathOrPath) {
        Matcher matcher = Packages.REGISTRY_BASED_PATH.matcher(namespacedPathOrPath);
        return matcher.matches() ? matcher.group("ns") : null;
    }

    public static boolean isRegistryBasedPath(String path) {
        return StringUtils.isNotBlank((CharSequence)path) && StringUtils.isNotBlank((CharSequence)RegistryUtil.namespace(path));
    }

    @Nullable
    public static String pathWithoutNamespace(@Nullable String fullPath) {
        Matcher m;
        String path = null;
        if (fullPath != null && (m = Packages.REGISTRY_BASED_PATH.matcher(fullPath)).matches()) {
            path = m.group("path");
        }
        return path;
    }

    @Nullable
    public static String pathWithNamespace(@Nullable String namespace, @Nullable String path) {
        if (StringUtils.isBlank((CharSequence)namespace) || StringUtils.equals((CharSequence)RegistryUtil.namespace(path), (CharSequence)namespace)) {
            return path;
        }
        return "/@" + namespace + StringUtils.defaultString((String)path);
    }

    @Nonnull
    public static PackageId fromPath(@Nonnull String path) {
        PackageId id;
        Matcher matcher = Packages.PACKAGE_PATH.matcher(path);
        if (matcher.matches()) {
            String namespace = matcher.group("ns");
            String group = matcher.group("group");
            String name = matcher.group("name");
            String version = matcher.group("version");
            id = new PackageId(group == null || NO_GROUP.equals(group) ? "" : group, name, version == null || NO_VERSION.equals(version) ? null : version);
        } else {
            id = new PackageId("", path, "");
        }
        return id;
    }

    @Nonnull
    public static String toPath(@Nullable PackageRegistry registry, @Nonnull PackageId packageId) {
        return RegistryUtil.toPath(registry != null ? RegistryUtil.namespace(registry) : null, packageId);
    }

    @Nonnull
    public static String toPath(@Nullable String namespace, @Nonnull PackageId packageId) {
        String versionAppendix = StringUtils.isNotBlank((CharSequence)packageId.getVersionString()) ? packageId.getVersionString() : NO_VERSION;
        return RegistryUtil.toPackagePath(namespace, packageId) + '/' + versionAppendix;
    }

    @Nonnull
    public static String toPackagePath(@Nullable String namespace, @Nonnull PackageId packageId) {
        StringBuilder path = new StringBuilder();
        String group = packageId.getGroup();
        String name = packageId.getName();
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            path.append("/@").append(namespace);
        }
        path.append('/').append(StringUtils.isNotBlank((CharSequence)group) ? group : NO_GROUP).append('/').append(name);
        return path.toString();
    }

    @Nullable
    public static Pair<String, RegisteredPackage> open(@Nonnull BeanContext context, @Nullable String namespace, @Nonnull PackageId packageId) throws IOException {
        PackageRegistries service = (PackageRegistries)context.getService(PackageRegistries.class);
        return RegistryUtil.open(service.getRegistries(context.getResolver()), namespace, packageId);
    }

    @Nullable
    public static Pair<String, RegisteredPackage> open(@Nonnull BeanContext context, @Nonnull String path) throws IOException {
        PackageRegistries service = (PackageRegistries)context.getService(PackageRegistries.class);
        return RegistryUtil.open(service.getRegistries(context.getResolver()), path);
    }

    @Nullable
    public static Pair<String, RegisteredPackage> open(@Nonnull PackageRegistries.Registries registries, @Nonnull String path) throws IOException {
        String namespace = RegistryUtil.namespace(path);
        PackageId packageId = RegistryUtil.fromPath(path);
        return RegistryUtil.open(registries, namespace, packageId);
    }

    @Nullable
    public static Pair<String, RegisteredPackage> open(@Nonnull PackageRegistries.Registries registries, @Nullable String namespace, @Nonnull PackageId packageId) throws IOException {
        PackageRegistry registry = null;
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            registry = registries.getRegistry(namespace);
        }
        if (registry != null) {
            RegisteredPackage pckg = registry.open(packageId);
            return pckg != null ? Pair.of((Object)namespace, (Object)pckg) : null;
        }
        return registries.open(packageId);
    }

    @Nonnull
    public static String requestPath(@Nonnull SlingHttpServletRequest request) {
        return PackageUtil.getPath(request);
    }

    @Nonnull
    public static String getFilename(@Nonnull PackageId id) {
        StringBuilder filename = new StringBuilder();
        filename.append(id.getName());
        String version = id.getVersionString();
        if (StringUtils.isNotBlank((CharSequence)version)) {
            filename.append('-').append(version);
        }
        filename.append(".zip");
        return filename.toString();
    }

    @Nonnull
    public static String getDownloadURI(@Nullable String namespace, @Nonnull PackageId id) {
        StringBuilder uri = new StringBuilder("/bin/cpm/package.download.zip");
        uri.append(RegistryUtil.toPath(namespace, id));
        return uri.toString();
    }

    public static boolean booleanProperty(@Nonnull PackageProperties properties, @Nonnull String propertyKey, boolean defaultValue) {
        String value = properties.getProperty(propertyKey);
        return StringUtils.isNotBlank((CharSequence)value) ? BOOL_TRUE.contains(value.toLowerCase()) || Boolean.parseBoolean(value) : defaultValue;
    }

    @Nullable
    public static String date(@Nullable Calendar calendar) {
        return calendar != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(calendar.getTime()) : null;
    }

    public static void toJson(JsonWriter writer, String namespace, PackageId packageId) throws IOException {
        writer.beginObject();
        writer.name("name").value(packageId.getName());
        writer.name("group").value(packageId.getGroup());
        writer.name("version").value(packageId.getVersionString());
        writer.name("downloadName").value(packageId.getDownloadName());
        writer.name("registry").value(namespace);
        writer.endObject();
    }

    public static Calendar readPackagePropertyDate(Calendar rawDate, String dateRep) {
        Matcher brokenFmt;
        Calendar date = rawDate;
        if (date == null && StringUtils.isNotBlank((CharSequence)dateRep) && (brokenFmt = BROKEN_DATEFMT_PATTERN.matcher(dateRep)).matches()) {
            date = ISO8601.parse((String)(brokenFmt.group("notimezone") + brokenFmt.group("timezonestart") + ":" + brokenFmt.group("timezoneend")));
        }
        return date;
    }

    @Nonnull
    public static Map<String, Object> properties(@Nonnull RegisteredPackage pckg) throws IOException {
        PropertyMap properties = new PropertyMap();
        PackageProperties pckgProps = pckg.getPackageProperties();
        properties.put("created", RegistryUtil.readPackagePropertyDate(pckgProps.getCreated(), pckgProps.getProperty("created")));
        properties.put("createdBy", pckgProps.getCreatedBy());
        properties.put("description", pckgProps.getDescription());
        properties.put("lastModified", RegistryUtil.readPackagePropertyDate(pckgProps.getLastModified(), pckgProps.getProperty("lastModified")));
        properties.put("lastModifiedBy", pckgProps.getLastModifiedBy());
        properties.put("lastWrapped", RegistryUtil.readPackagePropertyDate(pckgProps.getLastWrapped(), pckgProps.getProperty("lastWrapped")));
        properties.put("lastWrappedBy", pckgProps.getLastWrappedBy());
        properties.put("packageType", pckgProps.getPackageType());
        properties.put("acHandling", pckgProps.getACHandling());
        properties.put("requiresRoot", pckgProps.requiresRoot());
        properties.put("requiresRestart", pckgProps.getProperty("requiresRestart"));
        SubPackageHandling subPckgHdlng = pckgProps.getSubPackageHandling();
        if (subPckgHdlng != null) {
            ArrayList entryList = new ArrayList();
            for (SubPackageHandling.Entry entry : subPckgHdlng.getEntries()) {
                LinkedHashMap<String, Object> entryProps = new LinkedHashMap<String, Object>();
                entryList.add(entryProps);
                entryProps.put("option", entry.getOption());
                entryProps.put("group", entry.getGroupName());
                entryProps.put("package", entry.getPackageName());
            }
            if (entryList.size() > 0) {
                properties.put("subPackageHandling", entryList);
            }
        }
        properties.put("useBinaryReferences", pckgProps.getProperty("useBinaryReferences"));
        return properties;
    }

    public static class PropertyMap
    extends LinkedHashMap<String, Object> {
        @Override
        public Object put(@Nonnull String key, @Nullable Object value) {
            if (value != null) {
                return super.put(key, this.adapt(value));
            }
            return null;
        }

        @Nonnull
        public <T> T add(@Nonnull String key, @Nonnull T value) {
            this.put(key, value);
            return value;
        }

        @Nullable
        public Object adapt(@Nullable Object value) {
            if (value instanceof Calendar) {
                value = RegistryUtil.date((Calendar)value);
            }
            return value;
        }
    }
}

