/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.tree;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.composum.sling.core.pckgmgr.regpckg.tree.AbstractNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.PackageNode;
import com.composum.sling.core.pckgmgr.regpckg.util.RegistryUtil;
import com.composum.sling.core.pckgmgr.regpckg.view.PackageView;
import com.composum.sling.core.util.RequestUtil;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.PathFilter;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionNode
extends AbstractNode
implements PackageView {
    private static final Logger LOG = LoggerFactory.getLogger(PackageNode.class);
    protected final PackageNode pckg;
    protected final String namespace;
    protected final PackageId packageId;
    protected final String version;
    protected final String registryNamespace;
    private transient Boolean valid;
    private transient Boolean installed;
    private transient Calendar installTime;

    public VersionNode(@Nonnull PackageNode pckg, @Nonnull String registryNamespace, @Nonnull PackageId packageId, @Nonnull String version) {
        super(pckg);
        String path = pckg.getPath() + "/" + version;
        this.pckg = pckg;
        this.namespace = RegistryUtil.namespace(path);
        this.packageId = packageId;
        this.version = version;
        this.registryNamespace = registryNamespace;
        this.put("path", path);
        this.put("name", version);
        this.put("text", version);
        this.put("type", "version");
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public PackageId getPackageId() {
        return this.packageId;
    }

    public String getNamespacedPath() {
        return RegistryUtil.pathWithNamespace(this.registryNamespace, this.getPath());
    }

    @Override
    public String getGroup() {
        return this.getPackageId().getGroup();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isValid() {
        return this.valid != null && this.valid != false;
    }

    @Override
    public boolean isInstalled() {
        return this.installed != null && this.installed != false;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    protected void toTreeState(@Nonnull JsonWriter writer) throws IOException {
        Calendar installTime;
        super.toTreeState(writer);
        writer.name("installed").value(this.isInstalled());
        writer.name("current").value(this.isCurrent());
        if (this.isInstalled() && (installTime = this.getInstallTime()) != null) {
            writer.name("installTime").value(RegistryUtil.date(installTime));
        }
    }

    public PackageNode getPackageNode() {
        return this.pckg;
    }

    public boolean isCurrent() {
        return this.pckg.getCurrentInstalled() == this;
    }

    public Calendar getInstallTime() {
        return this.installTime;
    }

    public RegistryUtil.PropertyMap getPackageProps() {
        return (RegistryUtil.PropertyMap)this.get("package");
    }

    @Override
    protected void toTreeProperties(@Nonnull JsonWriter writer) throws IOException {
        super.toTreeProperties(writer);
        writer.name("namespace").value(this.registryNamespace);
        writer.name("namespacedPath").value(this.getNamespacedPath());
        writer.name("packageid");
        RegistryUtil.toJson(writer, this.registryNamespace, this.packageId);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void load(@Nonnull BeanContext context) throws IOException {
        if (!this.isLoaded()) {
            this.installed = null;
            this.installTime = null;
            packageId = this.getPackageId();
            service = (PackageRegistries)context.getService(PackageRegistries.class);
            registry = service.getRegistries(context.getResolver()).getRegistry(this.getPath());
            if (registry != null) {
                pckg = registry.open(packageId);
                try {
                    vaultPckg = pckg != null ? pckg.getPackage() : null;
                    try {
                        if (pckg != null) {
                            pckgProps = new RegistryUtil.PropertyMap();
                            this.put("package", pckgProps);
                            this.installed = pckg.isInstalled();
                            pckgProps.put("installed", this.installed);
                            this.installTime = pckg.getInstallationTime();
                            pckgProps.put("installTime", this.installTime);
                            pckgProps.put("size", pckg.getSize());
                            this.valid = vaultPckg.isValid();
                            pckgProps.put("valid", this.valid);
                            metaInf = vaultPckg.getMetaInf();
                            this.put("properties", RegistryUtil.properties(pckg));
                            if (!RequestUtil.checkSelector((SlingHttpServletRequest)context.getRequest(), (String)"filter")) ** GOTO lbl68
                            filterList = new ArrayList<RegistryUtil.PropertyMap>();
                            this.put("filter", filterList);
                            filter = pckg.getWorkspaceFilter();
                            for (PathFilterSet filterSet : filter.getFilterSets()) {
                                setProps = new RegistryUtil.PropertyMap();
                                filterList.add(setProps);
                                setProps.put("root", filterSet.getRoot());
                                setProps.put("importMode", filterSet.getImportMode());
                                entryList = new ArrayList<RegistryUtil.PropertyMap>();
                                for (FilterSet.Entry entry : filterSet.getEntries()) {
                                    entryProps = new RegistryUtil.PropertyMap();
                                    entryList.add(entryProps);
                                    pathFilter = (PathFilter)entry.getFilter();
                                    entryProps.put(entry.isInclude() != false ? "include" : "exclude", pathFilter.toString());
                                }
                                if (entryList.size() <= 0) continue;
                                setProps.put("entries", entryList);
                            }
                        }
                        VersionNode.LOG.warn("can't open package '{}' ({})", (Object)packageId, (Object)registry);
                    }
                    finally {
                        if (vaultPckg != null) {
                            vaultPckg.close();
                        }
                    }
                }
                finally {
                    if (pckg != null) {
                        pckg.close();
                    }
                }
            } else {
                VersionNode.LOG.warn("no registry found for '{}'", (Object)this.getPath());
            }
lbl68:
            // 4 sources

            this.setLoaded(true);
        }
    }

    @Override
    public void loadForItems(@Nonnull BeanContext context) throws IOException {
    }
}

