/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.tree;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.pckgmgr.regpckg.tree.AbstractNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.GroupNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.RegistryItem;
import com.composum.sling.core.pckgmgr.regpckg.tree.VersionNode;
import com.composum.sling.core.pckgmgr.regpckg.util.RegistryUtil;
import com.composum.sling.core.pckgmgr.regpckg.util.VersionComparator;
import com.composum.sling.core.pckgmgr.regpckg.view.PackageView;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageNode
extends AbstractNode
implements PackageView {
    private static final Logger LOG = LoggerFactory.getLogger(PackageNode.class);
    public static final Comparator<String> COMPARATOR = new VersionComparator().reversed();
    protected final String namespace;
    protected final GroupNode group;
    protected final PackageId packageId;
    private transient VersionNode currentInstalled;

    public PackageNode(@Nonnull GroupNode group, PackageId packageId) {
        super(group);
        String path = group.getPath() + "/" + packageId.getName();
        this.namespace = RegistryUtil.namespace(path);
        this.group = group;
        this.packageId = packageId;
        this.put("path", path);
        this.put("name", packageId.getName());
        this.put("text", packageId.getName());
        this.put("type", "package");
        this.put("package", new RegistryUtil.PropertyMap());
        TreeMap items = new TreeMap(COMPARATOR);
        this.put("items", items);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Nonnull
    public PackageId getPackageId() {
        return this.packageId;
    }

    @Override
    public String getGroup() {
        return this.getPackageId().getGroup();
    }

    @Override
    public String getVersion() {
        return this.currentInstalled != null ? this.currentInstalled.getVersion() : this.getPackageId().getVersionString();
    }

    @Override
    public boolean isValid() {
        return this.currentInstalled != null && this.currentInstalled.isValid();
    }

    @Override
    public boolean isInstalled() {
        return this.currentInstalled != null && this.currentInstalled.isInstalled();
    }

    @Override
    public boolean isClosed() {
        return this.currentInstalled != null && this.currentInstalled.isClosed();
    }

    @Override
    protected void toTreeState(@Nonnull JsonWriter writer) throws IOException {
        super.toTreeState(writer);
        VersionNode version = this.getCurrentInstalled();
        if (version != null) {
            writer.name("version").value(version.getVersion());
            writer.name("installed").value(version.isInstalled());
        }
    }

    public VersionNode getCurrentInstalled() {
        return this.currentInstalled;
    }

    @Override
    public void load(@Nonnull BeanContext context) throws IOException {
        if (!this.isLoaded()) {
            this.currentInstalled = null;
            for (RegistryItem item : this.getItems()) {
                if (!(item instanceof VersionNode)) continue;
                VersionNode version = (VersionNode)item;
                if (!version.isLoaded()) {
                    version.load(context);
                }
                if (!version.isInstalled()) continue;
                Calendar installTime = version.getInstallTime();
                if (this.currentInstalled != null && (this.currentInstalled.getInstallTime() == null || installTime == null || !installTime.after(this.currentInstalled.getInstallTime()))) continue;
                this.currentInstalled = version;
            }
            if (this.currentInstalled != null) {
                RegistryUtil.PropertyMap versionProps = this.currentInstalled.getPackageProps();
                RegistryUtil.PropertyMap pckgProps = (RegistryUtil.PropertyMap)this.get("package");
                pckgProps.put("version", (Object)this.currentInstalled.getVersion());
                pckgProps.put("installed", (Object)this.currentInstalled.isInstalled());
                pckgProps.put("installTime", (Object)this.currentInstalled.getInstallTime());
                pckgProps.put("size", versionProps.get("size"));
                pckgProps.put("valid", versionProps.get("valid"));
            }
            this.setLoaded(true);
        }
    }

    @Override
    public void loadForItems(@Nonnull BeanContext context) throws IOException {
    }

    @Nullable
    public VersionNode getVersion(String versionKey) {
        Map<String, RegistryItem> items = Objects.requireNonNull(this.getItemsMap());
        return (VersionNode)items.get(versionKey);
    }

    @Nonnull
    public VersionNode addVersion(@Nonnull String registryNamespace, @Nonnull PackageId id) {
        Map<String, RegistryItem> items;
        VersionNode version;
        String versionKey = id.getVersionString();
        if (StringUtils.isBlank((CharSequence)versionKey)) {
            versionKey = "-";
        }
        if ((version = (VersionNode)(items = Objects.requireNonNull(this.getItemsMap())).get(versionKey)) == null) {
            version = new VersionNode(this, registryNamespace, id, versionKey);
            items.put(versionKey, version);
        }
        return version;
    }
}

