/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.jcrpckg.tree;

import com.composum.sling.core.pckgmgr.jcrpckg.tree.FolderItem;
import com.composum.sling.core.pckgmgr.jcrpckg.tree.JcrPackageItem;
import com.composum.sling.core.pckgmgr.jcrpckg.tree.TreeItem;
import com.composum.sling.core.pckgmgr.jcrpckg.util.PackageUtil;
import com.composum.sling.core.util.JsonUtil;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.JcrPackage;

public class TreeNode
extends ArrayList<TreeItem> {
    private final String path;
    private boolean isLeaf;

    public TreeNode(String path) {
        this.path = path;
    }

    public boolean addPackage(JcrPackage jcrPackage) throws RepositoryException {
        String groupUri = this.path.endsWith("/") ? this.path : this.path + "/";
        String groupPath = PackageUtil.getGroupPath(jcrPackage);
        String packageName = jcrPackage.getDefinition().get("name");
        String packagePath = groupPath + packageName + "/";
        if (packagePath.startsWith(groupUri)) {
            TreeItem item;
            if (packagePath.equals(groupUri)) {
                item = new JcrPackageItem(jcrPackage).versionAsName(true);
            } else if (groupPath.equals(groupUri)) {
                item = new FolderItem(StringUtils.removeEnd((String)packagePath, (String)"/"), packageName, "package");
            } else {
                int nextDelimiter;
                String name = groupPath.substring(this.path.length());
                if (name.startsWith("/")) {
                    name = name.substring(1);
                }
                if ((nextDelimiter = name.indexOf("/")) > 0) {
                    name = name.substring(0, nextDelimiter);
                }
                item = new FolderItem(groupUri + name, name);
            }
            if (!this.contains(item)) {
                this.add(item);
            }
            return false;
        }
        JcrPackageItem item = new JcrPackageItem(jcrPackage);
        if (this.path.equals(groupPath + item.getFilename())) {
            this.isLeaf = true;
            this.add(item);
            return true;
        }
        return false;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void sort() {
        Collections.sort(this, new TreeItemComparator());
    }

    public void toJson(JsonWriter writer) throws IOException, RepositoryException {
        if (this.isLeaf()) {
            ((TreeItem)this.get(0)).toJson(writer);
        } else {
            boolean containsVersions;
            int lastPathSegment = this.path.lastIndexOf("/");
            String name = this.path.substring(lastPathSegment + 1);
            if (StringUtils.isBlank((CharSequence)name)) {
                name = "Packages ";
            }
            String type = (containsVersions = this.stream().anyMatch(i -> i instanceof JcrPackageItem)) ? "package" : "folder";
            FolderItem myself = new FolderItem(this.path, name, type);
            writer.beginObject();
            JsonUtil.jsonMapEntries((JsonWriter)writer, (Map)myself);
            writer.name("children");
            writer.beginArray();
            for (TreeItem item : this) {
                item.toJson(writer);
            }
            writer.endArray();
            writer.endObject();
        }
    }

    public static class TreeItemComparator
    implements Comparator<TreeItem> {
        @Override
        public int compare(TreeItem o1, TreeItem o2) {
            if (o1 instanceof JcrPackageItem && o2 instanceof JcrPackageItem) {
                return ((JcrPackageItem)o1).compareTo((JcrPackageItem)o2);
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

