/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.jcrpckg.tree;

import com.composum.sling.core.pckgmgr.jcrpckg.tree.TreeItem;
import com.composum.sling.core.pckgmgr.jcrpckg.util.PackageUtil;
import com.composum.sling.core.pckgmgr.regpckg.util.VersionComparator;
import com.composum.sling.core.util.ResourceUtil;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.LinkedHashMap;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPackageItem
implements TreeItem {
    private static final Logger LOG = LoggerFactory.getLogger(JcrPackageItem.class);
    private final JcrPackage jcrPackage;
    private final JcrPackageDefinition definition;
    private boolean versionAsName;

    public JcrPackageItem(JcrPackage jcrPackage) throws RepositoryException {
        this.jcrPackage = jcrPackage;
        this.definition = jcrPackage.getDefinition();
    }

    public JcrPackageItem versionAsName(boolean versionAsName) {
        this.versionAsName = versionAsName;
        return this;
    }

    @Override
    public String getName() {
        return this.definition.get("name");
    }

    @Override
    public String getPath() {
        try {
            String name = this.getFilename();
            String groupPath = PackageUtil.getGroupPath(this.jcrPackage);
            String path = groupPath + name;
            return path;
        }
        catch (RepositoryException rex) {
            LOG.error(rex.getMessage(), (Throwable)rex);
            return "";
        }
    }

    public JcrPackageDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void toJson(JsonWriter writer) throws RepositoryException, IOException {
        String name = this.getFilename();
        String path = this.getPath();
        LinkedHashMap<String, Boolean> treeState = new LinkedHashMap<String, Boolean>();
        treeState.put("loaded", Boolean.TRUE);
        LinkedHashMap<String, Object> additionalAttributes = new LinkedHashMap<String, Object>();
        additionalAttributes.put("id", path);
        additionalAttributes.put("path", path);
        additionalAttributes.put("parent", ResourceUtil.getParent((String)path) + '/' + this.definition.get("name"));
        additionalAttributes.put("name", name);
        additionalAttributes.put("text", this.versionAsName ? StringUtils.defaultIfBlank((CharSequence)this.definition.get("version"), (CharSequence)"-") : name);
        additionalAttributes.put("type", this.versionAsName ? "version" : "package");
        additionalAttributes.put("state", treeState);
        additionalAttributes.put("file", this.getFilename());
        PackageUtil.toJson(writer, this.jcrPackage, additionalAttributes);
    }

    public String getFilename() {
        return PackageUtil.getFilename(this.jcrPackage);
    }

    public Calendar getLastModified() {
        Calendar lastModified = PackageUtil.getLastModified(this.jcrPackage);
        if (lastModified != null) {
            return lastModified;
        }
        return PackageUtil.getCreated(this.jcrPackage);
    }

    public boolean equals(Object other) {
        return other instanceof JcrPackageItem && this.getName().equals(((JcrPackageItem)other).getName()) && this.definition.get("version").equals(((JcrPackageItem)other).definition.get("version"));
    }

    public int hashCode() {
        return 31 * this.getName().hashCode() + this.definition.get("version").hashCode();
    }

    public int compareTo(JcrPackageItem o) {
        PackageId id1 = this.definition != null ? this.definition.getId() : null;
        PackageId id2 = o.getDefinition() != null ? o.getDefinition().getId() : null;
        CompareToBuilder builder = new CompareToBuilder();
        builder.append((Object)(id1 != null ? id1.getGroup() : id1), (Object)(id2 != null ? id2.getGroup() : id2));
        builder.append((Object)(id1 != null ? id1.getName() : id1), (Object)(id2 != null ? id2.getName() : id2));
        builder.append((Object)(id1 != null ? String.valueOf(id1.getVersion()) : ""), (Object)(id2 != null ? String.valueOf(id2.getVersion()) : ""), new VersionComparator().reversed());
        builder.append((Object)this.getName(), (Object)o.getName());
        builder.append((Object)this.getPath(), (Object)o.getPath());
        return builder.toComparison();
    }
}

