/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.jcrpckg;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.concurrent.JobFacade;
import com.composum.sling.core.concurrent.JobMonitor;
import com.composum.sling.core.concurrent.JobUtil;
import com.composum.sling.core.pckgmgr.Packages;
import com.composum.sling.core.pckgmgr.jcrpckg.tree.JcrPackageItem;
import com.composum.sling.core.pckgmgr.jcrpckg.tree.TreeNode;
import com.composum.sling.core.pckgmgr.jcrpckg.util.PackageProgressTracker;
import com.composum.sling.core.pckgmgr.jcrpckg.util.PackageUtil;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.composum.sling.core.pckgmgr.regpckg.tree.RegistryItem;
import com.composum.sling.core.pckgmgr.regpckg.tree.RegistryTree;
import com.composum.sling.core.pckgmgr.regpckg.util.RegistryUtil;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.servlet.Status;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.NodesConfiguration;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.fs.io.Archive;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageExistsException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.VaultPackage;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/packages/manager")
@Component(service={Servlet.class}, property={"service.description=Composum Nodes Package Servlet", "sling.servlet.paths=/bin/cpm/package", "sling.servlet.methods=GET", "sling.servlet.methods=POST", "sling.servlet.methods=PUT", "sling.servlet.methods=DELETE", "sling.auth.requirements=/bin/cpm/package"})
@Designate(ocd=Configuration.class)
public class PackageServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(PackageServlet.class);
    public static final String SERVICE_KEY = "nodes/packages/manager";
    public static final String SERVLET_PATH = "/bin/cpm/package";
    public static final String PARAM_GROUP = "group";
    public static final String PARAM_FORCE = "force";
    public static final String PARAM_REGISTRY = "registry";
    public static final String PARAM_MERGED = "merged";
    private volatile long jobIdleTimeout;
    public static final String ZIP_CONTENT_TYPE = "application/zip";
    public static final boolean AUTO_SAVE = true;
    @Reference
    private ServiceRestrictions restrictions;
    @Reference
    private NodesConfiguration nodesConfig;
    @Reference
    private JobManager jobManager;
    @Reference
    private Packaging packaging;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private volatile PackageRegistries packageRegistries;
    private BundleContext bundleContext;
    protected PackageOperationSet operations = new PackageOperationSet();

    protected PackageOperationSet getOperations() {
        return this.operations;
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Configuration configuration) {
        this.bundleContext = bundleContext;
        this.jobIdleTimeout = configuration.package_job_timeout();
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.list, new ListOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.tree, new TreeOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.query, new QueryOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.filterList, new ListFiltersOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.coverage, new CoverageOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.zip, Operation.download, new DownloadOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.html, Operation.download, new DownloadOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.cleanup, new CleanupOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.mode, new PackageManagerModeOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.registryTree, new RegistryTreeOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.registries, new RegistriesOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.registriesTree, new RegistriesTreeOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.thumbnail, new ThumbnailOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.service, new ServiceOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.create, new CreateOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.update, new UpdateOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.upload, new UploadOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.install, new InstallOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.uninstall, new UninstallOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.deploy, new ServiceOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.cleanupObsoleteVersions, new CleanupObsoleteVersionsOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.filterChange, new ChangeFilterOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.filterAdd, new AddFilterOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.filterRemove, new RemoveFilterOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.filterMoveUp, new MoveFilterOperation(true));
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.filterMoveDown, new MoveFilterOperation(false));
        this.operations.setOperation(ServletOperationSet.Method.PUT, Extension.json, Operation.update, new JsonUpdateOperation());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, Extension.json, Operation.delete, new DeleteOperation());
    }

    protected String getGroup(RequestParameterMap parameters) throws UnsupportedEncodingException {
        return this.getStringParameter(parameters, PARAM_GROUP);
    }

    protected String getName(RequestParameterMap parameters) throws UnsupportedEncodingException {
        return this.getStringParameter(parameters, "name");
    }

    protected String getStringParameter(RequestParameterMap parameters, String parameterName) throws UnsupportedEncodingException {
        RequestParameter parameter = parameters.getValue(parameterName);
        String value = "";
        if (parameter != null) {
            value = parameter.getString("UTF-8");
        }
        return value;
    }

    @Nonnull
    protected List<String> getArrayParameter(RequestParameterMap parameters, String parameterName) throws UnsupportedEncodingException {
        RequestParameter[] parameterValues = parameters.getValues(parameterName);
        ArrayList<String> values = new ArrayList<String>();
        if (parameterValues != null && parameterValues.length > 0) {
            for (RequestParameter parameterValue : parameterValues) {
                values.add(parameterValue.getString("UTF-8"));
            }
        }
        return values;
    }

    protected static void jsonAnswer(JsonWriter writer, String operation, String status, JcrPackageManager pckgMgr, JcrPackage jcrPackage) throws IOException, RepositoryException {
        writer.beginObject();
        writer.name("operation").value(operation);
        writer.name("status").value(status);
        writer.name("path").value(PackageUtil.getPackagePath(pckgMgr, jcrPackage));
        writer.name("package");
        PackageUtil.toJson(writer, jcrPackage, null);
        writer.endObject();
    }

    protected static void jsonAnswer(JsonWriter writer, String operation, String status, String namespace, PackageId packageId) throws IOException, RepositoryException {
        writer.beginObject();
        writer.name("operation").value(operation);
        writer.name("status").value(status);
        writer.name("path").value(RegistryUtil.toPath(namespace, packageId));
        writer.name("package");
        RegistryUtil.toJson(writer, namespace, packageId);
        writer.endObject();
    }

    protected static void fromJson(JsonReader reader, JcrPackage jcrPackage) throws RepositoryException, IOException {
        reader.beginObject();
        block6: while (reader.hasNext() && reader.peek() == JsonToken.NAME) {
            String name;
            switch (name = reader.nextName()) {
                case "definition": {
                    PackageServlet.fromJson(reader, jcrPackage.getDefinition());
                    continue block6;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    protected static void fromJson(JsonReader reader, JcrPackageDefinition definition) throws IOException {
        reader.beginObject();
        block10: while (reader.hasNext() && reader.peek() == JsonToken.NAME) {
            String name;
            switch (name = reader.nextName()) {
                case "filter": {
                    DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
                    PathFilterSet pathFilterSet = new PathFilterSet();
                    filter.add(pathFilterSet);
                    continue block10;
                }
            }
            switch (reader.peek()) {
                case STRING: {
                    String strVal = reader.nextString();
                    definition.set(name, strVal, true);
                    continue block10;
                }
                case BOOLEAN: {
                    boolean boolVal = reader.nextBoolean();
                    definition.set(name, boolVal, true);
                    continue block10;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    @ObjectClassDefinition(name="Composum Nodes Package Servlet")
    public static @interface Configuration {
        @AttributeDefinition(name="package job timeout", description="Time in milliseconds a package job can be idle")
        public long package_job_timeout() default 60000L;
    }

    private class ThumbnailOperation
    implements ServletOperation {
        private ThumbnailOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            RegisteredPackage pckg;
            Archive archive;
            Archive.Entry thumbnailEntry;
            Pair<String, RegisteredPackage> pckgEntry;
            String path;
            PackageRegistries.Registries registries = PackageServlet.this.packageRegistries.getRegistries(request.getResourceResolver());
            Pair<String, PackageId> location = registries.resolve(path = RegistryUtil.requestPath(request));
            Pair<String, RegisteredPackage> pair = pckgEntry = location != null ? registries.open((PackageId)location.getRight()) : null;
            if (pckgEntry != null && (thumbnailEntry = (archive = (pckg = (RegisteredPackage)pckgEntry.getRight()).getPackage().getArchive()).getEntry("META-INF/vault/definition/thumbnail.png")) != null) {
                InputStream stream = archive.openInputStream(thumbnailEntry);
                response.setContentType("image/png");
                IOUtils.copy((InputStream)stream, (OutputStream)response.getOutputStream());
                return;
            }
            response.sendError(404, "Thumbnail not found for " + PackageUtil.getPath(request));
        }
    }

    protected class MoveFilterOperation
    implements ServletOperation {
        public final boolean up;

        public MoveFilterOperation(boolean up) {
            this.up = up;
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            FilterRequest filterRequest = new FilterRequest(request, (Resource)resource);
            int index = filterRequest.index;
            if (index >= 0 && index < filterRequest.filters.size()) {
                if (this.up) {
                    if (index > 0) {
                        this.move(filterRequest, index - 1);
                    }
                } else if (index < filterRequest.filters.size() - 1) {
                    this.move(filterRequest, index + 1);
                }
                response.setStatus(200);
                response.setContentLength(0);
            } else {
                response.sendError(400, "invalid filter index '" + index + "'");
            }
        }

        protected void move(FilterRequest filterRequest, int newIndex) {
            PathFilterSet filter = filterRequest.filters.remove(filterRequest.index);
            filterRequest.filters.add(newIndex, filter);
            filterRequest.definition.setFilter(filterRequest.workspaceFilter, true);
        }
    }

    protected class RemoveFilterOperation
    implements ServletOperation {
        protected RemoveFilterOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            FilterRequest filterRequest = new FilterRequest(request, (Resource)resource);
            int index = filterRequest.index;
            if (index >= 0 && index < filterRequest.filters.size()) {
                filterRequest.filters.remove(index);
                filterRequest.definition.setFilter(filterRequest.workspaceFilter, true);
                PackageUtil.setLastModified(filterRequest.definition);
                response.setStatus(200);
                response.setContentLength(0);
            } else {
                response.sendError(400, "invalid filter index '" + index + "'");
            }
        }
    }

    protected class AddFilterOperation
    implements ServletOperation {
        protected AddFilterOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            FilterRequest filterRequest = new FilterRequest(request, (Resource)resource);
            if (filterRequest.filter != null) {
                int index = filterRequest.index;
                if (index < 0 || index > filterRequest.filters.size()) {
                    index = filterRequest.filters.size();
                }
                filterRequest.filters.add(index, filterRequest.filter);
                filterRequest.definition.setFilter(filterRequest.workspaceFilter, true);
                PackageUtil.setLastModified(filterRequest.definition);
                response.setStatus(200);
                response.setContentLength(0);
            } else {
                response.sendError(400, "invalid filter");
            }
        }
    }

    protected class ChangeFilterOperation
    implements ServletOperation {
        protected ChangeFilterOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            FilterRequest filterRequest = new FilterRequest(request, (Resource)resource);
            if (filterRequest.filter != null) {
                int index = filterRequest.index;
                if (index >= 0 && index < filterRequest.filters.size()) {
                    filterRequest.filters.set(index, filterRequest.filter);
                    filterRequest.definition.setFilter(filterRequest.workspaceFilter, true);
                    PackageUtil.setLastModified(filterRequest.definition);
                    response.setStatus(200);
                    response.setContentLength(0);
                } else {
                    response.sendError(400, "invalid filter index '" + index + "'");
                }
            } else {
                response.sendError(400, "invalid filter");
            }
        }
    }

    protected class FilterRequest {
        public final SlingHttpServletRequest request;
        public final JcrPackageManager manager;
        public final JcrPackage jcrPackage;
        public final JcrPackageDefinition definition;
        public final MetaInf metaInf;
        public final WorkspaceFilter workspaceFilter;
        public final List<PathFilterSet> filters;
        public final int index;
        public final PathFilterSet filter;

        public FilterRequest(SlingHttpServletRequest request, Resource resource) throws RepositoryException {
            this.request = request;
            this.manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            this.jcrPackage = PackageUtil.getJcrPackage(this.manager, resource);
            this.definition = this.jcrPackage.getDefinition();
            this.metaInf = this.definition.getMetaInf();
            this.workspaceFilter = this.metaInf.getFilter();
            this.filters = this.workspaceFilter.getFilterSets();
            this.index = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"index", (Integer)-1);
            String root = XSS.filter((String)request.getParameter("root"));
            if (StringUtils.isNotBlank((CharSequence)root)) {
                this.filter = new PathFilterSet(root);
                String importMode = XSS.filter((String)request.getParameter("importMode"));
                if (StringUtils.isNotBlank((CharSequence)importMode)) {
                    ImportMode mode = ImportMode.valueOf((String)importMode.toUpperCase());
                    this.filter.setImportMode(mode);
                }
                String[] ruleTypes = XSS.filter((String[])request.getParameterValues("ruleType"));
                String[] ruleExpressions = XSS.filter((String[])request.getParameterValues("ruleExpression"));
                if (ruleTypes != null && ruleExpressions != null && ruleTypes.length == ruleExpressions.length) {
                    for (int i = 0; i < ruleTypes.length; ++i) {
                        try {
                            if (!StringUtils.isNotBlank((CharSequence)ruleExpressions[i])) continue;
                            switch (ruleTypes[i]) {
                                case "include": {
                                    this.filter.addInclude((Filter)new DefaultPathFilter(ruleExpressions[i]));
                                    break;
                                }
                                case "exclude": {
                                    this.filter.addExclude((Filter)new DefaultPathFilter(ruleExpressions[i]));
                                }
                            }
                            continue;
                        }
                        catch (Exception ex) {
                            LOG.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
            } else {
                this.filter = null;
            }
        }
    }

    protected class ListFiltersOperation
    implements ServletOperation {
        protected ListFiltersOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            String path;
            List<Object> filters = Collections.emptyList();
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            if (jcrPackage != null) {
                try {
                    filters = PackageUtil.getFilterList(jcrPackage.getDefinition());
                }
                finally {
                    jcrPackage.close();
                }
            }
            PackageRegistries.Registries registries = PackageServlet.this.packageRegistries.getRegistries(request.getResourceResolver());
            Pair<String, PackageId> pair = registries.resolve(path = RegistryUtil.requestPath(request));
            Pair<String, RegisteredPackage> pckgEntry = pair != null ? registries.open((PackageId)pair.getRight()) : null;
            try (RegisteredPackage pckg = pckgEntry != null ? (RegisteredPackage)pckgEntry.getRight() : null;){
                if (pckg != null) {
                    WorkspaceFilter workspaceFilter = pckg.getWorkspaceFilter();
                    if (workspaceFilter != null) {
                        filters = workspaceFilter.getFilterSets();
                    } else {
                        LOG.error("BUG: WorkspaceFilter is null but promised to be not null for package {}.", pckgEntry.getLeft());
                    }
                }
            }
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            writer.beginArray();
            for (PathFilterSet pathFilterSet : filters) {
                List filterRules;
                writer.beginObject();
                writer.name("root").value(pathFilterSet.getRoot());
                ImportMode importMode = pathFilterSet.getImportMode();
                if (importMode != null) {
                    writer.name("importMode").value(importMode.name());
                }
                if (!(filterRules = pathFilterSet.getEntries()).isEmpty()) {
                    writer.name("rules").beginArray();
                    for (FilterSet.Entry entry : filterRules) {
                        writer.beginObject();
                        writer.name("type").value(entry.isInclude() ? "include" : "exclude");
                        writer.name("pattern").value(((DefaultPathFilter)entry.getFilter()).getPattern());
                        writer.endObject();
                    }
                    writer.endArray();
                }
                writer.endObject();
            }
            writer.endArray();
        }
    }

    protected class CoverageOperation
    implements ServletOperation {
        protected CoverageOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            Session session = RequestUtil.getSession((SlingHttpServletRequest)request);
            PackageProgressTracker.JsonTracking tracker = new PackageProgressTracker.JsonTracking(response, null);
            ((PackageProgressTracker)tracker).writePrologue();
            if (jcrPackage != null) {
                PackageUtil.getCoverage(jcrPackage.getDefinition(), session, tracker);
            } else {
                Pair<String, RegisteredPackage> pckgEntry;
                String path;
                PackageRegistries.Registries registries = PackageServlet.this.packageRegistries.getRegistries(request.getResourceResolver());
                Pair<String, PackageId> location = registries.resolve(path = RegistryUtil.requestPath(request));
                Pair<String, RegisteredPackage> pair = pckgEntry = location != null ? registries.open((PackageId)location.getRight()) : null;
                if (pckgEntry != null) {
                    WorkspaceFilter filter = ((RegisteredPackage)pckgEntry.getRight()).getWorkspaceFilter();
                    try {
                        filter.dumpCoverage(session, (ProgressTrackerListener)tracker, false);
                    }
                    catch (RepositoryException rex) {
                        LOG.error(rex.getMessage(), (Throwable)rex);
                        tracker.onError(ProgressTrackerListener.Mode.TEXT, "exception thrown", (Exception)((Object)rex));
                    }
                }
            }
            ((PackageProgressTracker)tracker).writeEpilogue();
        }
    }

    protected class ServiceOperation
    extends InstallOperation {
        protected ServiceOperation() {
        }

        @Override
        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            RequestParameterMap parameters = request.getRequestParameterMap();
            RequestParameter cmd = parameters.getValue("cmd");
            if (cmd != null && !StringUtils.isBlank((CharSequence)cmd.getString())) {
                switch (cmd.getString()) {
                    case "ls": {
                        new LsCommand().doCommand(request, response, parameters);
                        break;
                    }
                    case "rm": {
                        new RmCommand().doCommand(request, response, parameters);
                        break;
                    }
                    case "build": {
                        new BuildCommand().doCommand(request, response, parameters);
                        break;
                    }
                    case "uninst": {
                        new UninstCommand().doCommand(request, response, parameters);
                        break;
                    }
                    default: {
                        LOG.warn("unsupported command '{}' received. will ignore it.", (Object)cmd);
                        break;
                    }
                }
            } else {
                RequestParameter file = parameters.getValue("file");
                if (file != null) {
                    InputStream input = file.getInputStream();
                    boolean force = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)PackageServlet.PARAM_FORCE, (Boolean)true);
                    JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                    JcrPackage jcrPackage = manager.upload(input, force);
                    this.installPackage(request, response, manager, jcrPackage);
                } else {
                    response.sendError(400, "no package file accessible");
                }
            }
        }

        @Override
        protected void installationDone(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, JcrPackageManager manager, JcrPackage jcrPackage, JobMonitor jobMonitor) throws RepositoryException, IOException {
            response.setStatus(200);
            try (PrintWriter writer = response.getWriter();){
                ((Writer)writer).append("<repo>");
                ((Writer)writer).append("<response>");
                ((Writer)writer).append("<data>");
                ((Writer)writer).append(PackageUtil.packageToXMLResponse(jcrPackage));
                ((Writer)writer).append("</data>");
                if (jobMonitor.succeeded()) {
                    ((Writer)writer).append(this.createStatusElement("200", "ok"));
                } else {
                    JobFacade jobFacade = jobMonitor.getJob();
                    String msg = jobFacade != null ? jobFacade.getResultMessage() : "no job found";
                    ((Writer)writer).append(this.createStatusElement("500", msg));
                }
                ((Writer)writer).append("</response>");
                ((Writer)writer).append("</repo>");
            }
        }

        private String createRequestElement(String cmd, String name, String group) {
            return "<request>" + this.createParameterElement("cmd", cmd) + (StringUtils.isBlank((CharSequence)name) ? "" : this.createParameterElement("name", name)) + (StringUtils.isBlank((CharSequence)group) ? "" : this.createParameterElement(PackageServlet.PARAM_GROUP, group)) + "</request>";
        }

        private String createParameterElement(String name, String value) {
            return "<param name=\"" + name + "\" value=\"" + value + "\"/>";
        }

        private String createResponseElement(String code, String message) {
            return "<response>" + this.createStatusElement(code, message) + "</response>";
        }

        private String createStatusElement(String code, String message) {
            return "<status code=\"" + code + "\">" + message + "</status>";
        }

        class UninstCommand
        extends BuildUninstCommand {
            UninstCommand() {
            }

            @Override
            String getCommand() {
                return "uninst";
            }

            @Override
            String getOperation() {
                return "uninstall";
            }
        }

        class BuildCommand
        extends BuildUninstCommand {
            BuildCommand() {
            }

            @Override
            String getCommand() {
                return "build";
            }

            @Override
            String getOperation() {
                return "assemble";
            }
        }

        abstract class BuildUninstCommand
        extends ServiceCommand {
            BuildUninstCommand() {
            }

            abstract String getCommand();

            abstract String getOperation();

            @Override
            void doCommand(SlingHttpServletRequest request, SlingHttpServletResponse response, RequestParameterMap parameters) throws RepositoryException, IOException {
                ResourceResolver resolver = request.getResourceResolver();
                Session session = (Session)resolver.adaptTo(Session.class);
                String name = PackageServlet.this.getName(parameters);
                String group = PackageServlet.this.getGroup(parameters);
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, group, name);
                if (jcrPackage != null) {
                    String root;
                    Node node = jcrPackage.getNode();
                    String path = node != null ? jcrPackage.getNode().getPath() : PackageUtil.getPackagePath(manager, jcrPackage);
                    if (path.startsWith(root = manager.getPackageRoot().getPath())) {
                        path = path.substring(root.length());
                    }
                    HashMap<String, String> jobProperties = new HashMap<String, String>();
                    jobProperties.put("reference", path);
                    jobProperties.put("operation", this.getOperation());
                    if (session != null) {
                        jobProperties.put("userid", session.getUserID());
                    }
                    JobUtil.buildOutfileName(jobProperties);
                    Job job = PackageServlet.this.jobManager.addJob("com/composum/sling/core/pckgmgr/PackageJobExecutor", jobProperties);
                    JobMonitor.IsDone isDone = new JobMonitor.IsDone(PackageServlet.this.jobManager, resolver, job.getId(), PackageServlet.this.jobIdleTimeout);
                    if (isDone.call().booleanValue()) {
                        response.setStatus(200);
                        try (PrintWriter writer = response.getWriter();){
                            ((Writer)writer).append("<repo>");
                            ((Writer)writer).append(ServiceOperation.this.createRequestElement(this.getCommand(), name, group));
                            if (isDone.succeeded()) {
                                ((Writer)writer).append(ServiceOperation.this.createResponseElement("200", "ok"));
                            } else {
                                ((Writer)writer).append(ServiceOperation.this.createResponseElement("500", this.getOperation() + " does not succeed"));
                            }
                            ((Writer)writer).append("</repo>");
                        }
                    } else {
                        response.setStatus(200);
                        try (PrintWriter writer = response.getWriter();){
                            ((Writer)writer).append("<repo>");
                            ((Writer)writer).append(ServiceOperation.this.createRequestElement(this.getCommand(), name, group));
                            ((Writer)writer).append(ServiceOperation.this.createResponseElement("500", "nok"));
                            ((Writer)writer).append("</repo>");
                        }
                    }
                } else {
                    response.setStatus(200);
                    try (PrintWriter writer = response.getWriter();){
                        ((Writer)writer).append("<repo>");
                        ((Writer)writer).append(ServiceOperation.this.createRequestElement(this.getCommand(), name, group));
                        ((Writer)writer).append(ServiceOperation.this.createResponseElement("500", "Package '" + group + ":" + name + "' does not exist"));
                        ((Writer)writer).append("</repo>");
                    }
                }
            }
        }

        class RmCommand
        extends ServiceCommand {
            RmCommand() {
            }

            @Override
            void doCommand(SlingHttpServletRequest request, SlingHttpServletResponse response, RequestParameterMap parameters) throws RepositoryException, IOException {
                String name = PackageServlet.this.getName(parameters);
                String group = PackageServlet.this.getGroup(parameters);
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                List jcrPackages = manager.listPackages();
                boolean found = false;
                for (JcrPackage jcrPackage : jcrPackages) {
                    String packageName = jcrPackage.getDefinition().get("name");
                    String packageGroup = jcrPackage.getDefinition().get(PackageServlet.PARAM_GROUP);
                    if (StringUtils.isBlank((CharSequence)packageName) || !packageName.equals(name)) continue;
                    if (!StringUtils.isBlank((CharSequence)group) && group.equals(packageGroup)) {
                        manager.remove(jcrPackage);
                        found = true;
                        break;
                    }
                    if (!StringUtils.isBlank((CharSequence)group) || !StringUtils.isBlank((CharSequence)packageGroup)) continue;
                    manager.remove(jcrPackage);
                    found = true;
                    break;
                }
                response.setStatus(200);
                try (PrintWriter writer = response.getWriter();){
                    ((Writer)writer).append("<repo>");
                    ((Writer)writer).append(ServiceOperation.this.createRequestElement("rm", name, group));
                    if (found) {
                        ((Writer)writer).append(ServiceOperation.this.createResponseElement("200", "ok"));
                    } else {
                        ((Writer)writer).append(ServiceOperation.this.createResponseElement("500", "Package '" + group + ":" + name + "' does not exist."));
                    }
                    ((Writer)writer).append("</repo>");
                }
            }
        }

        class LsCommand
        extends ServiceCommand {
            LsCommand() {
            }

            @Override
            void doCommand(SlingHttpServletRequest request, SlingHttpServletResponse response, RequestParameterMap parameters) throws RepositoryException, IOException {
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                List jcrPackages = manager.listPackages();
                response.setStatus(200);
                try (PrintWriter writer = response.getWriter();){
                    ((Writer)writer).append("<repo>");
                    ((Writer)writer).append(ServiceOperation.this.createRequestElement("ls", "", ""));
                    ((Writer)writer).append("<response>");
                    ((Writer)writer).append("<data>");
                    ((Writer)writer).append("<packages>");
                    for (JcrPackage jcrPackage : jcrPackages) {
                        ((Writer)writer).append(PackageUtil.packageToXMLResponse(jcrPackage));
                    }
                    ((Writer)writer).append("</packages>");
                    ((Writer)writer).append("</data>");
                    ((Writer)writer).append(ServiceOperation.this.createStatusElement("200", "ok"));
                    ((Writer)writer).append("</response>");
                    ((Writer)writer).append("</repo>");
                }
            }
        }

        abstract class ServiceCommand {
            ServiceCommand() {
            }

            abstract void doCommand(SlingHttpServletRequest var1, SlingHttpServletResponse var2, RequestParameterMap var3) throws RepositoryException, IOException;
        }
    }

    protected class CleanupObsoleteVersionsOperation
    implements ServletOperation {
        protected CleanupObsoleteVersionsOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            Status status = new Status(request, response, LOG);
            String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            List<String> cleanupVersions = PackageServlet.this.getArrayParameter(request.getRequestParameterMap(), "cleanupVersion");
            if (StringUtils.isNotBlank((CharSequence)path) && cleanupVersions != null && !cleanupVersions.isEmpty()) {
                String currentPath = null;
                try {
                    PackageRegistries.Registries registries = PackageServlet.this.packageRegistries.getRegistries(request.getResourceResolver());
                    Map data = status.data("result");
                    data.put("path", path);
                    ArrayList<String> deletedPaths = new ArrayList<String>();
                    data.put("deletedPaths", deletedPaths);
                    Iterator<String> iterator = cleanupVersions.iterator();
                    while (iterator.hasNext()) {
                        Pair<String, PackageId> resolved;
                        String cleanupVersion;
                        currentPath = cleanupVersion = iterator.next();
                        boolean found = false;
                        while (null != (resolved = registries.resolve(cleanupVersion))) {
                            registries.getRegistry((String)resolved.getKey()).remove((PackageId)resolved.getValue());
                            deletedPaths.add(cleanupVersion);
                            found = true;
                        }
                        if (found) continue;
                        status.error("Could not find package {}", new Object[]{cleanupVersion});
                    }
                }
                catch (Exception e) {
                    status.error("Problem deleting obsolete versions; currentPath=" + currentPath, (Throwable)e);
                }
            } else {
                status.error("path and packageId(s) expected", new Object[0]);
            }
            status.sendJson();
        }
    }

    protected class UninstallOperation
    implements ServletOperation {
        protected UninstallOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            this.uninstallPackage(request, response, manager, jcrPackage);
        }

        protected void uninstallPackage(SlingHttpServletRequest request, SlingHttpServletResponse response, JcrPackageManager manager, JcrPackage jcrPackage) throws RepositoryException, IOException {
            String root;
            ResourceResolver resolver = request.getResourceResolver();
            Session session = (Session)resolver.adaptTo(Session.class);
            Node node = jcrPackage.getNode();
            String path = node != null ? jcrPackage.getNode().getPath() : PackageUtil.getPackagePath(manager, jcrPackage);
            if (path.startsWith(root = manager.getPackageRoot().getPath())) {
                path = path.substring(root.length());
            }
            HashMap<String, String> jobProperties = new HashMap<String, String>();
            jobProperties.put("reference", path);
            jobProperties.put("operation", "uninstall");
            if (session != null) {
                jobProperties.put("userid", session.getUserID());
            }
            JobUtil.buildOutfileName(jobProperties);
            Job job = PackageServlet.this.jobManager.addJob("com/composum/sling/core/pckgmgr/PackageJobExecutor", jobProperties);
            JobMonitor.IsDone isDone = new JobMonitor.IsDone(PackageServlet.this.jobManager, resolver, job.getId(), PackageServlet.this.jobIdleTimeout);
            if (isDone.call().booleanValue()) {
                this.uninstallationDone(request, response, manager, jcrPackage, (JobMonitor)isDone);
            } else {
                response.sendError(500, "Package uninstall not started!");
            }
        }

        protected void uninstallationDone(SlingHttpServletRequest request, SlingHttpServletResponse response, JcrPackageManager manager, JcrPackage jcrPackage, JobMonitor jobMonitor) throws RepositoryException, IOException {
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            PackageServlet.jsonAnswer(writer, "uninstallation", "done", manager, jcrPackage);
        }
    }

    protected class InstallOperation
    implements ServletOperation {
        protected InstallOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            this.installPackage(request, response, manager, jcrPackage);
        }

        protected void installPackage(SlingHttpServletRequest request, SlingHttpServletResponse response, JcrPackageManager manager, JcrPackage jcrPackage) throws RepositoryException, IOException {
            String root;
            ResourceResolver resolver = request.getResourceResolver();
            Session session = (Session)resolver.adaptTo(Session.class);
            Node node = jcrPackage.getNode();
            String path = node != null ? jcrPackage.getNode().getPath() : PackageUtil.getPackagePath(manager, jcrPackage);
            if (path.startsWith(root = manager.getPackageRoot().getPath())) {
                path = path.substring(root.length());
            }
            HashMap<String, String> jobProperties = new HashMap<String, String>();
            jobProperties.put("reference", path);
            jobProperties.put("operation", "install");
            if (session != null) {
                jobProperties.put("userid", session.getUserID());
            }
            JobUtil.buildOutfileName(jobProperties);
            Job job = PackageServlet.this.jobManager.addJob("com/composum/sling/core/pckgmgr/PackageJobExecutor", jobProperties);
            JobMonitor.IsDone isDone = new JobMonitor.IsDone(PackageServlet.this.jobManager, resolver, job.getId(), PackageServlet.this.jobIdleTimeout);
            if (isDone.call().booleanValue()) {
                this.installationDone(request, response, manager, jcrPackage, (JobMonitor)isDone);
            } else {
                LOG.error("Job was not yet executed: {}", (Object)job);
                response.sendError(500, "Package install not started!");
            }
        }

        protected void installationDone(SlingHttpServletRequest request, SlingHttpServletResponse response, JcrPackageManager manager, JcrPackage jcrPackage, JobMonitor jobMonitor) throws RepositoryException, IOException {
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            PackageServlet.jsonAnswer(writer, "installation", "done", manager, jcrPackage);
        }
    }

    protected class CleanupOperation
    implements ServletOperation {
        protected CleanupOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            LOG.warn("package service cleanup...");
            JsonWriter writer = new JsonWriter((Writer)response.getWriter());
            writer.beginObject();
            writer.name("removedJobs").beginArray();
            for (Job job : PackageServlet.this.jobManager.findJobs(JobManager.QueryType.ALL, "com/composum/sling/core/pckgmgr/PackageJobExecutor", 0L, new Map[0])) {
                String created = new SimpleDateFormat("yyyy-MM-DD HH:mm:ss").format(job.getCreated().getTime());
                LOG.warn("package service cleanup: remove job: {}, {}, {}, '{}', {}, {}", new Object[]{job.getId(), job.getTopic(), created, job.getResultMessage(), job.getRetryCount(), job.getQueueName()});
                writer.beginObject();
                writer.name("id").value(job.getId());
                writer.name("topic").value(job.getTopic());
                writer.name("created").value(created);
                writer.name("result").value(job.getResultMessage());
                writer.name("retryCount").value((long)job.getRetryCount());
                writer.name("queue").value(job.getQueueName());
                writer.endObject();
                PackageServlet.this.jobManager.removeJobById(job.getId());
            }
            writer.endArray();
            LOG.warn("package service cleanup ends.");
        }
    }

    protected class UploadOperation
    implements ServletOperation {
        protected UploadOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            boolean force = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)PackageServlet.PARAM_FORCE, (Boolean)false);
            String namespace = request.getParameter(PackageServlet.PARAM_REGISTRY);
            boolean merged = PackageServlet.PARAM_MERGED.equals(request.getParameter(PackageServlet.PARAM_MERGED));
            RequestParameter file = request.getRequestParameter("file");
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            try (InputStream input = file != null ? file.getInputStream() : null;){
                if (input != null) {
                    if (StringUtils.isBlank((CharSequence)namespace)) {
                        JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                        JcrPackage jcrPackage = manager.upload(input, force);
                        PackageServlet.jsonAnswer(writer, "upload", "successful", manager, jcrPackage);
                    } else {
                        PackageRegistries.Registries registries = PackageServlet.this.packageRegistries.getRegistries(request.getResourceResolver());
                        PackageRegistry registry = registries.getRegistry(namespace);
                        if (registry != null) {
                            PackageId packageId = registry.register(input, force);
                            PackageServlet.jsonAnswer(writer, "upload", "successful", merged ? null : namespace, packageId);
                        } else {
                            response.sendError(400, "unknown registry " + registry);
                        }
                    }
                } else {
                    response.sendError(400, "no package file accessible");
                }
            }
            catch (PackageExistsException e) {
                response.sendError(400, "package exists already: " + e.getId());
            }
        }
    }

    protected class DownloadOperation
    implements ServletOperation {
        protected DownloadOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            boolean delivered = jcrPackage != null ? this.deliverJcrPackage(response, jcrPackage) : this.deliverRegistryPackage(request, response, manager);
            if (!delivered) {
                response.sendError(400, PackageUtil.getPath(request) + " can not be found in the repository");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean deliverJcrPackage(@Nonnull SlingHttpServletResponse response, @Nonnull JcrPackage jcrPackage) throws RepositoryException, IOException {
            Binary binary = null;
            InputStream stream = null;
            boolean delivered = false;
            try {
                Property data = jcrPackage.getData();
                if (data != null && (binary = data.getBinary()) != null && (stream = binary.getStream()) != null) {
                    JcrPackageItem item = new JcrPackageItem(jcrPackage);
                    response.setHeader("Content-Disposition", "inline; filename=" + item.getFilename());
                    Calendar lastModified = item.getLastModified();
                    if (lastModified != null) {
                        response.setDateHeader("Last-Modified", lastModified.getTimeInMillis());
                    }
                    response.setContentType(PackageServlet.ZIP_CONTENT_TYPE);
                    if (jcrPackage.getSize() > 0L) {
                        response.setContentLength((int)jcrPackage.getSize());
                    }
                    ServletOutputStream output = response.getOutputStream();
                    IOUtils.copy((InputStream)stream, (OutputStream)output);
                    delivered = true;
                }
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                if (binary != null) {
                    binary.dispose();
                }
                jcrPackage.close();
            }
            return delivered;
        }

        protected boolean deliverRegistryPackage(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, @Nonnull JcrPackageManager manager) throws IOException, RepositoryException {
            boolean delivered;
            block23: {
                String path;
                PackageRegistries.Registries registries = PackageServlet.this.packageRegistries.getRegistries(request.getResourceResolver());
                Pair<String, PackageId> location = registries.resolve(path = RegistryUtil.requestPath(request));
                Pair<String, RegisteredPackage> pckgEntry = location != null ? registries.open((PackageId)location.getRight()) : null;
                try (RegisteredPackage pckg = pckgEntry != null ? (RegisteredPackage)pckgEntry.getRight() : null;
                     VaultPackage vaultPckg = pckg != null ? pckg.getPackage() : null;){
                    if (vaultPckg != null && vaultPckg.getFile() != null && vaultPckg.getFile().canRead()) {
                        File file = vaultPckg.getFile();
                        response.setHeader("Content-Disposition", "inline; filename=" + RegistryUtil.getFilename((PackageId)location.getRight()));
                        response.setContentType(PackageServlet.ZIP_CONTENT_TYPE);
                        Calendar lastModified = RegistryUtil.readPackagePropertyDate(vaultPckg.getProperties().getLastModified(), vaultPckg.getProperties().getProperty("lastModified"));
                        if (lastModified == null) {
                            lastModified = RegistryUtil.readPackagePropertyDate(vaultPckg.getProperties().getCreated(), vaultPckg.getProperties().getProperty("created"));
                        }
                        if (lastModified != null) {
                            response.setDateHeader("Last-Modified", lastModified.getTimeInMillis());
                        }
                        response.setContentLength((int)file.length());
                        ServletOutputStream output = response.getOutputStream();
                        try (FileInputStream stream = new FileInputStream(file);){
                            IOUtils.copy((InputStream)stream, (OutputStream)output);
                        }
                        delivered = true;
                        break block23;
                    }
                    String pathNoNs = RegistryUtil.pathWithoutNamespace(path);
                    JcrPackage jcrPackage = manager.open(pckg.getId());
                    if (jcrPackage != null) {
                        delivered = this.deliverJcrPackage(response, jcrPackage);
                    } else {
                        LOG.warn("Bug: Could not download package at {}", (Object)path);
                        delivered = false;
                    }
                }
            }
            return delivered;
        }
    }

    protected class DeleteOperation
    implements ServletOperation {
        protected DeleteOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            String deletedPath = request.getRequestPathInfo().getSuffix();
            String namespace = RegistryUtil.namespace(deletedPath);
            if (StringUtils.isBlank((CharSequence)namespace) && Packages.getMode(request) != Packages.Mode.regpckg) {
                this.deleteJcrPackage(request, response, resource);
            } else {
                Pair<String, PackageId> location;
                PackageRegistries.Registries registries = PackageServlet.this.packageRegistries.getRegistries(request.getResourceResolver());
                boolean removed = false;
                while (null != (location = registries.resolve(deletedPath))) {
                    PackageRegistry registry = registries.getRegistry((String)location.getLeft());
                    JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                    try {
                        registry.remove((PackageId)location.getRight());
                        PackageServlet.jsonAnswer(writer, "delete", "successful", namespace, (PackageId)location.getRight());
                        removed = true;
                    }
                    catch (ClassCastException | NoSuchPackageException e) {
                        LOG.error("Error deleting {}", (Object)deletedPath, (Object)e);
                    }
                }
                if (!removed) {
                    LOG.warn("Registry {} : could not find requested package {}", (Object)namespace, (Object)deletedPath);
                    response.sendError(400, deletedPath + " can not be found or deleted in the registries.");
                }
            }
        }

        private void deleteJcrPackage(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            if (jcrPackage != null) {
                manager.remove(jcrPackage);
                JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                PackageServlet.jsonAnswer(writer, "delete", "successful", manager, jcrPackage);
            } else {
                LOG.warn("Package not found: {}", (Object)PackageUtil.getPath(request));
                response.sendError(404, "Package not found: " + PackageUtil.getPath(request));
            }
        }
    }

    protected class JsonUpdateOperation
    extends UpdateOperation {
        protected JsonUpdateOperation() {
        }

        @Override
        protected Map<String, Object> getParameters(SlingHttpServletRequest request) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));
            reader.setLenient(true);
            reader.beginObject();
            while (reader.peek() != JsonToken.END_OBJECT) {
                String key = reader.nextName();
                PackageUtil.DefinitionSetter setter = PackageUtil.DEFINITION_SETTERS.get(key);
                if (setter != null) {
                    result.put(key, setter.get(reader));
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            reader.close();
            return result;
        }
    }

    protected class UpdateOperation
    implements ServletOperation {
        protected UpdateOperation() {
        }

        protected Map<String, Object> getParameters(SlingHttpServletRequest request) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            RequestParameterMap parameters = request.getRequestParameterMap();
            for (Map.Entry parameter : parameters.entrySet()) {
                String[] value;
                String key = (String)parameter.getKey();
                RequestParameter[] param = (RequestParameter[])parameter.getValue();
                if (param.length > 1) {
                    String[] values = new String[param.length];
                    for (int i = 0; i < param.length; ++i) {
                        values[i] = XSS.filter((String)param[i].getString());
                    }
                    value = values;
                } else {
                    value = param.length < 1 ? Boolean.TRUE : XSS.filter((String)param[0].getString());
                }
                result.put(key, value);
            }
            return result;
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            try {
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
                if (jcrPackage != null) {
                    JcrPackageDefinition pckgDef = jcrPackage.getDefinition();
                    String group = XSS.filter((String)request.getParameter(PackageServlet.PARAM_GROUP));
                    String name = XSS.filter((String)request.getParameter("name"));
                    String version = XSS.filter((String)request.getParameter("version"));
                    if (!(!StringUtils.isNotBlank((CharSequence)name) || PackageUtil.isGroup(pckgDef, group) && PackageUtil.isName(pckgDef, name) && PackageUtil.isVersion(pckgDef, version))) {
                        manager.rename(jcrPackage, group, name, version);
                    }
                    Map<String, Object> parameters = this.getParameters(request);
                    parameters.put("includeVersions", parameters.containsKey("includeVersions"));
                    for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                        String key = parameter.getKey();
                        PackageUtil.DefinitionSetter setter = PackageUtil.DEFINITION_SETTERS.get(key);
                        if (setter == null) continue;
                        Object value = parameter.getValue();
                        try {
                            setter.set(pckgDef, key, value, true);
                        }
                        catch (ParseException ex) {
                            LOG.error("can't parse '" + key + "'='" + value + "' (" + ex.toString() + ")");
                        }
                    }
                    JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                    PackageServlet.jsonAnswer(writer, "update", "successful", manager, jcrPackage);
                } else {
                    response.sendError(404, "Package not found: " + PackageUtil.getPath(request));
                }
            }
            catch (PackageException pex) {
                LOG.error(pex.getMessage(), (Throwable)pex);
                throw new RepositoryException((Throwable)pex);
            }
        }
    }

    protected class CreateOperation
    implements ServletOperation {
        protected CreateOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            String group = XSS.filter((String)request.getParameter(PackageServlet.PARAM_GROUP));
            String name = XSS.filter((String)request.getParameter("name"));
            String version = XSS.filter((String)request.getParameter("version"));
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = manager.create(group, name, version);
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            PackageServlet.jsonAnswer(writer, "create", "successful", manager, jcrPackage);
        }
    }

    protected class QueryOperation
    implements ServletOperation {
        protected QueryOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            String suffix = XSS.filter((String)request.getRequestPathInfo().getSuffix());
            if (suffix.startsWith("/")) {
                suffix = suffix.substring(1);
            }
            suffix = suffix.replaceAll("[ '\"]", "").trim();
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            writer.beginArray();
            if (suffix.length() > 1) {
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                ResourceResolver resolver = request.getResourceResolver();
                String rootPath = manager.getPackageRoot().getPath();
                Iterator found = resolver.findResources("/jcr:root" + rootPath + "//element(*,vlt:PackageDefinition)[jcr:contains(.,'" + suffix + "')]/../..", "xpath");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-DD HH:mm:ss");
                while (found.hasNext()) {
                    String group;
                    JcrPackageDefinition pckgDef;
                    JcrPackage jcrPckg = PackageUtil.getJcrPackage(manager, (Resource)found.next());
                    if (jcrPckg == null || (pckgDef = jcrPckg.getDefinition()) == null || (group = pckgDef.get(PackageServlet.PARAM_GROUP)) == null || group.endsWith("/.snapshot")) continue;
                    String name = pckgDef.get("name");
                    String version = pckgDef.get("version");
                    writer.beginObject();
                    writer.name("state").beginObject();
                    writer.name("installed").value(jcrPckg.isInstalled() ? "on" : "off");
                    writer.name("sealed").value(jcrPckg.isSealed() ? "on" : "off");
                    writer.name("valid").value(jcrPckg.isValid() ? "on" : "off");
                    writer.endObject();
                    writer.name(PackageServlet.PARAM_GROUP).value(group);
                    writer.name("name").value(name);
                    writer.name("version").value(version);
                    writer.name("lastModified").value(dateFormat.format(PackageUtil.getLastModified(jcrPckg).getTime()));
                    writer.name("path").value(Packages.getMode(request) == Packages.Mode.jcrpckg ? PackageUtil.getPackagePath(manager, jcrPckg) : RegistryUtil.toPath((String)null, new PackageId(group, name, version)));
                    writer.endObject();
                }
            }
            writer.endArray();
        }
    }

    protected class TreeOperation
    implements ServletOperation {
        protected TreeOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            TreeNode treeNode = PackageUtil.getTreeNode(manager, request);
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            treeNode.sort();
            treeNode.toJson(writer);
        }
    }

    protected class ListOperation
    implements ServletOperation {
        protected ListOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            List jcrPackages = manager.listPackages();
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            writer.beginArray();
            for (JcrPackage jcrPackage : jcrPackages) {
                new JcrPackageItem(jcrPackage).toJson(writer);
            }
            writer.endArray();
        }
    }

    protected class RegistriesTreeOperation
    implements ServletOperation {
        protected RegistriesTreeOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            BeanContext.Servlet context = new BeanContext.Servlet(PackageServlet.this.getServletContext(), PackageServlet.this.bundleContext, request, response);
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            RegistryTree tree = new RegistryTree(false);
            tree.compactTree();
            this.toJson(writer, (BeanContext)context, tree);
        }

        protected void toJson(JsonWriter writer, BeanContext context, RegistryItem item) throws IOException {
            item.load(context);
            writer.beginObject();
            JsonUtil.jsonMapEntries((JsonWriter)writer, (Map)item);
            writer.name("items").beginArray();
            for (RegistryItem child : item.getItems()) {
                this.toJson(writer, context, child);
            }
            writer.endArray();
            writer.endObject();
        }
    }

    protected class RegistriesOperation
    implements ServletOperation {
        protected RegistriesOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            writer.beginArray();
            if (PackageServlet.this.packageRegistries != null) {
                PackageRegistries.Registries registries = PackageServlet.this.packageRegistries.getRegistries(request.getResourceResolver());
                for (PackageRegistry registry : registries.iterable()) {
                    writer.beginObject();
                    writer.name("type").value(registry.getClass().getSimpleName());
                    writer.name("packages").beginArray();
                    for (PackageId pckgId : registry.packages()) {
                        writer.beginObject();
                        writer.name("id").value(pckgId.toString());
                        writer.name("filename").value(RegistryUtil.getFilename(pckgId));
                        writer.endObject();
                    }
                    writer.endArray();
                    writer.endObject();
                }
            }
            writer.endArray();
        }
    }

    protected class RegistryTreeOperation
    implements ServletOperation {
        protected RegistryTreeOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            BeanContext.Servlet context = new BeanContext.Servlet(PackageServlet.this.getServletContext(), PackageServlet.this.bundleContext, request, response);
            String path = PackageUtil.getPath(request);
            boolean merged = RequestUtil.checkSelector((SlingHttpServletRequest)request, (String)PackageServlet.PARAM_MERGED) || !Packages.REGISTRY_BASED_PATH.matcher(path).matches() && !"/".equals(path);
            RegistryTree tree = new RegistryTree(merged);
            RegistryItem treeItem = tree.getItem((BeanContext)context, path);
            if (treeItem != null) {
                JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                if (!treeItem.isLoaded()) {
                    treeItem.load((BeanContext)context);
                }
                treeItem = treeItem.compactTree();
                treeItem.toTree(writer, true, true);
            } else {
                Status status = new Status(request, response);
                status.setStatus(404);
                status.sendJson();
            }
        }
    }

    protected class PackageManagerModeOperation
    implements ServletOperation {
        protected PackageManagerModeOperation() {
        }

        public void doIt(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Packages.Mode mode;
            Status status;
            block5: {
                status = new Status(request, response);
                mode = Packages.Mode.jcrpckg;
                try {
                    mode = Packages.Mode.valueOf(request.getParameter("mode"));
                }
                catch (Exception ex) {
                    RequestPathInfo pathInfo;
                    String suffix;
                    if (RequestUtil.checkSelector((SlingHttpServletRequest)request, (String)Packages.Mode.regpckg.name())) {
                        mode = Packages.Mode.regpckg;
                    }
                    if (RequestUtil.checkSelector((SlingHttpServletRequest)request, (String)Packages.Mode.jcrpckg.name()) || !StringUtils.isNotBlank((CharSequence)(suffix = (pathInfo = request.getRequestPathInfo()).getSuffix())) || !suffix.startsWith("/")) break block5;
                    suffix = suffix.substring(1);
                    try {
                        mode = Packages.Mode.valueOf(suffix);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            HttpSession session = request.getSession(true);
            session.setAttribute(Packages.SA_PCKGMGR_MODE, (Object)mode.name());
            status.data("pckgmgr").put("mode", mode.name());
            status.sendJson();
        }
    }

    public class PackageOperationSet
    extends ServletOperationSet<Extension, Operation> {
        public PackageOperationSet() {
            super((Enum)Extension.json);
        }

        public ResourceHandle getResource(SlingHttpServletRequest request) {
            Resource resource = null;
            try {
                String path = PackageUtil.getPath(request);
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                resource = PackageUtil.getResource(manager, request, path);
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
            return ResourceHandle.use(resource);
        }
    }

    public static enum Operation {
        create,
        update,
        delete,
        download,
        upload,
        install,
        uninstall,
        deploy,
        service,
        list,
        tree,
        view,
        query,
        coverage,
        filterList,
        filterChange,
        filterAdd,
        filterRemove,
        filterMoveUp,
        filterMoveDown,
        cleanup,
        cleanupObsoleteVersions,
        mode,
        registryTree,
        registries,
        registriesTree,
        thumbnail;

    }

    public static enum Extension {
        html,
        json,
        zip;

    }
}

