/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers.util;

import org.xml.sax.SAXException;

public class Namespaces {
    private String[] uri = new String[512];
    private String[] pre = new String[512];
    private int depth = 0;
    private int last = 0;
    public static final int NAMESPACE_PREFIX = 0;
    public static final int NAMESPACE_URI = 1;

    public Namespaces() {
        this.push("", "");
        this.push("xml", "http://www.w3.org/XML/1998/namespace");
        this.last = this.depth;
    }

    public synchronized void push(String prefix, String uri) {
        if (this.depth == this.uri.length) {
            int newDepth = this.uri.length + (this.uri.length >> 1);
            String[] newUri = new String[newDepth];
            String[] newPre = new String[newDepth];
            System.arraycopy(this.uri, 0, newUri, 0, this.depth);
            System.arraycopy(this.pre, 0, newPre, 0, this.depth);
            this.uri = newUri;
            this.pre = newPre;
        }
        this.uri[this.depth] = uri;
        this.pre[this.depth] = prefix;
        ++this.depth;
    }

    public synchronized void pop(String prefix) throws SAXException {
        for (int x = this.position(prefix, this.pre); x < this.depth; ++x) {
            int k = x + 1;
            this.pre[x] = this.pre[k];
            this.uri[x] = this.uri[k];
        }
        --this.last;
        --this.depth;
    }

    public String qualify(String nsuri, String local, String qualified) throws SAXException {
        if (nsuri == null) {
            nsuri = "";
        }
        if (local == null) {
            local = "";
        }
        if (qualified == null) {
            qualified = "";
        }
        if (nsuri.length() == 0 && local.length() == 0) {
            return qualified;
        }
        int position = this.position(nsuri, this.uri);
        if (this.pre[position].length() > 0) {
            return this.pre[position] + ':' + local;
        }
        return local;
    }

    public String[][] commit() {
        int size = this.depth - this.last;
        String[][] result = new String[size][2];
        int k = 0;
        for (int x = this.last; x < this.depth; ++x) {
            result[k][0] = this.pre[x];
            result[k][1] = this.uri[x];
            ++k;
        }
        this.last = this.depth;
        return result;
    }

    public String getUri(String prefix) throws SAXException {
        return this.uri[this.position(prefix, this.pre)];
    }

    public String getPrefix(String nsuri) throws SAXException {
        return this.pre[this.position(nsuri, this.uri)];
    }

    private int position(String check, String[] array) throws SAXException {
        int x = this.depth;
        do {
            if (!check.equals(array[--x])) continue;
            return x;
        } while (x != 0);
        throw new SAXException("Unable to map \"" + check + "\"");
    }
}

