/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import javax.jcr.nodetype.NodeDefinition;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.plugins.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.plugins.version.VersionExceptionCode;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.lock.LockConstants;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.version.VersionConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VersionEditor
implements Editor {
    private final VersionEditor parent;
    private final ReadWriteVersionManager vMgr;
    private final NodeBuilder node;
    private final String name;
    private Boolean isVersionable = null;
    private NodeState before;
    private NodeState after;
    private boolean isReadOnly;
    private CommitInfo commitInfo;

    public VersionEditor(@NotNull NodeBuilder versionStore, @NotNull NodeBuilder workspaceRoot, @NotNull CommitInfo commitInfo) {
        this(null, new ReadWriteVersionManager((NodeBuilder)Preconditions.checkNotNull((Object)versionStore), (NodeBuilder)Preconditions.checkNotNull((Object)workspaceRoot)), workspaceRoot, "", commitInfo);
    }

    VersionEditor(@Nullable VersionEditor parent, @NotNull ReadWriteVersionManager vMgr, @NotNull NodeBuilder node, @NotNull String name, @NotNull CommitInfo commitInfo) {
        this.parent = parent;
        this.vMgr = (ReadWriteVersionManager)Preconditions.checkNotNull((Object)vMgr);
        this.node = (NodeBuilder)Preconditions.checkNotNull((Object)node);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.commitInfo = commitInfo;
    }

    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        this.before = before;
        this.after = after;
        if (this.isVersionable()) {
            this.vMgr.getOrCreateVersionHistory(this.node, this.commitInfo.getInfo());
        }
        this.isReadOnly = after.exists() || this.isVersionable() ? this.wasCheckedIn() && !this.hasNewIdentifier() && !this.isIgnoreOnOPV() : this.parent != null && this.parent.isReadOnly && !this.isIgnoreOnOPV();
    }

    public void leave(NodeState before, NodeState after) throws CommitFailedException {
    }

    public void propertyAdded(PropertyState after) throws CommitFailedException {
        if (after.getName().equals("jcr:baseVersion") && this.after.hasProperty("jcr:versionHistory") && !this.after.hasProperty("jcr:isCheckedOut") && !this.before.exists()) {
            this.vMgr.restore(this.node, (String)after.getValue(Type.REFERENCE), null);
            return;
        }
        if (!this.isReadOnly || this.getOPV(after) == 5) {
            return;
        }
        if (after.getName().equals("jcr:lockOwner") || after.getName().equals("jcr:lockIsDeep")) {
            return;
        }
        VersionEditor.throwCheckedIn("Cannot add property " + after.getName() + " on checked in node");
    }

    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (!this.isVersionable()) {
            if (!this.isVersionProperty(after) && this.isReadOnly && this.getOPV(after) != 5) {
                VersionEditor.throwCheckedIn("Cannot change property " + after.getName() + " on checked in node");
            }
            return;
        }
        String propName = after.getName();
        if (propName.equals("jcr:isCheckedOut")) {
            if (this.wasCheckedIn()) {
                this.vMgr.checkout(this.node);
            } else {
                this.vMgr.checkin(this.node);
            }
        } else if (propName.equals("jcr:baseVersion")) {
            String baseVersion = (String)after.getValue(Type.REFERENCE);
            if (baseVersion.startsWith("restore-")) {
                baseVersion = baseVersion.substring("restore-".length());
                this.node.setProperty("jcr:baseVersion", (Object)baseVersion, Type.REFERENCE);
            }
            this.vMgr.restore(this.node, baseVersion, null);
        } else if (this.isVersionProperty(after)) {
            VersionEditor.throwProtected(after.getName());
        } else if (this.isReadOnly && this.getOPV(after) != 5) {
            VersionEditor.throwCheckedIn("Cannot change property " + after.getName() + " on checked in node");
        }
    }

    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        if (this.isReadOnly && !this.isVersionProperty(before) && !this.isLockProperty(before) && this.getOPV(before) != 5) {
            VersionEditor.throwCheckedIn("Cannot delete property on checked in node");
        }
    }

    public Editor childNodeAdded(String name, NodeState after) {
        return this.childNodeChanged(name, EmptyNodeState.MISSING_NODE, after);
    }

    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return new VersionEditor(this, this.vMgr, this.node.child(name), name, this.commitInfo);
    }

    public Editor childNodeDeleted(String name, NodeState before) {
        return new VersionEditor(this, this.vMgr, EmptyNodeState.MISSING_NODE.builder(), name, this.commitInfo);
    }

    private boolean isVersionable() {
        if (this.isVersionable == null) {
            this.isVersionable = this.vMgr.isVersionable(this.after);
        }
        return this.isVersionable;
    }

    private boolean isVersionProperty(PropertyState state) {
        return VersionConstants.VERSION_PROPERTY_NAMES.contains(state.getName());
    }

    private boolean isLockProperty(PropertyState state) {
        return LockConstants.LOCK_PROPERTY_NAMES.contains(state.getName());
    }

    private boolean wasCheckedIn() {
        PropertyState prop = this.before.getProperty("jcr:isCheckedOut");
        if (prop != null) {
            return (Boolean)prop.getValue(Type.BOOLEAN) == false && this.isVersionable();
        }
        return this.parent != null && this.parent.wasCheckedIn();
    }

    private boolean hasNewIdentifier() {
        String afterId;
        String beforeId = this.buildBeforeIdentifier(new StringBuilder()).toString();
        return !beforeId.equals(afterId = this.buildAfterIdentifier(new StringBuilder()).toString());
    }

    private StringBuilder buildBeforeIdentifier(StringBuilder identifier) {
        String uuid = this.before.getString("jcr:uuid");
        if (uuid != null) {
            identifier.append(uuid);
        } else if (this.parent != null) {
            this.parent.buildBeforeIdentifier(identifier);
            identifier.append("/").append(this.name);
        }
        return identifier;
    }

    private StringBuilder buildAfterIdentifier(StringBuilder identifier) {
        String uuid = this.after.getString("jcr:uuid");
        if (uuid != null) {
            identifier.append(uuid);
        } else if (this.parent != null) {
            this.parent.buildAfterIdentifier(identifier);
            identifier.append("/").append(this.name);
        }
        return identifier;
    }

    private static void throwCheckedIn(String msg) throws CommitFailedException {
        throw new CommitFailedException("Version", VersionExceptionCode.NODE_CHECKED_IN.ordinal(), msg);
    }

    private static void throwProtected(String name) throws CommitFailedException {
        throw new CommitFailedException("Constraint", 100, "Property is protected: " + name);
    }

    private boolean isIgnoreOnOPV() throws CommitFailedException {
        if (this.parent != null) {
            try {
                NodeDefinition definition = this.vMgr.getNodeTypeManager().getDefinition(TreeFactory.createTree(this.parent.node), this.name);
                return definition.getOnParentVersion() == 5;
            }
            catch (Exception e) {
                throw new CommitFailedException("Version", VersionExceptionCode.UNEXPECTED_REPOSITORY_EXCEPTION.ordinal(), e.getMessage());
            }
        }
        return false;
    }

    private int getOPV(PropertyState property) throws CommitFailedException {
        try {
            return this.vMgr.getNodeTypeManager().getDefinition(TreeFactory.createReadOnlyTree(this.node.getNodeState()), property, false).getOnParentVersion();
        }
        catch (Exception e) {
            throw new CommitFailedException("Version", VersionExceptionCode.UNEXPECTED_REPOSITORY_EXCEPTION.ordinal(), e.getMessage());
        }
    }
}

